/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.cdap.zendesk;

import io.cdap.cdap.api.data.format.StructuredRecord;
import java.util.Map;
import org.apache.beam.examples.complete.cdap.utils.StructuredRecordUtils;
import org.apache.beam.examples.complete.cdap.zendesk.options.CdapZendeskOptions;
import org.apache.beam.examples.complete.cdap.zendesk.transforms.FormatInputTransform;
import org.apache.beam.examples.complete.cdap.zendesk.utils.PluginConfigOptionsConverter;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.hadoop.WritableCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.MapValues;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.hadoop.io.NullWritable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdapZendeskToTxt {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CdapZendeskToTxt.class);

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        CdapZendeskOptions options = (CdapZendeskOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(CdapZendeskOptions.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        CdapZendeskToTxt.run(pipeline, options);
    }

    public static @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized CdapZendeskOptions options) {
        Map<String, Object> pluginConfigParams = PluginConfigOptionsConverter.zendeskOptionsToParamsMap(options);
        LOG.info("Starting Cdap-Zendesk-To-Txt pipeline with parameters: {}", pluginConfigParams);
        ((PCollection)((PCollection)((PCollection)pipeline.apply("readFromCdapZendesk", FormatInputTransform.readFromCdapZendesk(pluginConfigParams))).setCoder((Coder)KvCoder.of((Coder)NullableCoder.of((Coder)WritableCoder.of(NullWritable.class)), (Coder)SerializableCoder.of(StructuredRecord.class))).apply((PTransform)MapValues.into((TypeDescriptor)TypeDescriptors.strings()).via(StructuredRecordUtils::structuredRecordToString))).setCoder((Coder)KvCoder.of((Coder)NullableCoder.of((Coder)WritableCoder.of(NullWritable.class)), (Coder)StringUtf8Coder.of())).apply((PTransform)Values.create())).apply("writeToTxt", (PTransform)TextIO.write().to(options.getOutputTxtFilePathPrefix()));
        return pipeline.run();
    }
}

