/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.cdap.salesforce.utils;

import com.google.gson.Gson;
import io.cdap.plugin.salesforce.plugin.sink.batch.CSVRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CsvRecordCoder
extends CustomCoder<CSVRecord> {
    private static final @UnknownKeyFor @NonNull @Initialized Gson GSON = new Gson();
    private static final @UnknownKeyFor @NonNull @Initialized CsvRecordCoder CODER = new CsvRecordCoder();
    private static final @UnknownKeyFor @NonNull @Initialized StringUtf8Coder STRING_CODER = StringUtf8Coder.of();

    public static @UnknownKeyFor @NonNull @Initialized CsvRecordCoder of() {
        return CODER;
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized CSVRecord value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        STRING_CODER.encode(GSON.toJson((Object)value), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized CSVRecord decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return (CSVRecord)GSON.fromJson(STRING_CODER.decode(inStream), CSVRecord.class);
    }
}

