/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.cdap.salesforce;

import com.google.gson.Gson;
import io.cdap.plugin.salesforce.plugin.sink.batch.CSVRecord;
import java.io.Serializable;
import java.util.Map;
import org.apache.beam.examples.complete.cdap.salesforce.options.CdapSalesforceSinkOptions;
import org.apache.beam.examples.complete.cdap.salesforce.transforms.FormatOutputTransform;
import org.apache.beam.examples.complete.cdap.salesforce.utils.CsvRecordCoder;
import org.apache.beam.examples.complete.cdap.salesforce.utils.PluginConfigOptionsConverter;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.hadoop.WritableCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.hadoop.io.NullWritable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxtToCdapSalesforce {
    private static final @UnknownKeyFor @NonNull @Initialized Gson GSON = new Gson();
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TxtToCdapSalesforce.class);

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        CdapSalesforceSinkOptions options = (CdapSalesforceSinkOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(CdapSalesforceSinkOptions.class);
        Preconditions.checkStateNotNull((Object)options.getLocksDirPath(), (Object)"locksDirPath can not be null!");
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        TxtToCdapSalesforce.run(pipeline, options);
    }

    public static @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized CdapSalesforceSinkOptions options) {
        Map<String, Object> paramsMap = PluginConfigOptionsConverter.salesforceBatchSinkOptionsToParamsMap(options);
        LOG.info("Starting Txt-to-Cdap-Salesforce pipeline with parameters: {}", paramsMap);
        ((PCollection)((PCollection)pipeline.apply("readFromTxt", (PTransform)TextIO.read().from(options.getInputTxtFilePath()))).apply((PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<KV<NullWritable, CSVRecord>>(){}).via((SerializableFunction & Serializable)json -> {
            CSVRecord csvRecord = (CSVRecord)GSON.fromJson(json, CSVRecord.class);
            return KV.of((Object)NullWritable.get(), (Object)csvRecord);
        }))).setCoder((Coder)KvCoder.of((Coder)NullableCoder.of((Coder)WritableCoder.of(NullWritable.class)), (Coder)CsvRecordCoder.of())).apply("writeToCdapSalesforce", FormatOutputTransform.writeToCdapSalesforce(paramsMap, options.getLocksDirPath()));
        return pipeline.run();
    }
}

