/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.cdap.salesforce;

import io.cdap.cdap.api.data.schema.Schema;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.beam.examples.complete.cdap.salesforce.options.CdapSalesforceSourceOptions;
import org.apache.beam.examples.complete.cdap.salesforce.transforms.FormatInputTransform;
import org.apache.beam.examples.complete.cdap.salesforce.utils.PluginConfigOptionsConverter;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.MapValues;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdapSalesforceToTxt {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CdapSalesforceToTxt.class);

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        CdapSalesforceSourceOptions options = (CdapSalesforceSourceOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(CdapSalesforceSourceOptions.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        CdapSalesforceToTxt.run(pipeline, options);
    }

    public static @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized CdapSalesforceSourceOptions options) {
        Map<String, Object> paramsMap = PluginConfigOptionsConverter.salesforceBatchSourceOptionsToParamsMap(options);
        LOG.info("Starting Cdap-Salesforce pipeline with parameters: {}", paramsMap);
        ((PCollection)((PCollection)((PCollection)pipeline.apply("readFromCdapSalesforce", FormatInputTransform.readFromCdapSalesforce(paramsMap))).setCoder((Coder)KvCoder.of((Coder)SerializableCoder.of(Schema.class), (Coder)SerializableCoder.of(LinkedHashMap.class))).apply((PTransform)MapValues.into((TypeDescriptor)TypeDescriptors.strings()).via(AbstractMap::toString))).setCoder((Coder)KvCoder.of((Coder)SerializableCoder.of(Schema.class), (Coder)StringUtf8Coder.of())).apply((PTransform)Values.create())).apply("writeToTxt", (PTransform)TextIO.write().to(options.getOutputTxtFilePathPrefix()));
        return pipeline.run();
    }
}

