/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.cdap.salesforce;

import java.util.Map;
import org.apache.beam.examples.complete.cdap.salesforce.options.CdapSalesforceStreamingSourceOptions;
import org.apache.beam.examples.complete.cdap.salesforce.transforms.FormatInputTransform;
import org.apache.beam.examples.complete.cdap.salesforce.utils.PluginConfigOptionsConverter;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.hadoop.WritableCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hadoop.io.NullWritable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdapSalesforceStreamingToTxt {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(CdapSalesforceStreamingToTxt.class);

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) {
        CdapSalesforceStreamingSourceOptions options = (CdapSalesforceStreamingSourceOptions)PipelineOptionsFactory.fromArgs((String[])args).withValidation().as(CdapSalesforceStreamingSourceOptions.class);
        Pipeline pipeline = Pipeline.create((PipelineOptions)options);
        CdapSalesforceStreamingToTxt.run(pipeline, options);
    }

    public static @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized CdapSalesforceStreamingSourceOptions options) {
        Map<String, Object> paramsMap = PluginConfigOptionsConverter.salesforceStreamingSourceOptionsToParamsMap(options);
        LOG.info("Starting Cdap-Salesforce-streaming-to-txt pipeline with parameters: {}", paramsMap);
        ((PCollection)((PCollection)((PCollection)pipeline.apply("readFromCdapSalesforceStreaming", FormatInputTransform.readFromCdapSalesforceStreaming(paramsMap, options.getPullFrequencySec(), options.getStartOffset()))).setCoder((Coder)KvCoder.of((Coder)NullableCoder.of((Coder)WritableCoder.of(NullWritable.class)), (Coder)StringUtf8Coder.of())).apply("globalwindow", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterProcessingTime.pastFirstElementInPane())).discardingFiredPanes())).apply((PTransform)Values.create())).apply("writeToTxt", (PTransform)TextIO.write().withWindowedWrites().withNumShards(1).to(options.getOutputTxtFilePathPrefix()));
        return pipeline.run();
    }
}

