/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.cdap.salesforce.utils;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import io.cdap.plugin.salesforce.plugin.source.streaming.SalesforceStreamingSource;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.reflect.TypeToken;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOffsetUtils {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(GetOffsetUtils.class);
    private static final @UnknownKeyFor @NonNull @Initialized Gson GSON = new Gson();
    private static final @UnknownKeyFor @NonNull @Initialized String SALESFORCE_EVENT = "event";
    private static final @UnknownKeyFor @NonNull @Initialized String SALESFORCE_REPLAY_ID = "replayId";

    public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> getOffsetFnForCdapPlugin(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> pluginClass) {
        if (SalesforceStreamingSource.class.equals(pluginClass)) {
            return GetOffsetUtils.getOffsetFnForSalesforce();
        }
        throw new UnsupportedOperationException(String.format("Given plugin class '%s' is not supported!", pluginClass.getName()));
    }

    private static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Long> getOffsetFnForSalesforce() {
        return (SerializableFunction & Serializable)input -> {
            if (input != null) {
                try {
                    HashMap json = (HashMap)GSON.fromJson(input, new TypeToken<HashMap<String, Object>>(){}.getType());
                    Preconditions.checkArgumentNotNull((Object)json, (Object)"Can not get JSON from Salesforce input string");
                    LinkedTreeMap fieldMap = (LinkedTreeMap)json.get(SALESFORCE_EVENT);
                    if (fieldMap != null) {
                        Object id = fieldMap.get((Object)SALESFORCE_REPLAY_ID);
                        Preconditions.checkArgumentNotNull((Object)id, (Object)"Can not get Replay ID from Salesforce input string");
                        return ((Double)id).longValue();
                    }
                }
                catch (Exception e) {
                    LOG.error("Can not get offset from json", (Throwable)e);
                }
            }
            return 0L;
        };
    }
}

