/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.cdap.salesforce.transforms;

import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceBatchSource;
import io.cdap.plugin.salesforce.plugin.source.batch.SalesforceSourceConfig;
import io.cdap.plugin.salesforce.plugin.source.streaming.SalesforceReceiver;
import io.cdap.plugin.salesforce.plugin.source.streaming.SalesforceStreamingSource;
import io.cdap.plugin.salesforce.plugin.source.streaming.SalesforceStreamingSourceConfig;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.beam.examples.complete.cdap.salesforce.utils.GetOffsetUtils;
import org.apache.beam.sdk.io.cdap.CdapIO;
import org.apache.beam.sdk.io.cdap.ConfigWrapper;
import org.apache.beam.sdk.io.cdap.Plugin;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.hadoop.io.NullWritable;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FormatInputTransform {
    public static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized CdapIO.Read<@UnknownKeyFor @NonNull @Initialized Schema, @UnknownKeyFor @NonNull @Initialized LinkedHashMap> readFromCdapSalesforce(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> pluginConfigParams) {
        SalesforceSourceConfig pluginConfig = (SalesforceSourceConfig)new ConfigWrapper(SalesforceSourceConfig.class).withParams(pluginConfigParams).build();
        Preconditions.checkStateNotNull((Object)pluginConfig, (Object)"Plugin config can't be null.");
        return CdapIO.read().withCdapPluginClass(SalesforceBatchSource.class).withPluginConfig((PluginConfig)pluginConfig).withKeyClass(Schema.class).withValueClass(LinkedHashMap.class);
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized CdapIO.Read<@UnknownKeyFor @NonNull @Initialized NullWritable, @UnknownKeyFor @NonNull @Initialized String> readFromCdapSalesforceStreaming(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> pluginConfigParams, @UnknownKeyFor @NonNull @Initialized Long pullFrequencySec, @UnknownKeyFor @NonNull @Initialized Long startOffset) {
        SalesforceStreamingSourceConfig pluginConfig = (SalesforceStreamingSourceConfig)new ConfigWrapper(SalesforceStreamingSourceConfig.class).withParams(pluginConfigParams).build();
        Preconditions.checkStateNotNull((Object)pluginConfig, (Object)"Plugin config can't be null.");
        pluginConfig.ensurePushTopicExistAndWithCorrectFields();
        CdapIO.Read read = CdapIO.read().withCdapPlugin(Plugin.createStreaming(SalesforceStreamingSource.class, GetOffsetUtils.getOffsetFnForCdapPlugin(SalesforceStreamingSource.class), SalesforceReceiver.class, (SerializableFunction & Serializable)config -> {
            SalesforceStreamingSourceConfig salesforceConfig = (SalesforceStreamingSourceConfig)config;
            return new Object[]{salesforceConfig.getAuthenticatorCredentials(), salesforceConfig.getPushTopicName()};
        })).withPluginConfig((PluginConfig)pluginConfig).withKeyClass(NullWritable.class).withValueClass(String.class);
        if (pullFrequencySec != null) {
            read = read.withPullFrequencySec(pullFrequencySec);
        }
        if (startOffset != null) {
            read = read.withStartOffset(startOffset);
        }
        return read;
    }
}

