/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.cdap.salesforce.options;

import org.apache.beam.examples.complete.cdap.salesforce.options.CdapSalesforceOptions;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Validation;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface CdapSalesforceSinkOptions
extends CdapSalesforceOptions {
    @Validation.Required
    @Description(value="Strategy used to handle erroneous records.\nSKIP - Ignores erroneous records.\nSTOP - Fails pipeline due to erroneous record.")
    public @UnknownKeyFor @NonNull @Initialized String getErrorHandling();

    public void setErrorHandling(@UnknownKeyFor @NonNull @Initialized String var1);

    @Validation.Required
    @Description(value="Maximum size in bytes of a batch of records when writing to Salesforce. This value cannot be greater than 10,000,000.")
    public @UnknownKeyFor @NonNull @Initialized String getMaxBytesPerBatch();

    public void setMaxBytesPerBatch(@UnknownKeyFor @NonNull @Initialized String var1);

    @Validation.Required
    @Description(value="Maximum number of records to include in a batch when writing to Salesforce.This value cannot be greater than 10,000.")
    public @UnknownKeyFor @NonNull @Initialized String getMaxRecordsPerBatch();

    public void setMaxRecordsPerBatch(@UnknownKeyFor @NonNull @Initialized String var1);

    @Validation.Required
    @Description(value="Operation used for sinking data into Salesforce.\nInsert - adds records.\nUpsert - upserts the records. Salesforce will decide if sObjects are the same using external id field.\nUpdate - updates existing records based on Id field.")
    public @UnknownKeyFor @NonNull @Initialized String getOperation();

    public void setOperation(@UnknownKeyFor @NonNull @Initialized String var1);

    @Validation.Required
    @Description(value="Salesforce object name to insert records into.")
    public @UnknownKeyFor @NonNull @Initialized String getsObject();

    public void setsObject(@UnknownKeyFor @NonNull @Initialized String var1);

    @Validation.Required
    @Description(value="Locks directory path where locks will be stored.This parameter is needed for Hadoop External Synchronization(mechanism for acquiring locks related to the write job).")
    public @UnknownKeyFor @NonNull @Initialized String getLocksDirPath();

    public void setLocksDirPath(@UnknownKeyFor @NonNull @Initialized String var1);

    @Validation.Required
    @Description(value="Input .txt file path with Salesforce records.")
    public @UnknownKeyFor @NonNull @Initialized String getInputTxtFilePath();

    public void setInputTxtFilePath(@UnknownKeyFor @NonNull @Initialized String var1);
}

