CREATE TABLE BATCH_CHECKPOINT (id VARCHAR2(255) NOT NULL, data BLOB, stepName VARCHAR2(255), type VARCHAR2(20), INSTANCE_JOBINSTANCEID NUMBER, PRIMARY KEY (id));
CREATE TABLE BATCH_JOBEXECUTION (executionId NUMBER NOT NULL, batchStatus VARCHAR2(20), createTime TIMESTAMP, endTime TIMESTAMP, exitStatus VARCHAR2(255), jobProperties CLOB, startTime TIMESTAMP, updateTime TIMESTAMP, INSTANCE_JOBINSTANCEID NUMBER, PRIMARY KEY (executionId));
CREATE TABLE BATCH_JOBINSTANCE (jobInstanceId NUMBER NOT NULL, batchStatus VARCHAR2(20), exitStatus VARCHAR2(255), jobXml CLOB, latestExecution NUMBER, name VARCHAR2(255), restartOn VARCHAR2(255), step VARCHAR2(255), PRIMARY KEY (jobInstanceId));
CREATE TABLE BATCH_STEPEXECUTION (id NUMBER NOT NULL, batchStatus VARCHAR2(20), exec_commit NUMBER, endTime TIMESTAMP, exitStatus VARCHAR2(255), exec_filter NUMBER, lastRunStepExecutionId NUMBER, numPartitions NUMBER, persistentData BLOB, exec_processskip NUMBER, exec_read NUMBER, exec_readskip NUMBER, exec_rollback NUMBER, startCount NUMBER, startTime TIMESTAMP, stepName VARCHAR2(255), exec_write NUMBER, exec_writeskip NUMBER, EXECUTION_EXECUTIONID NUMBER, PRIMARY KEY (id));
CREATE TABLE OPENJPA_SEQUENCE_TABLE (ID NUMBER NOT NULL, SEQUENCE_VALUE NUMBER, PRIMARY KEY (ID));
CREATE INDEX I_BTCHPNT_INSTANCE ON BATCH_CHECKPOINT (INSTANCE_JOBINSTANCEID);
CREATE INDEX I_BTCHCTN_INSTANCE ON BATCH_JOBEXECUTION (INSTANCE_JOBINSTANCEID);
CREATE INDEX I_BTCHCTN_EXECUTION ON BATCH_STEPEXECUTION (EXECUTION_EXECUTIONID);
