CREATE TABLE BATCH_CHECKPOINT -- CheckpointEntity
    (id VARCHAR(255) NOT NULL, data BLOB, stepName VARCHAR(255), type VARCHAR(20), INSTANCE_JOBINSTANCEID BIGINT, PRIMARY KEY (id));
CREATE TABLE BATCH_JOBEXECUTION -- JobExecutionEntity
    (executionId BIGINT NOT NULL, batchStatus VARCHAR(20), createTime TIMESTAMP, endTime TIMESTAMP, exitStatus VARCHAR(255), jobProperties CLOB, startTime TIMESTAMP, updateTime TIMESTAMP, INSTANCE_JOBINSTANCEID BIGINT, PRIMARY KEY (executionId));
CREATE TABLE BATCH_JOBINSTANCE -- JobInstanceEntity
    (jobInstanceId BIGINT NOT NULL, batchStatus VARCHAR(20), exitStatus VARCHAR(255), jobXml CLOB, latestExecution BIGINT, name VARCHAR(255), restartOn VARCHAR(255), step VARCHAR(255), PRIMARY KEY (jobInstanceId));
CREATE TABLE BATCH_STEPEXECUTION -- StepExecutionEntity
    (id BIGINT NOT NULL, batchStatus VARCHAR(20), exec_commit BIGINT, endTime TIMESTAMP, exitStatus VARCHAR(255), exec_filter BIGINT, lastRunStepExecutionId BIGINT, numPartitions INTEGER, persistentData BLOB, exec_processskip BIGINT, exec_read BIGINT, exec_readskip BIGINT, exec_rollback BIGINT, startCount INTEGER, startTime TIMESTAMP, stepName VARCHAR(255), exec_write BIGINT, exec_writeskip BIGINT, EXECUTION_EXECUTIONID BIGINT, PRIMARY KEY (id));
CREATE TABLE OPENJPA_SEQUENCE_TABLE (ID SMALLINT NOT NULL, SEQUENCE_VALUE BIGINT, PRIMARY KEY (ID));
CREATE INDEX I_BTCHPNT_INSTANCE ON BATCH_CHECKPOINT (INSTANCE_JOBINSTANCEID);
CREATE INDEX I_BTCHCTN_INSTANCE ON BATCH_JOBEXECUTION (INSTANCE_JOBINSTANCEID);
CREATE INDEX I_BTCHCTN_EXECUTION ON BATCH_STEPEXECUTION (EXECUTION_EXECUTIONID);
