/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bahir.sql.streaming.mqtt;

import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bahir.sql.streaming.mqtt.CachedMQTTClient$;
import org.apache.bahir.sql.streaming.mqtt.MQTTTestUtils;
import org.apache.bahir.sql.streaming.mqtt.MQTTTestUtils$;
import org.apache.bahir.utils.FileHelper$;
import org.apache.spark.SharedSparkContext;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.execution.streaming.MemoryStream;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import scala.Function0;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0001\u0003\u0001=\u00111#T)U)N#(/Z1n'&t7nU;ji\u0016T!a\u0001\u0003\u0002\t5\fH\u000f\u001e\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006E\u0006D\u0017N\u001d\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001b#\u0007\t\u0003#Qi\u0011A\u0005\u0006\u0003')\tQa\u001d9be.L!!\u0006\n\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\tr#\u0003\u0002\u0019%\t\u00112\u000b[1sK\u0012\u001c\u0006/\u0019:l\u0007>tG/\u001a=u!\tQR$D\u0001\u001c\u0015\taB\"A\u0005tG\u0006d\u0017\r^3ti&\u0011ad\u0007\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s\u0011!\u0001\u0003A!A!\u0002\u0013\t\u0013\u0001B0tg2\u0004\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012qAQ8pY\u0016\fg\u000eC\u0003)\u0001\u0011\u0005\u0011&\u0001\u0004=S:LGO\u0010\u000b\u0003U1\u0002\"a\u000b\u0001\u000e\u0003\tAQ\u0001I\u0014A\u0002\u0005B\u0011B\f\u0001A\u0002\u0003\u0007I\u0011C\u0018\u0002\u001b5\fH\u000f\u001e+fgR,F/\u001b7t+\u0005\u0001\u0004CA\u00162\u0013\t\u0011$AA\u0007N#R#F+Z:u+RLGn\u001d\u0005\ni\u0001\u0001\r\u00111A\u0005\u0012U\n\u0011#\\9uiR+7\u000f^+uS2\u001cx\fJ3r)\t1\u0014\b\u0005\u0002#o%\u0011\u0001h\t\u0002\u0005+:LG\u000fC\u0004;g\u0005\u0005\t\u0019\u0001\u0019\u0002\u0007a$\u0013\u0007C\u0005=\u0001\u0001\u0007\t\u0011)Q\u0005a\u0005qQ.\u001d;u)\u0016\u001cH/\u0016;jYN\u0004\u0003b\u0002 \u0001\u0005\u0004%\tbP\u0001\bi\u0016l\u0007\u000fR5s+\u0005\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\tIwNC\u0001F\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0013%\u0001\u0002$jY\u0016Da!\u0013\u0001!\u0002\u0013\u0001\u0015\u0001\u0003;f[B$\u0015N\u001d\u0011\t\u000f-\u0003!\u0019!C\t\u0019\u0006AQ.Z:tC\u001e,7/F\u0001N!\u0011q5+\u0016-\u000e\u0003=S!\u0001U)\u0002\u000f5,H/\u00192mK*\u0011!kI\u0001\u000bG>dG.Z2uS>t\u0017B\u0001+P\u0005\u001dA\u0015m\u001d5NCB\u0004\"A\t,\n\u0005]\u001b#aA%oiB\u0011\u0011\f\u0019\b\u00035z\u0003\"aW\u0012\u000e\u0003qS!!\u0018\b\u0002\rq\u0012xn\u001c;?\u0013\ty6%\u0001\u0004Qe\u0016$WMZ\u0005\u0003C\n\u0014aa\u0015;sS:<'BA0$\u0011\u0019!\u0007\u0001)A\u0005\u001b\u0006IQ.Z:tC\u001e,7\u000f\t\u0005\nM\u0002\u0001\r\u00111A\u0005\u0012\u001d\f!\u0002^3ti\u000ec\u0017.\u001a8u+\u0005A\u0007CA5s\u001b\u0005Q'BA6m\u0003\u0019i\u0017\u000f\u001e;wg)\u0011QN\\\u0001\u0007G2LWM\u001c;\u000b\u0005=\u0004\u0018\u0001\u00029bQ>T!!\u001d\u0007\u0002\u000f\u0015\u001cG.\u001b9tK&\u00111O\u001b\u0002\u000b\u001bF$Ho\u00117jK:$\b\"C;\u0001\u0001\u0004\u0005\r\u0011\"\u0005w\u00039!Xm\u001d;DY&,g\u000e^0%KF$\"AN<\t\u000fi\"\u0018\u0011!a\u0001Q\"I\u0011\u0010\u0001a\u0001\u0002\u0003\u0006K\u0001[\u0001\fi\u0016\u001cHo\u00117jK:$\b\u0005C\u0003|\u0001\u0011EA0\u0001\nde\u0016\fG/Z\"p]R,\u0007\u0010^!oI\u00123EcA?\u0002*A1!E`A\u0001\u0003\u0017I!a`\u0012\u0003\rQ+\b\u000f\\33!\u0011\t\u0019!a\u0002\u000e\u0005\u0005\u0015!BA\u0004\u0013\u0013\u0011\tI!!\u0002\u0003\u0015M\u000bFjQ8oi\u0016DH\u000f\u0005\u0003\u0002\u000e\u0005\rb\u0002BA\b\u0003?qA!!\u0005\u0002\u001e9!\u00111CA\u000e\u001d\u0011\t)\"!\u0007\u000f\u0007m\u000b9\"C\u0001\u000e\u0013\tYA\"\u0003\u0002\u0014\u0015%\u0011qAE\u0005\u0005\u0003C\t)!A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0012q\u0005\u0002\n\t\u0006$\u0018M\u0012:b[\u0016TA!!\t\u0002\u0006!11J\u001fa\u0001\u0003W\u0001BAIA\u00171&\u0019\u0011qF\u0012\u0003\u0015q\u0012X\r]3bi\u0016$g\bC\u0004\u00024\u0001!\t\"!\u000e\u0002\u0015M,g\u000e\u001a+p\u001bF#F\u000b\u0006\u0003\u00028\u0005\u0005\u0003\u0003BA\u001d\u0003{i!!a\u000f\u000b\u0007\u0015\t)!\u0003\u0003\u0002@\u0005m\"AD*ue\u0016\fW.\u001b8h#V,'/\u001f\u0005\t\u0003\u0007\n\t\u00041\u0001\u0002\f\u0005IA-\u0019;b\rJ\fW.\u001a")
public class MQTTStreamSinkSuite
extends SparkFunSuite
implements SharedSparkContext,
BeforeAndAfter {
    private final boolean _ssl;
    private MQTTTestUtils mqttTestUtils;
    private final File tempDir;
    private final HashMap<Object, String> messages;
    private MqttClient testClient;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    private transient SparkContext org$apache$spark$SharedSparkContext$$_sc;
    private SparkConf conf;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public /* synthetic */ void org$apache$spark$SharedSparkContext$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$SharedSparkContext$$super$afterAll() {
        super.afterAll();
    }

    public /* synthetic */ void org$apache$spark$SharedSparkContext$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$SharedSparkContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public SparkContext sc() {
        return SharedSparkContext.sc$((SharedSparkContext)this);
    }

    public void initializeContext() {
        SharedSparkContext.initializeContext$((SharedSparkContext)this);
    }

    public void beforeAll() {
        SharedSparkContext.beforeAll$((SharedSparkContext)this);
    }

    public void afterAll() {
        SharedSparkContext.afterAll$((SharedSparkContext)this);
    }

    public void beforeEach() {
        SharedSparkContext.beforeEach$((SharedSparkContext)this);
    }

    public void afterEach() {
        SharedSparkContext.afterEach$((SharedSparkContext)this);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.runTest$((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public SparkContext org$apache$spark$SharedSparkContext$$_sc() {
        return this.org$apache$spark$SharedSparkContext$$_sc;
    }

    public void org$apache$spark$SharedSparkContext$$_sc_$eq(SparkContext x$1) {
        this.org$apache$spark$SharedSparkContext$$_sc = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public void conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public MQTTTestUtils mqttTestUtils() {
        return this.mqttTestUtils;
    }

    public void mqttTestUtils_$eq(MQTTTestUtils x$1) {
        this.mqttTestUtils = x$1;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public HashMap<Object, String> messages() {
        return this.messages;
    }

    public MqttClient testClient() {
        return this.testClient;
    }

    public void testClient_$eq(MqttClient x$1) {
        this.testClient = x$1;
    }

    public Tuple2<SQLContext, Dataset<Row>> createContextAndDF(Seq<String> messages) {
        SQLContext sqlContext = SparkSession$.MODULE$.builder().getOrCreate().sqlContext();
        sqlContext.setConf("spark.sql.streaming.checkpointLocation", this.tempDir().getAbsolutePath());
        MemoryStream stream = new MemoryStream(1, sqlContext, sqlContext.sparkSession().implicits().newStringEncoder());
        stream.addData((TraversableOnce)messages.toSeq());
        return new Tuple2((Object)sqlContext, (Object)stream.toDF());
    }

    public StreamingQuery sendToMQTT(Dataset<Row> dataFrame) {
        String protocol = this._ssl ? "ssl" : "tcp";
        DataStreamWriter writer = dataFrame.writeStream().format("org.apache.bahir.sql.streaming.mqtt.MQTTStreamSinkProvider").option("topic", "test").option("localStorage", this.tempDir().getAbsolutePath()).option("clientId", "clientId").option("QoS", "2");
        Object object = this._ssl ? writer.option("ssl.trust.store", this.mqttTestUtils().clientTrustStore().getAbsolutePath()).option("ssl.trust.store.type", "JKS").option("ssl.trust.store.password", this.mqttTestUtils().clientTrustStorePassword()) : BoxedUnit.UNIT;
        return writer.start(new StringBuilder(3).append(protocol).append("://").append(this.mqttTestUtils().brokerUri()).toString());
    }

    public MQTTStreamSinkSuite(boolean _ssl) {
        this._ssl = _ssl;
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        SharedSparkContext.$init$((SharedSparkContext)this);
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.tempDir = new File(new StringBuilder(11).append(System.getProperty("java.io.tmpdir")).append("/mqtt-test/").toString());
        this.messages = new HashMap();
        this.before((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkEnv$.MODULE$.get().conf().set("spark.mqtt.client.connect.attempts", "1");
            File x$1 = this.tempDir();
            boolean x$2 = $this._ssl;
            int x$3 = MQTTTestUtils$.MODULE$.$lessinit$greater$default$2();
            this.mqttTestUtils_$eq(new MQTTTestUtils(x$1, x$3, x$2));
            this.mqttTestUtils().setup();
            this.tempDir().mkdirs();
            this.messages().clear();
            this.testClient_$eq(this.mqttTestUtils().subscribeData("test", (Map<Object, String>)this.messages()));
        }, new Position("MQTTStreamSinkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.after((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            CachedMQTTClient$.MODULE$.clear();
            this.testClient().disconnectForcibly();
            this.testClient().close();
            this.mqttTestUtils().teardown();
            return FileHelper$.MODULE$.deleteFileQuietly(this.tempDir());
        }, new Position("MQTTStreamSinkSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
    }
}

