/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bahir.examples.sql.streaming.mqtt;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.StreamingQuery;

public class JavaMQTTSinkWordCount {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: JavaMQTTSinkWordCount <port> <brokerUrl> <topic>");
            System.exit(1);
        }
        String checkpointDir = System.getProperty("java.io.tmpdir") + "/mqtt-example/";
        FileUtils.deleteDirectory((File)new File(checkpointDir));
        Integer port = Integer.valueOf(args[0]);
        String brokerUrl = args[1];
        String topic = args[2];
        SparkSession spark = SparkSession.builder().appName("JavaMQTTSinkWordCount").master("local[4]").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", "localhost").option("port", (long)port.intValue()).load().select("value", new String[0]).as(Encoders.STRING());
        Dataset words = lines.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){

            public Iterator<String> call(String x) {
                return Arrays.asList(x.split(" ")).iterator();
            }
        }, Encoders.STRING());
        Dataset wordCounts = words.groupBy("value", new String[0]).count();
        StreamingQuery query = wordCounts.writeStream().format("org.apache.bahir.sql.streaming.mqtt.MQTTStreamSinkProvider").option("checkpointLocation", checkpointDir).outputMode("complete").option("topic", topic).option("localStorage", checkpointDir).start(brokerUrl);
        query.awaitTermination();
    }
}

