/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bahir.sql.streaming.mqtt;

import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.bahir.sql.streaming.mqtt.MQTTStreamConstants$;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000114A!\u0001\u0002\u0001\u001f\tYQ*\u0015+U\u001b\u0016\u001c8/Y4f\u0015\t\u0019A!\u0001\u0003ncR$(BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!\u00022bQ&\u0014(BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\t\u0018\u0013\tA\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u0003\u0005i\u0007C\u0001\u000f&\u001b\u0005i\"B\u0001\u0010 \u0003\u0019i\u0017\u000f\u001e;wg)\u0011\u0001%I\u0001\u0007G2LWM\u001c;\u000b\u0005\t\u001a\u0013\u0001\u00029bQ>T!\u0001\n\u0007\u0002\u000f\u0015\u001cG.\u001b9tK&\u0011a%\b\u0002\f\u001bF$H/T3tg\u0006<W\r\u0003\u0005)\u0001\t\u0015\r\u0011\"\u0001*\u0003\u0015!x\u000e]5d+\u0005Q\u0003CA\u0016/\u001d\t\tB&\u0003\u0002.%\u00051\u0001K]3eK\u001aL!a\f\u0019\u0003\rM#(/\u001b8h\u0015\ti#\u0003\u0003\u00053\u0001\t\u0005\t\u0015!\u0003+\u0003\u0019!x\u000e]5dA!)A\u0007\u0001C\u0001k\u00051A(\u001b8jiz\"2A\u000e\u001d:!\t9\u0004!D\u0001\u0003\u0011\u0015Q2\u00071\u0001\u001c\u0011\u0015A3\u00071\u0001+\u0011\u001dY\u0004A1A\u0005\u0002q\n\u0011\u0002^5nKN$\u0018-\u001c9\u0016\u0003u\u0002\"A\u0010\"\u000e\u0003}R!a\u0002!\u000b\u0003\u0005\u000bAA[1wC&\u00111i\u0010\u0002\n)&lWm\u001d;b[BDa!\u0012\u0001!\u0002\u0013i\u0014A\u0003;j[\u0016\u001cH/Y7qA!9q\t\u0001b\u0001\n\u0003A\u0015!\u00033va2L7-\u0019;f+\u0005I\u0005CA\tK\u0013\tY%CA\u0004C_>dW-\u00198\t\r5\u0003\u0001\u0015!\u0003J\u0003)!W\u000f\u001d7jG\u0006$X\r\t\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001I\u0003!\u0011X\r^1j]\u0016$\u0007BB)\u0001A\u0003%\u0011*A\u0005sKR\f\u0017N\\3eA!91\u000b\u0001b\u0001\n\u0003!\u0016aA9pgV\tQ\u000b\u0005\u0002\u0012-&\u0011qK\u0005\u0002\u0004\u0013:$\bBB-\u0001A\u0003%Q+\u0001\u0003r_N\u0004\u0003bB.\u0001\u0005\u0004%\t\u0001V\u0001\u0003S\u0012Da!\u0018\u0001!\u0002\u0013)\u0016aA5eA!9q\f\u0001b\u0001\n\u0003\u0001\u0017a\u00029bs2|\u0017\rZ\u000b\u0002CB\u0019\u0011C\u00193\n\u0005\r\u0014\"!B!se\u0006L\bCA\tf\u0013\t1'C\u0001\u0003CsR,\u0007B\u00025\u0001A\u0003%\u0011-\u0001\u0005qCfdw.\u00193!\u0011\u0015Q\u0007\u0001\"\u0011l\u0003!!xn\u0015;sS:<G#\u0001\u0016")
public class MQTTMessage
implements Serializable {
    private final String topic;
    private final Timestamp timestamp;
    private final boolean duplicate;
    private final boolean retained;
    private final int qos;
    private final int id;
    private final byte[] payload;

    public String topic() {
        return this.topic;
    }

    public Timestamp timestamp() {
        return this.timestamp;
    }

    public boolean duplicate() {
        return this.duplicate;
    }

    public boolean retained() {
        return this.retained;
    }

    public int qos() {
        return this.qos;
    }

    public int id() {
        return this.id;
    }

    public byte[] payload() {
        return this.payload;
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MQTTMessage.\n       |Topic: ", "\n       |MessageID: ", "\n       |QoS: ", "\n       |Payload: ", "\n       |Payload as string: ", "\n       |isRetained: ", "\n       |isDuplicate: ", "\n       |TimeStamp: ", "\n     "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.id()), BoxesRunTime.boxToInteger((int)this.qos()), this.payload(), new String(this.payload(), Charset.defaultCharset()), BoxesRunTime.boxToBoolean((boolean)this.retained()), BoxesRunTime.boxToBoolean((boolean)this.duplicate()), this.timestamp()})))).stripMargin();
    }

    public MQTTMessage(MqttMessage m, String topic) {
        this.topic = topic;
        this.timestamp = Timestamp.valueOf(MQTTStreamConstants$.MODULE$.DATE_FORMAT().format(Calendar.getInstance().getTime()));
        this.duplicate = m.isDuplicate();
        this.retained = m.isRetained();
        this.qos = m.getQos();
        this.id = m.getId();
        this.payload = m.getPayload();
    }
}

