/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bahir.sql.streaming.mqtt;

import java.util.Enumeration;
import org.apache.bahir.sql.streaming.mqtt.JavaSerializer$;
import org.apache.bahir.sql.streaming.mqtt.MessageStore;
import org.apache.bahir.sql.streaming.mqtt.MqttPersistableData;
import org.apache.bahir.sql.streaming.mqtt.Serializer;
import org.apache.bahir.utils.Logging;
import org.apache.bahir.utils.Logging$class;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=4Q!\u0001\u0002\u0001\u00059\u0011\u0011\u0003T8dC2lUm]:bO\u0016\u001cFo\u001c:f\u0015\t\u0019A!\u0001\u0003ncR$(BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!\u00022bQ&\u0014(BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001cB\u0001A\b\u00163A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\f\u000e\u0003\tI!\u0001\u0007\u0002\u0003\u00195+7o]1hKN#xN]3\u0011\u0005iiR\"A\u000e\u000b\u0005qA\u0011!B;uS2\u001c\u0018B\u0001\u0010\u001c\u0005\u001daunZ4j]\u001eD\u0001\u0002\t\u0001\u0003\u0006\u0004%\tAI\u0001\u0010a\u0016\u00148/[:uK:$8\u000b^8sK\u000e\u0001Q#A\u0012\u0011\u0005\u0011jS\"A\u0013\u000b\u0005\u0019:\u0013AB7riR48G\u0003\u0002)S\u000511\r\\5f]RT!AK\u0016\u0002\tA\f\u0007n\u001c\u0006\u0003Y1\tq!Z2mSB\u001cX-\u0003\u0002/K\t)R*\u001d;u\u00072LWM\u001c;QKJ\u001c\u0018n\u001d;f]\u000e,\u0007\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002!A,'o]5ti\u0016tGo\u0015;pe\u0016\u0004\u0003\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011A\u001a\u0002\u0015M,'/[1mSj,'/F\u00015!\t1R'\u0003\u00027\u0005\tQ1+\u001a:jC2L'0\u001a:\t\u0011a\u0002!\u0011!Q\u0001\nQ\n1b]3sS\u0006d\u0017N_3sA!)!\b\u0001C\u0001w\u00051A(\u001b8jiz\"2\u0001P\u001f?!\t1\u0002\u0001C\u0003!s\u0001\u00071\u0005C\u00033s\u0001\u0007A\u0007C\u0003;\u0001\u0011\u0005\u0001\t\u0006\u0002=\u0003\")\u0001e\u0010a\u0001G!)1\t\u0001C\u0005\t\u0006\u0019q-\u001a;\u0015\u0005\u0015[\u0005c\u0001\tG\u0011&\u0011q)\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003!%K!AS\t\u0003\t\tKH/\u001a\u0005\u0006\u0019\n\u0003\r!T\u0001\u0003S\u0012\u0004\"\u0001\u0005(\n\u0005=\u000b\"\u0001\u0002'p]\u001eDQ!\u0015\u0001\u0005\u0002I\u000b!#\\1y!J|7-Z:tK\u0012|eMZ:fiV\tQ\nC\u0003U\u0001\u0011\u0005S+A\u0003ti>\u0014X-\u0006\u0002W?R\u0019qKW.\u0011\u0005AA\u0016BA-\u0012\u0005\u001d\u0011un\u001c7fC:DQ\u0001T*A\u00025CQ\u0001X*A\u0002u\u000bq!\\3tg\u0006<W\r\u0005\u0002_?2\u0001A!\u00021T\u0005\u0004\t'!\u0001+\u0012\u0005\t,\u0007C\u0001\td\u0013\t!\u0017CA\u0004O_RD\u0017N\\4\u0011\u0005A1\u0017BA4\u0012\u0005\r\te.\u001f\u0005\u0006S\u0002!\tE[\u0001\te\u0016$(/[3wKV\u00111.\u001c\u000b\u0003Y:\u0004\"AX7\u0005\u000b\u0001D'\u0019A1\t\u000b1C\u0007\u0019A'")
public class LocalMessageStore
implements MessageStore,
Logging {
    private final MqttClientPersistence persistentStore;
    private final Serializer serializer;
    private final Logger log;

    @Override
    public final Logger log() {
        return this.log;
    }

    @Override
    public final void org$apache$bahir$utils$Logging$_setter_$log_$eq(Logger x$1) {
        this.log = x$1;
    }

    public MqttClientPersistence persistentStore() {
        return this.persistentStore;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    private byte[] get(long id) {
        return this.persistentStore().get(((Object)BoxesRunTime.boxToLong((long)id)).toString()).getHeaderBytes();
    }

    @Override
    public long maxProcessedOffset() {
        Enumeration keys = this.persistentStore().keys();
        return BoxesRunTime.unboxToInt((Object)((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(keys).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Object x) {
                return new StringOps(Predef$.MODULE$.augmentString(x.toString())).toInt();
            }
        }).max((Ordering)Ordering.Int$.MODULE$));
    }

    @Override
    public <T> boolean store(long id, T message) {
        boolean bl;
        byte[] bytes = this.serializer().serialize(message);
        try {
            this.persistentStore().put(((Object)BoxesRunTime.boxToLong((long)id)).toString(), (MqttPersistable)new MqttPersistableData(bytes));
            bl = true;
        }
        catch (MqttPersistenceException mqttPersistenceException) {
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to store message Id: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)id)})), (Throwable)mqttPersistenceException);
            bl = false;
        }
        return bl;
    }

    @Override
    public <T> T retrieve(long id) {
        return this.serializer().deserialize(this.get(id));
    }

    public LocalMessageStore(MqttClientPersistence persistentStore, Serializer serializer) {
        this.persistentStore = persistentStore;
        this.serializer = serializer;
        Logging$class.$init$(this);
    }

    public LocalMessageStore(MqttClientPersistence persistentStore) {
        this(persistentStore, JavaSerializer$.MODULE$.getInstance());
    }
}

