/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bahir.examples.sql.streaming.mqtt;

import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.streaming.StreamingQuery;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;

public final class MQTTStreamWordCount$ {
    public static final MQTTStreamWordCount$ MODULE$;

    static {
        new MQTTStreamWordCount$();
    }

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: MQTTStreamWordCount <brokerUrl> <topic>");
            System.exit(1);
        }
        String brokerUrl = args[0];
        String topic = args[1];
        SparkSession spark = SparkSession$.MODULE$.builder().appName("MQTTStreamWordCount").master("local[4]").getOrCreate();
        Dataset lines = spark.readStream().format("org.apache.bahir.sql.streaming.mqtt.MQTTStreamSourceProvider").option("topic", topic).option("persistence", "memory").load(brokerUrl).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CAST(payload AS STRING)"})).as(spark.implicits().newStringEncoder());
        Dataset words = lines.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])x$1.split(" "));
            }
        }, spark.implicits().newStringEncoder());
        Dataset wordCounts = words.groupBy("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
        StreamingQuery query = wordCounts.writeStream().outputMode("complete").format("console").start();
        query.awaitTermination();
    }

    private MQTTStreamWordCount$() {
        MODULE$ = this;
    }
}

