/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bahir.examples.sql.streaming.mqtt;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.streaming.StreamingQuery;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;

public final class MQTTSinkWordCount$ {
    public static final MQTTSinkWordCount$ MODULE$;

    static {
        new MQTTSinkWordCount$();
    }

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: MQTTSinkWordCount <port> <brokerUrl> <topic>");
            System.exit(1);
        }
        String checkpointDir = new StringBuilder().append((Object)System.getProperty("java.io.tmpdir")).append((Object)"/mqtt-example/").toString();
        FileUtils.deleteDirectory((File)new File(checkpointDir));
        String port = args[0];
        String brokerUrl = args[1];
        String topic = args[2];
        SparkSession spark = SparkSession$.MODULE$.builder().appName("MQTTSinkWordCount").master("local[4]").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", "localhost").option("port", port).load().select("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(spark.implicits().newStringEncoder());
        Dataset words = lines.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])x$1.split(" "));
            }
        }, spark.implicits().newStringEncoder());
        Dataset wordCounts = words.groupBy("value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).count();
        StreamingQuery query = wordCounts.writeStream().format("org.apache.bahir.sql.streaming.mqtt.MQTTStreamSinkProvider").option("checkpointLocation", checkpointDir).outputMode("complete").option("topic", topic).option("localStorage", checkpointDir).start(brokerUrl);
        query.awaitTermination();
    }

    private MQTTSinkWordCount$() {
        MODULE$ = this;
    }
}

