/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bahir.sql.streaming.mqtt;

import java.nio.ByteBuffer;
import java.util.Enumeration;
import org.apache.bahir.sql.streaming.mqtt.MessageStore;
import org.apache.bahir.sql.streaming.mqtt.MqttPersistableData;
import org.apache.bahir.utils.Logging;
import org.apache.bahir.utils.Logging$class;
import org.apache.spark.SparkConf;
import org.apache.spark.serializer.JavaSerializer;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerInstance;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005%d!B\u0001\u0003\u0001\tq!!\u0005'pG\u0006dW*Z:tC\u001e,7\u000b^8sK*\u00111\u0001B\u0001\u0005[F$HO\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\t1a]9m\u0015\tI!\"A\u0003cC\"L'O\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7\u0003\u0002\u0001\u0010+e\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u0005\u0011\u0011B\u0001\r\u0003\u00051iUm]:bO\u0016\u001cFo\u001c:f!\tQR$D\u0001\u001c\u0015\ta\u0002\"A\u0003vi&d7/\u0003\u0002\u001f7\t9Aj\\4hS:<\u0007\u0002\u0003\u0011\u0001\u0005\u000b\u0007I\u0011\u0001\u0012\u0002\u001fA,'o]5ti\u0016tGo\u0015;pe\u0016\u001c\u0001!F\u0001$!\t!S&D\u0001&\u0015\t1s%\u0001\u0004ncR$ho\r\u0006\u0003Q%\naa\u00197jK:$(B\u0001\u0016,\u0003\u0011\u0001\u0018\r[8\u000b\u00051b\u0011aB3dY&\u00048/Z\u0005\u0003]\u0015\u0012Q#T9ui\u000ec\u0017.\u001a8u!\u0016\u00148/[:uK:\u001cW\r\u0003\u00051\u0001\t\u0005\t\u0015!\u0003$\u0003A\u0001XM]:jgR,g\u000e^*u_J,\u0007\u0005\u0003\u00053\u0001\t\u0015\r\u0011\"\u00014\u0003)\u0019XM]5bY&TXM]\u000b\u0002iA\u0011Q'O\u0007\u0002m)\u0011!g\u000e\u0006\u0003q)\tQa\u001d9be.L!A\u000f\u001c\u0003\u0015M+'/[1mSj,'\u000f\u0003\u0005=\u0001\t\u0005\t\u0015!\u00035\u0003-\u0019XM]5bY&TXM\u001d\u0011\t\u000by\u0002A\u0011A \u0002\rqJg.\u001b;?)\r\u0001\u0015I\u0011\t\u0003-\u0001AQ\u0001I\u001fA\u0002\rBQAM\u001fA\u0002QBq\u0001\u0012\u0001C\u0002\u0013\u0005Q)A\u0006dY\u0006\u001c8\u000fT8bI\u0016\u0014X#\u0001$\u0011\u0005\u001dcU\"\u0001%\u000b\u0005%S\u0015\u0001\u00027b]\u001eT\u0011aS\u0001\u0005U\u00064\u0018-\u0003\u0002N\u0011\nY1\t\\1tg2{\u0017\rZ3s\u0011\u0019y\u0005\u0001)A\u0005\r\u0006a1\r\\1tg2{\u0017\rZ3sA!)a\b\u0001C\u0001#R\u0019\u0001IU*\t\u000b\u0001\u0002\u0006\u0019A\u0012\t\u000bQ\u0003\u0006\u0019A+\u0002\t\r|gN\u001a\t\u0003-^k\u0011aN\u0005\u00031^\u0012\u0011b\u00159be.\u001cuN\u001c4\t\u000fi\u0003!\u0019!C\u00017\u0006\u00112/\u001a:jC2L'0\u001a:J]N$\u0018M\\2f+\u0005a\u0006CA\u001b^\u0013\tqfG\u0001\nTKJL\u0017\r\\5{KJLen\u001d;b]\u000e,\u0007B\u00021\u0001A\u0003%A,A\ntKJL\u0017\r\\5{KJLen\u001d;b]\u000e,\u0007\u0005C\u0003c\u0001\u0011%1-A\u0002hKR$\"\u0001\u001a6\u0011\u0007A)w-\u0003\u0002g#\t)\u0011I\u001d:bsB\u0011\u0001\u0003[\u0005\u0003SF\u0011AAQ=uK\")1.\u0019a\u0001Y\u0006\u0011\u0011\u000e\u001a\t\u0003!5L!A\\\t\u0003\u0007%sG\u000fC\u0003q\u0001\u0011\u0005\u0011/\u0001\nnCb\u0004&o\\2fgN,Gm\u00144gg\u0016$X#\u00017\t\u000bM\u0004A\u0011\t;\u0002\u000bM$xN]3\u0016\u0007U\fI\u0001F\u0003w\u00037\ti\u0002\u0006\u0002xuB\u0011\u0001\u0003_\u0005\u0003sF\u0011qAQ8pY\u0016\fg\u000eC\u0004|e\u0006\u0005\t9\u0001?\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007E\u0003~\u0003\u0003\t)!D\u0001\u007f\u0015\ty\u0018#A\u0004sK\u001adWm\u0019;\n\u0007\u0005\raP\u0001\u0005DY\u0006\u001c8\u000fV1h!\u0011\t9!!\u0003\r\u0001\u00119\u00111\u0002:C\u0002\u00055!!\u0001+\u0012\t\u0005=\u0011Q\u0003\t\u0004!\u0005E\u0011bAA\n#\t9aj\u001c;iS:<\u0007c\u0001\t\u0002\u0018%\u0019\u0011\u0011D\t\u0003\u0007\u0005s\u0017\u0010C\u0003le\u0002\u0007A\u000eC\u0004\u0002 I\u0004\r!!\u0002\u0002\u000f5,7o]1hK\"9\u00111\u0005\u0001\u0005B\u0005\u0015\u0012\u0001\u0003:fiJLWM^3\u0016\t\u0005\u001d\u0012Q\t\u000b\u0007\u0003S\ti%!\u0015\u0015\t\u0005-\u0012q\t\t\u0007\u0003[\ti$a\u0011\u000f\t\u0005=\u0012\u0011\b\b\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011QG\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0012bAA\u001e#\u00059\u0001/Y2lC\u001e,\u0017\u0002BA \u0003\u0003\u00121aU3r\u0015\r\tY$\u0005\t\u0005\u0003\u000f\t)\u0005\u0002\u0005\u0002\f\u0005\u0005\"\u0019AA\u0007\u0011)\tI%!\t\u0002\u0002\u0003\u000f\u00111J\u0001\u000bKZLG-\u001a8dK\u0012*\u0004#B?\u0002\u0002\u0005\r\u0003bBA(\u0003C\u0001\r\u0001\\\u0001\u0006gR\f'\u000f\u001e\u0005\b\u0003'\n\t\u00031\u0001m\u0003\r)g\u000e\u001a\u0005\b\u0003G\u0001A\u0011IA,+\u0011\tI&a\u0018\u0015\t\u0005m\u0013q\r\u000b\u0005\u0003;\n\t\u0007\u0005\u0003\u0002\b\u0005}C\u0001CA\u0006\u0003+\u0012\r!!\u0004\t\u0015\u0005\r\u0014QKA\u0001\u0002\b\t)'\u0001\u0006fm&$WM\\2fIY\u0002R!`A\u0001\u0003;Baa[A+\u0001\u0004a\u0007")
public class LocalMessageStore
implements MessageStore,
Logging {
    private final MqttClientPersistence persistentStore;
    private final Serializer serializer;
    private final ClassLoader classLoader;
    private final SerializerInstance serializerInstance;
    private final Logger log;

    @Override
    public final Logger log() {
        return this.log;
    }

    @Override
    public final void org$apache$bahir$utils$Logging$_setter_$log_$eq(Logger x$1) {
        this.log = x$1;
    }

    public MqttClientPersistence persistentStore() {
        return this.persistentStore;
    }

    public Serializer serializer() {
        return this.serializer;
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public SerializerInstance serializerInstance() {
        return this.serializerInstance;
    }

    private byte[] get(int id) {
        return this.persistentStore().get(((Object)BoxesRunTime.boxToInteger((int)id)).toString()).getHeaderBytes();
    }

    @Override
    public int maxProcessedOffset() {
        Enumeration keys = this.persistentStore().keys();
        return BoxesRunTime.unboxToInt((Object)((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(keys).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Object x) {
                return new StringOps(Predef$.MODULE$.augmentString(x.toString())).toInt();
            }
        }).max((Ordering)Ordering.Int$.MODULE$));
    }

    @Override
    public <T> boolean store(int id, T message, ClassTag<T> evidence$4) {
        boolean bl;
        byte[] bytes = this.serializerInstance().serialize(message, evidence$4).array();
        try {
            this.persistentStore().put(((Object)BoxesRunTime.boxToInteger((int)id)).toString(), (MqttPersistable)new MqttPersistableData(bytes));
            bl = true;
        }
        catch (MqttPersistenceException mqttPersistenceException) {
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to store message Id: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})), (Throwable)mqttPersistenceException);
            bl = false;
        }
        return bl;
    }

    @Override
    public <T> Seq<T> retrieve(int start, int end, ClassTag<T> evidence$5) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start), end).map((Function1)new Serializable(this, evidence$5){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalMessageStore $outer;
            private final ClassTag evidence$5$1;

            public final T apply(int x) {
                return this.$outer.retrieve(x, this.evidence$5$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.evidence$5$1 = evidence$5$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    @Override
    public <T> T retrieve(int id, ClassTag<T> evidence$6) {
        return (T)this.serializerInstance().deserialize(ByteBuffer.wrap(this.get(id)), this.classLoader(), evidence$6);
    }

    public LocalMessageStore(MqttClientPersistence persistentStore, Serializer serializer) {
        this.persistentStore = persistentStore;
        this.serializer = serializer;
        Logging$class.$init$(this);
        this.classLoader = Thread.currentThread().getContextClassLoader();
        this.serializerInstance = serializer.newInstance();
    }

    public LocalMessageStore(MqttClientPersistence persistentStore, SparkConf conf) {
        this(persistentStore, (Serializer)new JavaSerializer(conf));
    }
}

