/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bahir.sql.streaming.mqtt;

import java.io.File;
import java.net.ServerSocket;
import java.net.URI;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.bahir.sql.streaming.mqtt.MQTTTestUtils$;
import org.apache.bahir.utils.Logging;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0001\u0003\u0001=\u0011Q\"T)U)R+7\u000f^+uS2\u001c(BA\u0002\u0005\u0003\u0011i\u0017\u000f\u001e;\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000b\t\f\u0007.\u001b:\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011!B;uS2\u001c\u0018BA\u000e\u0019\u0005\u001daunZ4j]\u001eD\u0001\"\b\u0001\u0003\u0002\u0003\u0006IAH\u0001\bi\u0016l\u0007\u000fR5s!\tyB%D\u0001!\u0015\t\t#%\u0001\u0002j_*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u00111\u0015\u000e\\3\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\nA\u0001]8siB\u0011\u0011#K\u0005\u0003UI\u00111!\u00138u\u0011\u0015a\u0003\u0001\"\u0001.\u0003\u0019a\u0014N\\5u}Q\u0019a\u0006M\u0019\u0011\u0005=\u0002Q\"\u0001\u0002\t\u000buY\u0003\u0019\u0001\u0010\t\u000f\u001dZ\u0003\u0013!a\u0001Q!91\u0007\u0001b\u0001\n\u0013!\u0014A\u00049feNL7\u000f^3oG\u0016$\u0015N]\u000b\u0002kA\u0011a'O\u0007\u0002o)\u0011\u0001HI\u0001\u0005Y\u0006tw-\u0003\u0002;o\t11\u000b\u001e:j]\u001eDa\u0001\u0010\u0001!\u0002\u0013)\u0014a\u00049feNL7\u000f^3oG\u0016$\u0015N\u001d\u0011\t\u000fy\u0002!\u0019!C\u0005i\u0005Q!M]8lKJDun\u001d;\t\r\u0001\u0003\u0001\u0015!\u00036\u0003-\u0011'o\\6fe\"{7\u000f\u001e\u0011\t\u000f\t\u0003!\u0019!C\u0005\u0007\u0006Q!M]8lKJ\u0004vN\u001d;\u0016\u0003!Ba!\u0012\u0001!\u0002\u0013A\u0013a\u00032s_.,'\u000fU8si\u0002B\u0011b\u0012\u0001A\u0002\u0003\u0007I\u0011\u0002%\u0002\r\t\u0014xn[3s+\u0005I\u0005C\u0001&O\u001b\u0005Y%BA$M\u0015\ti%\"\u0001\u0005bGRLg/Z7r\u0013\ty5JA\u0007Ce>\\WM]*feZL7-\u001a\u0005\n#\u0002\u0001\r\u00111A\u0005\nI\u000b!B\u0019:pW\u0016\u0014x\fJ3r)\t\u0019f\u000b\u0005\u0002\u0012)&\u0011QK\u0005\u0002\u0005+:LG\u000fC\u0004X!\u0006\u0005\t\u0019A%\u0002\u0007a$\u0013\u0007\u0003\u0004Z\u0001\u0001\u0006K!S\u0001\bEJ|7.\u001a:!\u0011%Y\u0006\u00011AA\u0002\u0013%A,A\u0005d_:tWm\u0019;peV\tQ\f\u0005\u0002K=&\u0011ql\u0013\u0002\u0013)J\fgn\u001d9peR\u001cuN\u001c8fGR|'\u000fC\u0005b\u0001\u0001\u0007\t\u0019!C\u0005E\u0006i1m\u001c8oK\u000e$xN]0%KF$\"aU2\t\u000f]\u0003\u0017\u0011!a\u0001;\"1Q\r\u0001Q!\nu\u000b!bY8o]\u0016\u001cGo\u001c:!\u0011\u00159\u0007\u0001\"\u0001i\u0003%\u0011'o\\6feV\u0013\u0018.F\u0001j!\tQWN\u0004\u0002\u0012W&\u0011ANE\u0001\u0007!J,G-\u001a4\n\u0005ir'B\u00017\u0013\u0011\u0015\u0001\b\u0001\"\u0003r\u000311\u0017N\u001c3Ge\u0016,\u0007k\u001c:u)\u0005A\u0003\"B:\u0001\t\u0003!\u0018!B:fiV\u0004H#A*\t\u000bY\u0004A\u0011\u0001;\u0002\u0011Q,\u0017M\u001d3po:DQ\u0001\u001f\u0001\u0005\u0002e\f1\u0002];cY&\u001c\b\u000eR1uCR!1K\u001f?\u007f\u0011\u0015Yx\u000f1\u0001j\u0003\u0015!x\u000e]5d\u0011\u0015ix\u000f1\u0001j\u0003\u0011!\u0017\r^1\t\u000f}<\b\u0013!a\u0001Q\u0005\ta\nC\u0005\u0002\u0004\u0001\t\n\u0011\"\u0001\u0002\u0006\u0005)\u0002/\u001e2mSNDG)\u0019;bI\u0011,g-Y;mi\u0012\u001aTCAA\u0004U\rA\u0013\u0011B\u0016\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00185\u0011\u0011q\u0002\u0006\u0005\u0003#\t\u0019\"A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0003\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0005=!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001eI\u0011Q\u0004\u0002\u0002\u0002#\u0005\u0011qD\u0001\u000e\u001bF#F\u000bV3tiV#\u0018\u000e\\:\u0011\u0007=\n\tC\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AA\u0012'\r\t\t\u0003\u0005\u0005\bY\u0005\u0005B\u0011AA\u0014)\t\ty\u0002\u0003\u0006\u0002,\u0005\u0005\u0012\u0013!C\u0001\u0003\u000b\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0004")
public class MQTTTestUtils
implements Logging {
    private final File tempDir;
    private final String persistenceDir;
    private final String brokerHost;
    private final int brokerPort;
    private BrokerService broker;
    private TransportConnector connector;
    private final Logger log;

    public static int $lessinit$greater$default$2() {
        return MQTTTestUtils$.MODULE$.$lessinit$greater$default$2();
    }

    public final Logger log() {
        return this.log;
    }

    public final void org$apache$bahir$utils$Logging$_setter_$log_$eq(Logger x$1) {
        this.log = x$1;
    }

    private String persistenceDir() {
        return this.persistenceDir;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    private int brokerPort() {
        return this.brokerPort;
    }

    private BrokerService broker() {
        return this.broker;
    }

    private void broker_$eq(BrokerService x$1) {
        this.broker = x$1;
    }

    private TransportConnector connector() {
        return this.connector;
    }

    private void connector_$eq(TransportConnector x$1) {
        this.connector = x$1;
    }

    public String brokerUri() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerHost(), BoxesRunTime.boxToInteger((int)this.brokerPort())}));
    }

    /*
     * WARNING - void declaration
     */
    private int findFreePort() {
        void var2_2;
        ServerSocket s = new ServerSocket(0);
        int port = s.getLocalPort();
        s.close();
        return (int)var2_2;
    }

    public void setup() {
        this.broker_$eq(new BrokerService());
        this.broker().setDataDirectoryFile(this.tempDir);
        this.connector_$eq(new TransportConnector());
        this.connector().setName("mqtt");
        this.connector().setUri(new URI(new StringBuilder().append((Object)"mqtt://").append((Object)this.brokerUri()).toString()));
        this.broker().addConnector(this.connector());
        this.broker().start();
    }

    public void teardown() {
        if (this.broker() != null) {
            this.broker().stop();
            this.broker_$eq(null);
        }
        if (this.connector() != null) {
            this.connector().stop();
            this.connector_$eq(null);
        }
    }

    public void publishData(String topic, String data, int N) {
        MqttClient client = null;
        try {
            MqttDefaultFilePersistence persistence = new MqttDefaultFilePersistence(this.persistenceDir());
            client = new MqttClient(new StringBuilder().append((Object)"tcp://").append((Object)this.brokerUri()).toString(), MqttClient.generateClientId(), (MqttClientPersistence)persistence);
            client.connect();
            if (client.isConnected()) {
                MqttTopic msgTopic = client.getTopic(topic);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), N).foreach((Function1)new Serializable(this, data, msgTopic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ MQTTTestUtils $outer;
                    private final String data$1;
                    private final MqttTopic msgTopic$1;

                    public final Object apply(int i) {
                        MqttDeliveryToken mqttDeliveryToken;
                        try {
                            Thread.sleep(20L);
                            MqttMessage message = new MqttMessage(this.data$1.getBytes());
                            message.setQos(2);
                            message.setRetained(true);
                            mqttDeliveryToken = this.msgTopic$1.publish(message);
                        }
                        catch (Throwable throwable) {
                            this.$outer.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"publish failed ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{throwable})));
                            mqttDeliveryToken = BoxedUnit.UNIT;
                        }
                        catch (MqttException mqttException) {
                            Thread.sleep(50L);
                            this.$outer.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"publish failed"})).s((Seq)Nil$.MODULE$), (Throwable)mqttException);
                            mqttDeliveryToken = BoxedUnit.UNIT;
                        }
                        return mqttDeliveryToken;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.data$1 = data$1;
                        this.msgTopic$1 = msgTopic$1;
                    }
                });
            }
            return;
        }
        finally {
            if (client != null) {
                client.disconnect();
                client.close();
                client = null;
            }
        }
    }

    public int publishData$default$3() {
        return 1;
    }

    public MQTTTestUtils(File tempDir, int port) {
        this.tempDir = tempDir;
        Logging.class.$init$((Logging)this);
        this.persistenceDir = tempDir.getAbsolutePath();
        this.brokerHost = "localhost";
        this.brokerPort = port == 0 ? this.findFreePort() : port;
    }
}

