/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bahir.examples.sql.streaming.mqtt;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.StreamingQuery;

public final class JavaMQTTStreamWordCount {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: JavaMQTTStreamWordCount <brokerUrl> <topic>");
            System.exit(1);
        }
        if (!Logger.getRootLogger().getAllAppenders().hasMoreElements()) {
            Logger.getRootLogger().setLevel(Level.WARN);
        }
        String brokerUrl = args[0];
        String topic = args[1];
        SparkConf sparkConf = new SparkConf().setAppName("JavaMQTTStreamWordCount");
        if (!sparkConf.contains("spark.master")) {
            sparkConf.setMaster("local[4]");
        }
        SparkSession spark = SparkSession.builder().config(sparkConf).getOrCreate();
        Dataset lines = spark.readStream().format("org.apache.bahir.sql.streaming.mqtt.MQTTStreamSourceProvider").option("topic", topic).load(brokerUrl).select("value", new String[0]).as(Encoders.STRING());
        Dataset words = lines.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){

            public Iterator<String> call(String x) {
                return Arrays.asList(x.split(" ")).iterator();
            }
        }, Encoders.STRING());
        Dataset wordCounts = words.groupBy("value", new String[0]).count();
        StreamingQuery query = wordCounts.writeStream().outputMode("complete").format("console").start();
        query.awaitTermination();
    }
}

