/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.cloudant;

import org.apache.bahir.cloudant.CloudantReceiver;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.Receiver;
import scala.Function1;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;

public final class CloudantStreaming$ {
    public static final CloudantStreaming$ MODULE$;

    static {
        new CloudantStreaming$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Cloudant Spark SQL External Datasource in Scala").master("local[*]").getOrCreate();
        StreamingContext ssc = new StreamingContext(spark.sparkContext(), Seconds$.MODULE$.apply(10L));
        ReceiverInputDStream changes = ssc.receiverStream((Receiver)new CloudantReceiver(spark.sparkContext().getConf(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cloudant.host"), (Object)"examples.cloudant.com"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"database"), (Object)"sales")}))), ClassTag$.MODULE$.apply(String.class));
        changes.foreachRDD((Function2)new Serializable(spark){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;

            public final void apply(RDD<String> rdd, Time time) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"========= ", " ========="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{time})));
                Dataset changesDataFrame = this.spark$1.read().json(rdd);
                if (changesDataFrame.schema().nonEmpty()) {
                    changesDataFrame.printSchema();
                    BooleanRef hasDelRecord = BooleanRef.create((boolean)false);
                    BooleanRef hasMonth = BooleanRef.create((boolean)false);
                    Predef$.MODULE$.refArrayOps((Object[])changesDataFrame.schema().fieldNames()).foreach((Function1)new Serializable(this, hasDelRecord, hasMonth){
                        public static final long serialVersionUID = 0L;
                        private final BooleanRef hasDelRecord$1;
                        private final BooleanRef hasMonth$1;

                        public final void apply(String field) {
                            if ("_deleted".equals(field)) {
                                this.hasDelRecord$1.elem = true;
                            }
                            if ("month".equals(field)) {
                                this.hasMonth$1.elem = true;
                            }
                        }
                        {
                            this.hasDelRecord$1 = hasDelRecord$1;
                            this.hasMonth$1 = hasMonth$1;
                        }
                    });
                    if (hasDelRecord.elem) {
                        changesDataFrame.filter(changesDataFrame.apply("_deleted")).select("*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).show();
                    }
                    if (hasMonth.elem) {
                        changesDataFrame.filter(changesDataFrame.apply("month").$eq$eq$eq((Object)"May")).select("*", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).show(5);
                        changesDataFrame.createOrReplaceTempView("sales");
                        Dataset salesInMayCountsDataFrame = this.spark$1.sql(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n                 |select rep, amount\n                 |from sales\n                 |where month = \"May\"\n                "})).s((Seq)Nil$.MODULE$))).stripMargin());
                        salesInMayCountsDataFrame.show(5);
                    }
                }
            }
            {
                this.spark$1 = spark$1;
            }
        });
        ssc.start();
        Thread.sleep(60000L);
        ssc.stop(true);
    }

    private CloudantStreaming$() {
        MODULE$ = this;
    }
}

