/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.cloudant;

import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class CloudantDFOption$ {
    public static final CloudantDFOption$ MODULE$;

    static {
        new CloudantDFOption$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Cloudant Spark SQL Example with Dataframe using Option").getOrCreate();
        String cloudantHost = "ACCOUNT.cloudant.com";
        String cloudantUser = "USERNAME";
        String cloudantPassword = "PASSWORD";
        Dataset df = spark.read().format("org.apache.bahir.cloudant").option("cloudant.host", cloudantHost).option("cloudant.username", cloudantUser).option("cloudant.password", cloudantPassword).load("n_airportcodemapping");
        df.cache();
        df.printSchema();
        df.filter(df.apply("_id").$greater$eq((Object)"CAA")).select("_id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"airportName"})).show();
        df.filter(df.apply("_id").$greater$eq((Object)"CAA")).select("_id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"airportName"})).write().format("org.apache.bahir.cloudant").option("cloudant.host", cloudantHost).option("cloudant.username", cloudantUser).option("cloudant.password", cloudantPassword).option("createDBOnSave", "true").save("airportcodemapping_df");
        Dataset df2 = spark.read().format("org.apache.bahir.cloudant").option("index", "_design/view/_search/n_flights").option("cloudant.host", cloudantHost).option("cloudant.username", cloudantUser).option("cloudant.password", cloudantPassword).load("n_flight");
        long total2 = df2.filter(df2.apply("flightSegmentId").$greater((Object)"AA9")).select("flightSegmentId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scheduledDepartureTime"})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df2.apply("flightSegmentId")})).count();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Total ", " flights from index"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)total2)})));
    }

    private CloudantDFOption$() {
        MODULE$ = this;
    }
}

