/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bahir.cloudant;

import com.cloudant.client.api.Database;
import org.apache.bahir.cloudant.ClientSparkFunSuite;
import org.apache.bahir.cloudant.CloudantChangesDFSuite$;
import org.apache.bahir.cloudant.TestUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00052A!\u0001\u0002\u0001\u0017\t12\t\\8vI\u0006tGo\u00115b]\u001e,7\u000f\u0012$Tk&$XM\u0003\u0002\u0004\t\u0005A1\r\\8vI\u0006tGO\u0003\u0002\u0006\r\u0005)!-\u00195je*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055qQ\"\u0001\u0002\n\u0005=\u0011!aE\"mS\u0016tGo\u00159be.4UO\\*vSR,\u0007\"B\t\u0001\t\u0003\u0011\u0012A\u0002\u001fj]&$h\bF\u0001\u0014!\ti\u0001\u0001C\u0004\u0016\u0001\t\u0007I\u0011\u0001\f\u0002\u0011\u0015tG\r]8j]R,\u0012a\u0006\t\u00031ui\u0011!\u0007\u0006\u00035m\tA\u0001\\1oO*\tA$\u0001\u0003kCZ\f\u0017B\u0001\u0010\u001a\u0005\u0019\u0019FO]5oO\"1\u0001\u0005\u0001Q\u0001\n]\t\u0011\"\u001a8ea>Lg\u000e\u001e\u0011")
public class CloudantChangesDFSuite
extends ClientSparkFunSuite {
    private final String endpoint;

    public String endpoint() {
        return this.endpoint;
    }

    public CloudantChangesDFSuite() {
        this.endpoint = "_changes";
        this.before((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CloudantChangesDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.spark_$eq(SparkSession$.MODULE$.builder().config(this.$outer.conf()).config("cloudant.protocol", TestUtils$.MODULE$.getProtocol()).config("cloudant.host", TestUtils$.MODULE$.getHost()).config("cloudant.username", TestUtils$.MODULE$.getUsername()).config("cloudant.password", TestUtils$.MODULE$.getPassword()).config("cloudant.endpoint", this.$outer.endpoint()).config("spark.streaming.unpersist", "false").getOrCreate());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.after((Function0<Object>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CloudantChangesDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.spark().close();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testIfEnabled("load and save data from Cloudant database", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CloudantChangesDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Dataset df = this.$outer.spark().read().format("org.apache.bahir.cloudant").load("n_flight");
                df.cache();
                long $org_scalatest_assert_macro_left = df.count();
                int $org_scalatest_assert_macro_right = 1967;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testIfEnabled("load and count data from Cloudant search index", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CloudantChangesDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long total;
                Dataset df = this.$outer.spark().read().format("org.apache.bahir.cloudant").option("index", "_design/view/_search/n_flights").load("n_flight");
                long $org_scalatest_assert_macro_left = total = df.filter(df.apply("flightSegmentId").$greater((Object)"AA9")).select("flightSegmentId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scheduledDepartureTime"})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply("flightSegmentId")})).count();
                int $org_scalatest_assert_macro_right = 50;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testIfEnabled("load data and verify deleted doc is not in results", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CloudantChangesDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Database db = this.$outer.client().database("n_flight", false);
                db.remove(this.$outer.deletedDoc().get("_id").getAsString(), this.$outer.deletedDoc().get("_rev").getAsString());
                Dataset df = this.$outer.spark().read().format("org.apache.bahir.cloudant").load("n_flight");
                long $org_scalatest_assert_macro_left = df.count();
                int $org_scalatest_assert_macro_right = 1966;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ArrayOps $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])df.columns());
                String $org_scalatest_assert_macro_right2 = "_deleted";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testIfEnabled("load data and count rows in filtered dataframe", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CloudantChangesDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Dataset df = this.$outer.spark().read().format("org.apache.bahir.cloudant").load("n_airportcodemapping");
                Dataset dfFilter = df.filter(df.apply("_id").$greater$eq((Object)"CAA")).select("_id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"airportName"}));
                long $org_scalatest_assert_macro_left = dfFilter.count();
                int $org_scalatest_assert_macro_right = 13;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testIfEnabled("save filtered dataframe to database", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CloudantChangesDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Dataset df = this.$outer.spark().read().format("org.apache.bahir.cloudant").load("n_flight");
                Dataset df2 = df.filter(df.apply("flightSegmentId").$eq$eq$eq((Object)"AA106")).select("flightSegmentId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"economyClassBaseCost"}));
                long $org_scalatest_assert_macro_left = df2.count();
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                df2.write().format("org.apache.bahir.cloudant").save("n_flight2");
                Dataset dfFlight2 = this.$outer.spark().read().format("org.apache.bahir.cloudant").load("n_flight2");
                long $org_scalatest_assert_macro_left2 = dfFlight2.count();
                int $org_scalatest_assert_macro_right2 = 5;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testIfEnabled("save dataframe to database using createDBOnSave=true option", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CloudantChangesDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Dataset df = this.$outer.spark().read().format("org.apache.bahir.cloudant").load("n_airportcodemapping");
                String saveDfToDb = "airportcodemapping_df";
                Try$.MODULE$.apply((Function0)new Serializable(this, saveDfToDb){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final String saveDfToDb$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$bahir$cloudant$CloudantChangesDFSuite$$anonfun$$$outer().client().deleteDB(this.saveDfToDb$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.saveDfToDb$1 = saveDfToDb$1;
                    }
                });
                df.filter(df.apply("_id").$greater$eq((Object)"CAA")).select("_id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"airportName"})).write().format("org.apache.bahir.cloudant").option("createDBOnSave", "true").save(saveDfToDb);
                BoxedUnit df2 = BoxedUnit.UNIT;
                Dataset dfAirport = this.$outer.spark().read().format("org.apache.bahir.cloudant").load(saveDfToDb);
                long $org_scalatest_assert_macro_left = dfAirport.count();
                int $org_scalatest_assert_macro_right = 13;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Try$.MODULE$.apply((Function0)new Serializable(this, saveDfToDb){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final String saveDfToDb$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$bahir$cloudant$CloudantChangesDFSuite$$anonfun$$$outer().client().deleteDB(this.saveDfToDb$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.saveDfToDb$1 = saveDfToDb$1;
                    }
                });
            }

            public /* synthetic */ CloudantChangesDFSuite org$apache$bahir$cloudant$CloudantChangesDFSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testIfEnabled("load and count data from view", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CloudantChangesDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Dataset df = this.$outer.spark().read().format("org.apache.bahir.cloudant").option("view", "_design/view/_view/AA0").load("n_flight");
                long $org_scalatest_assert_macro_left = df.count();
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testIfEnabled("load data from view with MapReduce function", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CloudantChangesDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Dataset df = this.$outer.spark().read().format("org.apache.bahir.cloudant").option("view", "_design/view/_view/AAreduce?reduce=true").load("n_flight");
                long $org_scalatest_assert_macro_left = df.count();
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.testIfEnabled("load data and verify total count of selector, filter, and view option", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CloudantChangesDFSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long df2count;
                long dfcount;
                Dataset df = this.$outer.spark().read().format("org.apache.bahir.cloudant").option("selector", "{\"flightSegmentId\": {\"$eq\": \"AA2\"}}").load("n_flight");
                long $org_scalatest_assert_macro_left = dfcount = df.count();
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Dataset df2 = this.$outer.spark().read().format("org.apache.bahir.cloudant").load("n_flight");
                long $org_scalatest_assert_macro_left2 = df2count = df2.filter(df2.apply("flightSegmentId").$eq$eq$eq((Object)"AA2")).select("flightSegmentId", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"scheduledDepartureTime"})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df2.apply("flightSegmentId")})).count();
                long $org_scalatest_assert_macro_right2 = dfcount;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Dataset df3 = this.$outer.spark().read().format("org.apache.bahir.cloudant").option("view", "_design/view/_view/AA2").load("n_flight");
                long df3count = df3.count();
                long $org_scalatest_assert_macro_left3 = dfcount;
                long $org_scalatest_assert_macro_right3 = df3count;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                long $org_scalatest_assert_macro_left4 = df2count;
                long $org_scalatest_assert_macro_right4 = df3count;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

