/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bahir.cloudant;

import com.cloudant.client.api.ClientBuilder;
import com.cloudant.client.api.CloudantClient;
import com.cloudant.client.api.Database;
import com.cloudant.client.api.model.Response;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.bahir.cloudant.TestUtils$;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.SparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=b\u0001B\u0001\u0003\u0001-\u00111c\u00117jK:$8\u000b]1sW\u001a+hnU;ji\u0016T!a\u0001\u0003\u0002\u0011\rdw.\u001e3b]RT!!\u0002\u0004\u0002\u000b\t\f\u0007.\u001b:\u000b\u0005\u001dA\u0011AB1qC\u000eDWMC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0003\u001f\u0019\tQa\u001d9be.L!!\u0005\b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)\u0002\"A\u0005tG\u0006d\u0017\r^3ti&\u0011q\u0003\u0006\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0004\u001f\u0001\t\u0007I\u0011B\u0010\u0002\u000fQ,W\u000e\u001d#jeV\t\u0001\u0005\u0005\u0002\"M5\t!E\u0003\u0002$I\u0005\u0011\u0011n\u001c\u0006\u0002K\u0005!!.\u0019<b\u0013\t9#E\u0001\u0003GS2,\u0007BB\u0015\u0001A\u0003%\u0001%\u0001\u0005uK6\u0004H)\u001b:!\u0011%Y\u0003\u00011AA\u0002\u0013\u0005A&\u0001\u0004dY&,g\u000e^\u000b\u0002[A\u0011a&N\u0007\u0002_)\u0011\u0001'M\u0001\u0004CBL'BA\u00163\u0015\t\u00191GC\u00015\u0003\r\u0019w.\\\u0005\u0003m=\u0012ab\u00117pk\u0012\fg\u000e^\"mS\u0016tG\u000fC\u00059\u0001\u0001\u0007\t\u0019!C\u0001s\u0005Q1\r\\5f]R|F%Z9\u0015\u0005i\u0002\u0005CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$\u0001B+oSRDq!Q\u001c\u0002\u0002\u0003\u0007Q&A\u0002yIEBaa\u0011\u0001!B\u0013i\u0013aB2mS\u0016tG\u000f\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0003\u0011\u0019wN\u001c4\u0016\u0003\u001d\u0003\"!\u0004%\n\u0005%s!!C*qCJ\\7i\u001c8g\u0011\u0019Y\u0005\u0001)A\u0005\u000f\u0006)1m\u001c8gA!9Q\n\u0001a\u0001\n\u0003q\u0015A\u00033fY\u0016$X\r\u001a#pGV\tq\n\u0005\u0002Q+6\t\u0011K\u0003\u0002S'\u0006!qm]8o\u0015\t!6'\u0001\u0004h_><G.Z\u0005\u0003-F\u0013!BS:p]>\u0013'.Z2u\u0011\u001dA\u0006\u00011A\u0005\u0002e\u000ba\u0002Z3mKR,G\rR8d?\u0012*\u0017\u000f\u0006\u0002;5\"9\u0011iVA\u0001\u0002\u0004y\u0005B\u0002/\u0001A\u0003&q*A\u0006eK2,G/\u001a3E_\u000e\u0004\u0003\"C\b\u0001\u0001\u0004\u0005\r\u0011\"\u0001_+\u0005y\u0006C\u00011d\u001b\u0005\t'B\u00012\u000f\u0003\r\u0019\u0018\u000f\\\u0005\u0003I\u0006\u0014Ab\u00159be.\u001cVm]:j_:D\u0011B\u001a\u0001A\u0002\u0003\u0007I\u0011A4\u0002\u0013M\u0004\u0018M]6`I\u0015\fHC\u0001\u001ei\u0011\u001d\tU-!AA\u0002}CaA\u001b\u0001!B\u0013y\u0016AB:qCJ\\\u0007\u0005C\u0003m\u0001\u0011\u0005S.A\u0005cK\u001a|'/Z!mYR\t!\bC\u0003p\u0001\u0011\u0005S.\u0001\u0005bMR,'/\u00117m\u0011\u0015\t\b\u0001\"\u0001n\u0003-\u0019X\r^;q\u00072LWM\u001c;\t\u000bM\u0004A\u0011A7\u0002\u001dQ,\u0017M\u001d3po:\u001cE.[3oi\")Q\u000f\u0001C\u0001[\u0006i1M]3bi\u0016$Vm\u001d;EENDQa\u001e\u0001\u0005\u00025\fQ\u0002Z3mKR,G+Z:u\t\n\u001c\b\"B=\u0001\t\u0003Q\u0018\u0001\u00043fY\u0016$X\rV3ti\u0012\u0013GC\u0001\u001e|\u0011\u0015a\b\u00101\u0001~\u0003\u0019!'MT1nKB\u0019a0a\u0001\u000f\u0005mz\u0018bAA\u0001y\u00051\u0001K]3eK\u001aLA!!\u0002\u0002\b\t11\u000b\u001e:j]\u001eT1!!\u0001=\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\tQ\u0002^3ti&3WI\\1cY\u0016$G\u0003BA\b\u00037!2AOA\t\u0011%\t\u0019\"!\u0003\u0005\u0002\u0004\t)\"\u0001\u0005uKN$(i\u001c3z!\u0011Y\u0014q\u0003\u001e\n\u0007\u0005eAH\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\ti\"!\u0003A\u0002u\f\u0001\u0002^3ti:\u000bW.\u001a\u0005\b\u0003C\u0001A\u0011AA\u0012\u0003E\u0011XO\\%g)\u0016\u001cHo]#oC\ndW\r\u001a\u000b\u0005\u0003K\tY\u0003F\u0002;\u0003OA\u0011\"!\u000b\u0002 \u0011\u0005\r!!\u0006\u0002\t\t|G-\u001f\u0005\b\u0003[\ty\u00021\u0001~\u0003\u001diWm]:bO\u0016\u0004")
public class ClientSparkFunSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final File org$apache$bahir$cloudant$ClientSparkFunSuite$$tempDir;
    private CloudantClient client;
    private final SparkConf conf;
    private JsonObject deletedDoc;
    private SparkSession spark;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public File org$apache$bahir$cloudant$ClientSparkFunSuite$$tempDir() {
        return this.org$apache$bahir$cloudant$ClientSparkFunSuite$$tempDir;
    }

    public CloudantClient client() {
        return this.client;
    }

    public void client_$eq(CloudantClient x$1) {
        this.client = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public JsonObject deletedDoc() {
        return this.deletedDoc;
    }

    public void deletedDoc_$eq(JsonObject x$1) {
        this.deletedDoc = x$1;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    public void beforeAll() {
        this.runIfTestsEnabled("Prepare Cloudant test databases", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientSparkFunSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$bahir$cloudant$ClientSparkFunSuite$$tempDir().mkdirs();
                this.$outer.org$apache$bahir$cloudant$ClientSparkFunSuite$$tempDir().deleteOnExit();
                this.$outer.setupClient();
                this.$outer.createTestDbs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void afterAll() {
        TestUtils$.MODULE$.deleteRecursively(this.org$apache$bahir$cloudant$ClientSparkFunSuite$$tempDir());
        this.deleteTestDbs();
        this.teardownClient();
        this.spark().close();
    }

    public void setupClient() {
        if (TestUtils$.MODULE$.getHost().endsWith("cloudant.com")) {
            this.client_$eq(ClientBuilder.account((String)TestUtils$.MODULE$.getUsername()).username(TestUtils$.MODULE$.getUsername()).password(TestUtils$.MODULE$.getPassword()).build());
        } else {
            String host = new StringBuilder().append((Object)TestUtils$.MODULE$.getProtocol()).append((Object)"://").append((Object)TestUtils$.MODULE$.getHost()).toString();
            this.client_$eq(ClientBuilder.url((URL)new URL(host)).username(TestUtils$.MODULE$.getUsername()).password(TestUtils$.MODULE$.getPassword()).build());
        }
    }

    public void teardownClient() {
        if (this.client() != null) {
            this.client().shutdown();
        }
    }

    public void createTestDbs() {
        TestUtils$.MODULE$.testDatabasesList().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String check$ifrefutable$1) {
                String string = check$ifrefutable$1;
                boolean bl = string != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientSparkFunSuite $outer;

            public final void apply(String dbName) {
                Database db = this.$outer.client().database(dbName, true);
                URL jsonFilePath = ((Object)((Object)this.$outer)).getClass().getResource(new StringBuilder().append((Object)"/json-files/").append((Object)dbName).append((Object)".json").toString());
                if (jsonFilePath != null && new File(jsonFilePath.getFile()).exists()) {
                    JsonArray jsonFileArray = (JsonArray)new Gson().fromJson((Reader)new FileReader(jsonFilePath.getFile()), JsonArray.class);
                    ArrayList<JsonObject> listOfObjects = new ArrayList<JsonObject>();
                    if (jsonFileArray != null) {
                        for (int i = 0; i < jsonFileArray.size(); ++i) {
                            listOfObjects.add(jsonFileArray.get(i).getAsJsonObject());
                        }
                    }
                    List responses = db.bulk(listOfObjects);
                    for (int i = 0; i < responses.size(); ++i) {
                        Bool bool;
                        int $org_scalatest_assert_macro_left = ((Response)responses.get(i)).getStatusCode();
                        int $org_scalatest_assert_macro_right = 200;
                        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                        if ($org_scalatest_assert_macro_left2.value()) {
                            bool = Bool$.MODULE$.simpleMacroBool(true, "");
                        } else {
                            int $org_scalatest_assert_macro_left3 = ((Response)responses.get(i)).getStatusCode();
                            int $org_scalatest_assert_macro_right2 = 201;
                            bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right2);
                        }
                        Bool $org_scalatest_assert_macro_right3 = bool;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$bar$bar((Function0)new Serializable(this, $org_scalatest_assert_macro_right3){
                            public static final long serialVersionUID = 0L;
                            private final Bool $org_scalatest_assert_macro_right$1;

                            public final Bool apply() {
                                return this.$org_scalatest_assert_macro_right$1;
                            }
                            {
                                this.$org_scalatest_assert_macro_right$1 = $org_scalatest_assert_macro_right$1;
                            }
                        }));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    String string = dbName;
                    String string2 = "n_flight";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        this.$outer.deletedDoc().addProperty("_id", ((Response)responses.get(0)).getId());
                        this.$outer.deletedDoc().addProperty("_rev", ((Response)responses.get(0)).getRev());
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void deleteTestDbs() {
        TestUtils$.MODULE$.testDatabasesList().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String check$ifrefutable$2) {
                String string = check$ifrefutable$2;
                boolean bl = string != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientSparkFunSuite $outer;

            public final void apply(String db) {
                this.$outer.deleteTestDb(db);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void deleteTestDb(String dbName) {
        this.client().deleteDB(dbName);
    }

    public void testIfEnabled(String testName, Function0<BoxedUnit> testBody) {
        if (TestUtils$.MODULE$.shouldRunTests()) {
            this.test(testName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), testBody);
        } else {
            this.ignore(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " [enable by setting env var CLOUDANT_USER and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CLOUDANT_PASSWORD]"})).s((Seq)Nil$.MODULE$)).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), testBody);
        }
    }

    public void runIfTestsEnabled(String message, Function0<BoxedUnit> body) {
        if (TestUtils$.MODULE$.shouldRunTests()) {
            body.apply$mcV$sp();
        } else {
            this.ignore(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " [enable by setting env var CLOUDANT_USER and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"CLOUDANT_PASSWORD]"})).s((Seq)Nil$.MODULE$)).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                }
            });
        }
    }

    public ClientSparkFunSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        this.org$apache$bahir$cloudant$ClientSparkFunSuite$$tempDir = new File(new StringBuilder().append((Object)System.getProperty("java.io.tmpdir")).append((Object)"/sql-cloudant/").toString());
        this.conf = new SparkConf().setMaster("local[4]");
        this.deletedDoc = new JsonObject();
    }
}

