/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis2.wsdl.codegen.writer.FileWriter;
import org.apache.axis2.wsdl.codegen.writer.ServiceXMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceFileCreator {
    public File createServiceFile(String serviceName, String implementationClassName, ArrayList methodList) throws Exception {
        String currentUserDir = System.getProperty("user.dir");
        String fileName = "services.xml";
        ServiceXMLWriter serviceXmlWriter = new ServiceXMLWriter(currentUserDir);
        this.writeFile(this.getServiceModel(serviceName, implementationClassName, methodList), (FileWriter)serviceXmlWriter, fileName);
        return new File(currentUserDir + File.separator + fileName);
    }

    private Document getServiceModel(String serviceName, String className, ArrayList methods) {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement("interface");
        rootElement.setAttribute("classpackage", "");
        rootElement.setAttribute("name", className);
        rootElement.setAttribute("servicename", serviceName);
        Element methodElement = null;
        int size = methods.size();
        for (int i = 0; i < size; ++i) {
            methodElement = doc.createElement("method");
            rootElement.setAttribute("name", methods.get(i).toString());
            rootElement.appendChild(methodElement);
        }
        doc.appendChild(rootElement);
        return doc;
    }

    private void writeFile(Document model, FileWriter writer, String fileName) throws IOException, Exception {
        DOMSource source = new DOMSource(model);
        ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(memoryStream);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
        writer.loadTemplate();
        writer.createOutFile(null, fileName);
    }
}

