/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.falcon.hook;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.falcon.bridge.FalconBridge;
import org.apache.atlas.falcon.event.FalconEvent;
import org.apache.atlas.falcon.publisher.FalconEventPublisher;
import org.apache.atlas.hook.AtlasHook;
import org.apache.atlas.v1.model.instance.Referenceable;
import org.apache.atlas.v1.model.notification.HookNotificationV1;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.store.ConfigurationStore;
import org.apache.falcon.entity.v0.cluster.Cluster;
import org.apache.falcon.entity.v0.feed.Feed;
import org.apache.falcon.entity.v0.process.Process;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FalconHook
extends AtlasHook
implements FalconEventPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(FalconHook.class);
    private static ConfigurationStore STORE;

    @Override
    public void publish(FalconEventPublisher.Data data) {
        FalconEvent event = data.getEvent();
        try {
            this.fireAndForget(event);
        }
        catch (Throwable t) {
            LOG.warn("Error in processing data {}", (Object)data, (Object)t);
        }
    }

    private void fireAndForget(FalconEvent event) throws FalconException, URISyntaxException {
        LOG.info("Entered Atlas hook for Falcon hook operation {}", (Object)event.getOperation());
        ArrayList<HookNotificationV1.EntityCreateRequest> messages = new ArrayList<HookNotificationV1.EntityCreateRequest>();
        Operation op = FalconHook.getOperation(event.getOperation());
        String user = FalconHook.getUser((String)event.getUser());
        LOG.info("fireAndForget user:{}", (Object)user);
        switch (op) {
            case ADD: {
                messages.add(new HookNotificationV1.EntityCreateRequest(user, this.createEntities(event, user)));
            }
        }
        this.notifyEntities(messages, null);
    }

    private List<Referenceable> createEntities(FalconEvent event, String user) throws FalconException, URISyntaxException {
        ArrayList<Referenceable> entities = new ArrayList<Referenceable>();
        switch (event.getOperation()) {
            case ADD_CLUSTER: {
                entities.add(FalconBridge.createClusterEntity((Cluster)event.getEntity()));
                break;
            }
            case ADD_PROCESS: {
                entities.addAll(FalconBridge.createProcessEntity((Process)event.getEntity(), STORE));
                break;
            }
            case ADD_FEED: {
                entities.addAll(FalconBridge.createFeedCreationEntity((Feed)event.getEntity(), STORE));
                break;
            }
            default: {
                LOG.info("Falcon operation {} is not valid or supported", (Object)event.getOperation());
            }
        }
        return entities;
    }

    private static Operation getOperation(FalconEvent.OPERATION op) throws FalconException {
        switch (op) {
            case ADD_CLUSTER: 
            case ADD_PROCESS: 
            case ADD_FEED: {
                return Operation.ADD;
            }
            case UPDATE_CLUSTER: 
            case UPDATE_FEED: 
            case UPDATE_PROCESS: {
                return Operation.UPDATE;
            }
        }
        throw new FalconException("Falcon operation " + (Object)((Object)op) + " is not valid or supported");
    }

    static {
        try {
            STORE = ConfigurationStore.get();
        }
        catch (Exception e) {
            LOG.error("Caught exception initializing the falcon hook.", (Throwable)e);
        }
        LOG.info("Created Atlas Hook for Falcon");
    }

    private static enum Operation {
        ADD,
        UPDATE;

    }
}

