/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.falcon.service;

import org.apache.atlas.falcon.Util.EventUtil;
import org.apache.atlas.falcon.event.FalconEvent;
import org.apache.atlas.falcon.hook.FalconHook;
import org.apache.atlas.falcon.publisher.FalconEventPublisher;
import org.apache.falcon.FalconException;
import org.apache.falcon.entity.v0.Entity;
import org.apache.falcon.entity.v0.EntityType;
import org.apache.falcon.service.ConfigurationChangeListener;
import org.apache.falcon.service.FalconService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasService
implements FalconService,
ConfigurationChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasService.class);
    private FalconEventPublisher publisher;
    public static final String SERVICE_NAME = AtlasService.class.getSimpleName();

    public String getName() {
        return SERVICE_NAME;
    }

    public void init() throws FalconException {
        this.publisher = new FalconHook();
    }

    public void destroy() throws FalconException {
    }

    public void onAdd(Entity entity) throws FalconException {
        try {
            EntityType entityType = entity.getEntityType();
            switch (entityType) {
                case CLUSTER: {
                    this.addEntity(entity, FalconEvent.OPERATION.ADD_CLUSTER);
                    break;
                }
                case PROCESS: {
                    this.addEntity(entity, FalconEvent.OPERATION.ADD_PROCESS);
                    break;
                }
                case FEED: {
                    this.addEntity(entity, FalconEvent.OPERATION.ADD_FEED);
                    break;
                }
                default: {
                    LOG.debug("Entity type not processed {}", (Object)entityType);
                    break;
                }
            }
        }
        catch (Throwable t) {
            LOG.warn("Error handling entity {}", (Object)entity, (Object)t);
        }
    }

    public void onRemove(Entity entity) throws FalconException {
    }

    public void onChange(Entity oldEntity, Entity newEntity) throws FalconException {
    }

    public void onReload(Entity entity) throws FalconException {
        this.onAdd(entity);
    }

    private void addEntity(Entity entity, FalconEvent.OPERATION operation) throws FalconException {
        LOG.info("Adding {} entity to Atlas: {}", (Object)entity.getEntityType().name(), (Object)entity.getName());
        try {
            FalconEvent event = new FalconEvent(EventUtil.getUser(), operation, entity);
            FalconEventPublisher.Data data = new FalconEventPublisher.Data(event);
            this.publisher.publish(data);
        }
        catch (Exception ex) {
            throw new FalconException("Unable to publish data to publisher " + ex.getMessage(), (Throwable)ex);
        }
    }
}

