/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.services;

import org.apache.atlas.AtlasException;
import org.apache.atlas.TestUtils;
import org.apache.atlas.services.MetadataService;
import org.apache.atlas.services.ReservedTypesRegistrar;
import org.apache.atlas.services.ReservedTypesRegistrationException;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.json.TypesSerialization;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReservedTypesRegistrarTest {
    @Mock
    private TypeSystem typeSystem;
    @Mock
    private MetadataService metadataService;

    @BeforeMethod
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testRegistrationWithNoFiles() throws AtlasException {
        ReservedTypesRegistrar bootstrapTypesRegistrar = new ReservedTypesRegistrar();
        bootstrapTypesRegistrar.registerTypes("/some/dir/", this.typeSystem, this.metadataService);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.typeSystem});
    }

    @Test
    public void testRegisterFirstChecksClassTypeIsRegistered() throws AtlasException {
        ReservedTypesRegistrar reservedTypesRegistrar = new ReservedTypesRegistrar();
        TypesDef typesDef = TestUtils.defineHiveTypes();
        String typesJson = TypesSerialization.toJson((TypesDef)typesDef);
        reservedTypesRegistrar.registerType(this.typeSystem, this.metadataService, "/some/file/model.json", typesJson);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.typeSystem, this.metadataService});
        ((TypeSystem)inOrder.verify((Object)this.typeSystem)).isRegistered(((HierarchicalTypeDefinition)typesDef.classTypesAsJavaList().get((int)0)).typeName);
        ((MetadataService)inOrder.verify((Object)this.metadataService)).createType(typesJson);
    }

    @Test
    public void testRegisterCreatesTypesUsingMetadataService() throws AtlasException {
        ReservedTypesRegistrar reservedTypesRegistrar = new ReservedTypesRegistrar();
        TypesDef typesDef = TestUtils.defineHiveTypes();
        String typesJson = TypesSerialization.toJson((TypesDef)typesDef);
        reservedTypesRegistrar.registerType(this.typeSystem, this.metadataService, "/some/file/model.json", typesJson);
        ((MetadataService)Mockito.verify((Object)this.metadataService)).createType(typesJson);
    }

    @Test(expectedExceptions={ReservedTypesRegistrationException.class})
    public void testRegisterFailsIfErrorInJson() throws AtlasException {
        ReservedTypesRegistrar reservedTypesRegistrar = new ReservedTypesRegistrar();
        reservedTypesRegistrar.registerType(this.typeSystem, this.metadataService, "/some/file/model.json", "invalid json");
    }

    @Test(expectedExceptions={AtlasException.class})
    public void testRegisterFailsOnTypeCreationException() throws AtlasException {
        ReservedTypesRegistrar reservedTypesRegistrar = new ReservedTypesRegistrar();
        TypesDef typesDef = TestUtils.defineHiveTypes();
        String typesJson = TypesSerialization.toJson((TypesDef)typesDef);
        Mockito.when((Object)this.metadataService.createType(typesJson)).thenThrow(new Throwable[]{new AtlasException("some exception")});
        reservedTypesRegistrar.registerType(this.typeSystem, this.metadataService, "/some/file/model.json", typesJson);
    }

    @Test
    public void testShouldNotRegisterIfTypeIsAlreadyRegistered() throws AtlasException {
        ReservedTypesRegistrar reservedTypesRegistrar = new ReservedTypesRegistrar();
        TypesDef typesDef = TestUtils.defineHiveTypes();
        String typesJson = TypesSerialization.toJson((TypesDef)typesDef);
        Mockito.when((Object)this.typeSystem.isRegistered(((HierarchicalTypeDefinition)typesDef.classTypesAsJavaList().get((int)0)).typeName)).thenReturn((Object)true);
        reservedTypesRegistrar.registerType(this.typeSystem, this.metadataService, "/some/file/model.json", typesJson);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.metadataService});
    }
}

