/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.services;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.atlas.AtlasException;
import org.apache.atlas.repository.MetadataRepository;
import org.apache.atlas.repository.typestore.ITypeStore;
import org.apache.atlas.services.DefaultMetadataService;
import org.apache.atlas.services.IBootstrapTypesRegistrar;
import org.apache.atlas.services.MetadataService;
import org.apache.atlas.services.ReservedTypesRegistrar;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.apache.commons.configuration.Configuration;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultMetadataServiceMockTest {
    @Mock
    private IBootstrapTypesRegistrar typesRegistrar;
    @Mock
    private TypeSystem typeSystem;
    @Mock
    private MetadataRepository metadataRepository;
    @Mock
    private ITypeStore typeStore;
    @Mock
    private Configuration configuration;

    @BeforeMethod
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testShouldInvokeTypesRegistrarOnCreation() throws AtlasException {
        Mockito.when((Object)this.typeSystem.isRegistered((String)Matchers.any(String.class))).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.containsKey("atlas.server.ha.enabled")).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getBoolean("atlas.server.ha.enabled")).thenReturn((Object)false);
        DefaultMetadataService defaultMetadataService = new DefaultMetadataService((MetadataRepository)Mockito.mock(MetadataRepository.class), (ITypeStore)Mockito.mock(ITypeStore.class), this.typesRegistrar, new ArrayList(), new ArrayList(), this.typeSystem, this.configuration, null);
        ((IBootstrapTypesRegistrar)Mockito.verify((Object)this.typesRegistrar)).registerTypes(ReservedTypesRegistrar.getTypesDir(), this.typeSystem, (MetadataService)defaultMetadataService);
    }

    @Test
    public void testShouldNotRestoreTypesIfHAIsEnabled() throws AtlasException {
        Mockito.when((Object)this.configuration.containsKey("atlas.server.ha.enabled")).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getBoolean("atlas.server.ha.enabled")).thenReturn((Object)true);
        new DefaultMetadataService(this.metadataRepository, this.typeStore, this.typesRegistrar, new ArrayList(), new ArrayList(), this.typeSystem, this.configuration, null);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.typeStore});
        ((TypeSystem)Mockito.verify((Object)this.typeSystem, (VerificationMode)Mockito.never())).defineTypes((TypesDef)Matchers.any());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.typesRegistrar});
    }

    @Test
    public void testShouldRestoreTypeSystemOnServerActive() throws AtlasException {
        Mockito.when((Object)this.configuration.containsKey("atlas.server.ha.enabled")).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getBoolean("atlas.server.ha.enabled")).thenReturn((Object)true);
        TypesDef typesDef = (TypesDef)Mockito.mock(TypesDef.class);
        Mockito.when((Object)this.typeStore.restore()).thenReturn((Object)typesDef);
        Mockito.when((Object)this.typeSystem.isRegistered((String)Matchers.any(String.class))).thenReturn((Object)true);
        DefaultMetadataService defaultMetadataService = new DefaultMetadataService(this.metadataRepository, this.typeStore, this.typesRegistrar, new ArrayList(), new ArrayList(), this.typeSystem, this.configuration, null);
        defaultMetadataService.instanceIsActive();
        ((ITypeStore)Mockito.verify((Object)this.typeStore)).restore();
        ((TypeSystem)Mockito.verify((Object)this.typeSystem)).defineTypes(typesDef);
        ((IBootstrapTypesRegistrar)Mockito.verify((Object)this.typesRegistrar)).registerTypes(ReservedTypesRegistrar.getTypesDir(), this.typeSystem, (MetadataService)defaultMetadataService);
    }

    @Test
    public void testShouldOnlyRestoreCacheOnServerActiveIfAlreadyDoneOnce() throws AtlasException {
        Mockito.when((Object)this.configuration.containsKey("atlas.server.ha.enabled")).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getBoolean("atlas.server.ha.enabled")).thenReturn((Object)true);
        TypesDef typesDef = (TypesDef)Mockito.mock(TypesDef.class);
        Mockito.when((Object)this.typeStore.restore()).thenReturn((Object)typesDef);
        Mockito.when((Object)this.typeSystem.isRegistered((String)Matchers.any(String.class))).thenReturn((Object)true);
        TypeSystem.TransientTypeSystem transientTypeSystem = (TypeSystem.TransientTypeSystem)Mockito.mock(TypeSystem.TransientTypeSystem.class);
        HashMap typesAdded = new HashMap();
        Mockito.when((Object)transientTypeSystem.getTypesAdded()).thenReturn(typesAdded);
        Mockito.when((Object)this.typeSystem.createTransientTypeSystem(typesDef, true)).thenReturn((Object)transientTypeSystem);
        DefaultMetadataService defaultMetadataService = new DefaultMetadataService(this.metadataRepository, this.typeStore, this.typesRegistrar, new ArrayList(), new ArrayList(), this.typeSystem, this.configuration, null);
        defaultMetadataService.instanceIsActive();
        defaultMetadataService.instanceIsPassive();
        defaultMetadataService.instanceIsActive();
        ((ITypeStore)Mockito.verify((Object)this.typeStore, (VerificationMode)Mockito.times((int)2))).restore();
        ((TypeSystem)Mockito.verify((Object)this.typeSystem, (VerificationMode)Mockito.times((int)1))).defineTypes(typesDef);
        ((IBootstrapTypesRegistrar)Mockito.verify((Object)this.typesRegistrar, (VerificationMode)Mockito.times((int)1))).registerTypes(ReservedTypesRegistrar.getTypesDir(), this.typeSystem, (MetadataService)defaultMetadataService);
        ((TypeSystem)Mockito.verify((Object)this.typeSystem, (VerificationMode)Mockito.times((int)1))).createTransientTypeSystem(typesDef, true);
        ((TypeSystem)Mockito.verify((Object)this.typeSystem, (VerificationMode)Mockito.times((int)1))).commitTypes(typesAdded);
    }
}

