/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import org.apache.atlas.TestUtils;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.atlas.repository.typestore.ITypeStore;
import org.apache.atlas.repository.typestore.StoreBackedTypeCache;
import org.apache.atlas.repository.typestore.StoreBackedTypeCacheTestModule;
import org.apache.atlas.services.MetadataService;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.json.TypesSerialization;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.apache.atlas.typesystem.types.TypeUpdateException;
import org.apache.atlas.typesystem.types.cache.TypeCache;
import org.apache.atlas.typesystem.types.utils.TypesUtil;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={StoreBackedTypeCacheTestModule.class})
public class StoreBackedTypeCacheMetadataServiceTest {
    @Inject
    private MetadataService metadataService;
    @Inject
    private ITypeStore typeStore;
    @Inject
    TypeCache typeCache;
    private StoreBackedTypeCache storeBackedTypeCache;
    @Inject
    private GraphProvider<TitanGraph> graphProvider;
    private TypeSystem ts;

    @BeforeClass
    public void oneTimeSetup() throws Exception {
        Assert.assertTrue((boolean)(this.typeCache instanceof StoreBackedTypeCache));
        this.storeBackedTypeCache = (StoreBackedTypeCache)this.typeCache;
        this.ts = TypeSystem.getInstance();
        this.ts.reset();
        TestUtils.defineDeptEmployeeTypes(this.ts);
        TestUtils.createHiveTypes(this.ts);
        ImmutableList typeNames = this.ts.getTypeNames();
        this.typeStore.store(this.ts, typeNames);
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.ts.reset();
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.ts.reset();
        try {
            ((TitanGraph)this.graphProvider.get()).shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TitanCleanup.clear((TitanGraph)((TitanGraph)this.graphProvider.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testGetTypeDefinition() throws Exception {
        Assert.assertFalse((boolean)this.storeBackedTypeCache.isCachedInMemory("Manager"));
        Assert.assertNotNull((Object)this.metadataService.getTypeDefinition("Manager"));
        Assert.assertTrue((boolean)this.storeBackedTypeCache.isCachedInMemory("Manager"));
    }

    @Test
    public void testValidUpdateType() throws Exception {
        Assert.assertFalse((boolean)this.storeBackedTypeCache.isCachedInMemory("hive_table"));
        TypesDef typesDef = TestUtils.defineHiveTypes();
        String json = TypesSerialization.toJson((TypesDef)typesDef);
        this.metadataService.updateType(json);
        Assert.assertTrue((boolean)this.storeBackedTypeCache.isCachedInMemory("hive_table"));
    }

    @Test
    public void testInvalidUpdateType() throws Exception {
        Assert.assertFalse((boolean)this.storeBackedTypeCache.isCachedInMemory("hive_table"));
        HierarchicalTypeDefinition classTypeDef = TypesUtil.createClassTypeDef((String)"hive_table", (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{new AttributeDefinition("attr1", DataTypes.STRING_TYPE.getName(), Multiplicity.OPTIONAL, false, null)});
        String json = TypesSerialization.toJson((HierarchicalTypeDefinition)classTypeDef, (boolean)false);
        try {
            this.metadataService.updateType(json);
            Assert.fail((String)(TypeUpdateException.class.getSimpleName() + " was expected but none thrown"));
        }
        catch (TypeUpdateException typeUpdateException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.storeBackedTypeCache.isCachedInMemory("hive_table"));
    }
}

