/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.AtlasClient;
import org.apache.atlas.AtlasException;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.RepositoryMetadataModule;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestUtils;
import org.apache.atlas.discovery.graph.GraphBackedDiscoveryService;
import org.apache.atlas.listener.EntityChangeListener;
import org.apache.atlas.query.QueryParams;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.repository.audit.HBaseBasedAuditRepository;
import org.apache.atlas.repository.audit.HBaseTestUtils;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.atlas.services.MetadataService;
import org.apache.atlas.typesystem.IReferenceableInstance;
import org.apache.atlas.typesystem.IStruct;
import org.apache.atlas.typesystem.ITypedReferenceableInstance;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.Struct;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.exception.EntityNotFoundException;
import org.apache.atlas.typesystem.exception.TypeNotFoundException;
import org.apache.atlas.typesystem.json.InstanceSerialization;
import org.apache.atlas.typesystem.json.TypesSerialization;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.EnumValue;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.apache.atlas.typesystem.types.ValueConversionException;
import org.apache.atlas.typesystem.types.utils.TypesUtil;
import org.apache.atlas.utils.ParamChecker;
import org.apache.commons.lang.RandomStringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={RepositoryMetadataModule.class})
public class DefaultMetadataServiceTest {
    @Inject
    private MetadataService metadataService;
    @Inject
    private GraphProvider<TitanGraph> graphProvider;
    @Inject
    private EntityAuditRepository auditRepository;
    @Inject
    private GraphBackedDiscoveryService discoveryService;
    private Referenceable db = TestUtils.createDBEntity();
    private Referenceable table;
    private Id tableId;
    private final String NAME = "name";

    @BeforeTest
    public void setUp() throws Exception {
        if (this.auditRepository instanceof HBaseBasedAuditRepository) {
            HBaseTestUtils.startCluster();
            ((HBaseBasedAuditRepository)this.auditRepository).start();
        }
        RequestContext.createContext();
        RequestContext.get().setUser("testuser");
        TypesDef typesDef = TestUtils.defineHiveTypes();
        try {
            this.metadataService.getTypeDefinition("hive_table");
        }
        catch (TypeNotFoundException e) {
            this.metadataService.createType(TypesSerialization.toJson((TypesDef)typesDef));
        }
        String dbGUid = TestUtils.createInstance(this.metadataService, this.db);
        this.table = TestUtils.createTableEntity(dbGUid);
        String tableGuid = TestUtils.createInstance(this.metadataService, this.table);
        String tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        this.table = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        this.tableId = new Id(tableGuid, 0, "hive_table");
    }

    @AfterTest
    public void shutdown() throws Exception {
        TypeSystem.getInstance().reset();
        try {
            ((TitanGraph)this.graphProvider.get()).shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TitanCleanup.clear((TitanGraph)((TitanGraph)this.graphProvider.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.auditRepository instanceof HBaseBasedAuditRepository) {
            ((HBaseBasedAuditRepository)this.auditRepository).stop();
            HBaseTestUtils.stopCluster();
        }
    }

    private AtlasClient.EntityResult updateInstance(Referenceable entity) throws Exception {
        RequestContext.createContext();
        ParamChecker.notNull((Object)entity, (String)"Entity");
        ParamChecker.notNull((Object)entity.getId(), (String)"Entity");
        String entityjson = InstanceSerialization.toJson((IStruct)entity, (boolean)true);
        JSONArray entitiesJson = new JSONArray();
        entitiesJson.put((Object)entityjson);
        return this.metadataService.updateEntities(entitiesJson.toString());
    }

    @Test(expectedExceptions={TypeNotFoundException.class})
    public void testCreateEntityWithUnknownDatatype() throws Exception {
        Referenceable entity = new Referenceable("Unknown datatype", new String[0]);
        String dbName = RandomStringUtils.randomAlphanumeric((int)10);
        entity.set("name", (Object)dbName);
        entity.set("description", (Object)"us db");
        TestUtils.createInstance(this.metadataService, entity);
        Assert.fail((String)(TypeNotFoundException.class.getSimpleName() + " was expected but none thrown."));
    }

    @Test
    public void testCreateEntityWithUniqueAttribute() throws Exception {
        Referenceable entity = TestUtils.createDBEntity();
        String id = TestUtils.createInstance(this.metadataService, entity);
        this.assertAuditEvents(id, EntityAuditEvent.EntityAuditAction.ENTITY_CREATE);
        String newId = TestUtils.createInstance(this.metadataService, entity);
        Assert.assertNull((Object)newId);
        entity.set("name", (Object)TestUtils.randomString());
        newId = TestUtils.createInstance(this.metadataService, entity);
        Assert.assertNotEquals((Object)newId, (Object)id);
    }

    @Test
    public void testSpecialCharacters() throws Exception {
        String strAttrName = this.randomStrWithReservedChars();
        String arrayAttrName = this.randomStrWithReservedChars();
        String mapAttrName = this.randomStrWithReservedChars();
        HierarchicalTypeDefinition typeDefinition = TypesUtil.createClassTypeDef((String)this.randomStrWithReservedChars(), (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)strAttrName, (IDataType)DataTypes.STRING_TYPE), new AttributeDefinition(arrayAttrName, DataTypes.arrayTypeName((String)DataTypes.STRING_TYPE.getName()), Multiplicity.OPTIONAL, false, null), new AttributeDefinition(mapAttrName, DataTypes.mapTypeName((String)DataTypes.STRING_TYPE.getName(), (String)DataTypes.STRING_TYPE.getName()), Multiplicity.OPTIONAL, false, null)});
        this.metadataService.createType(TypesSerialization.toJson((HierarchicalTypeDefinition)typeDefinition, (boolean)false));
        Referenceable entity = new Referenceable(typeDefinition.typeName, new String[0]);
        entity.set(strAttrName, (Object)this.randomStrWithReservedChars());
        entity.set(arrayAttrName, (Object)new String[]{this.randomStrWithReservedChars()});
        entity.set(mapAttrName, (Object)new HashMap<String, String>(){
            {
                this.put(DefaultMetadataServiceTest.this.randomStrWithReservedChars(), DefaultMetadataServiceTest.this.randomStrWithReservedChars());
            }
        });
        String id = TestUtils.createInstance(this.metadataService, entity);
        Referenceable instance = InstanceSerialization.fromJsonReferenceable((String)this.metadataService.getEntityDefinition(id), (boolean)true);
        this.assertReferenceableEquals(instance, entity);
        String query = String.format("`%s` where `%s` = '%s'", typeDefinition.typeName, strAttrName, entity.get(strAttrName));
        String responseJson = this.discoveryService.searchByDSL(query, new QueryParams(1, 0));
        JSONObject response = new JSONObject(responseJson);
        Assert.assertEquals((int)response.getJSONArray("rows").length(), (int)1);
    }

    private void assertReferenceableEquals(Referenceable actual, Referenceable expected) {
        ImmutableList traits = actual.getTraits();
        HashMap<String, IStruct> traitsMap = new HashMap<String, IStruct>();
        for (String trait : traits) {
            traitsMap.put(trait, actual.getTrait(trait));
        }
        Referenceable newActual = new Referenceable(expected.getId(), actual.getTypeName(), actual.getValuesMap(), (List)traits, traitsMap);
        Assert.assertEquals((String)InstanceSerialization.toJson((IStruct)newActual, (boolean)true), (String)InstanceSerialization.toJson((IStruct)expected, (boolean)true));
    }

    private String randomStrWithReservedChars() {
        return TestUtils.randomString() + "\"${}%";
    }

    @Test
    public void testAddDeleteTrait() throws Exception {
        Referenceable entity = TestUtils.createDBEntity();
        String id = TestUtils.createInstance(this.metadataService, entity);
        Struct tag = new Struct("PII");
        this.metadataService.addTrait(id, InstanceSerialization.toJson((IStruct)tag, (boolean)true));
        List traits = this.metadataService.getTraitNames(id);
        Assert.assertEquals((int)traits.size(), (int)1);
        Assert.assertEquals((String)((String)traits.get(0)), (String)"PII");
        IStruct traitDefinition = this.metadataService.getTraitDefinition(id, "PII");
        Assert.assertNotNull((Object)traitDefinition);
        Assert.assertEquals((int)traitDefinition.getValuesMap().size(), (int)0);
        this.metadataService.deleteTrait(id, "PII");
        traits = this.metadataService.getTraitNames(id);
        Assert.assertEquals((int)traits.size(), (int)0);
        this.metadataService.addTrait(id, InstanceSerialization.toJson((IStruct)tag, (boolean)true));
        traits = this.metadataService.getTraitNames(id);
        Assert.assertEquals((int)traits.size(), (int)1);
        Assert.assertEquals((String)((String)traits.get(0)), (String)"PII");
    }

    @Test
    public void testEntityAudit() throws Exception {
        Referenceable entity = TestUtils.createDBEntity();
        String id = TestUtils.createInstance(this.metadataService, entity);
        this.assertAuditEvents(id, EntityAuditEvent.EntityAuditAction.ENTITY_CREATE);
        Struct tag = new Struct("PII");
        this.metadataService.addTrait(id, InstanceSerialization.toJson((IStruct)tag, (boolean)true));
        this.assertAuditEvents(id, EntityAuditEvent.EntityAuditAction.TAG_ADD);
        this.metadataService.deleteTrait(id, "PII");
        this.assertAuditEvents(id, EntityAuditEvent.EntityAuditAction.TAG_DELETE);
        this.metadataService.updateEntityAttributeByGuid(id, "description", "new description");
        this.assertAuditEvents(id, EntityAuditEvent.EntityAuditAction.ENTITY_UPDATE);
        this.metadataService.deleteEntities(Arrays.asList(id));
        this.assertAuditEvents(id, EntityAuditEvent.EntityAuditAction.ENTITY_DELETE);
    }

    private AtlasClient.EntityResult deleteEntities(String ... guids) throws AtlasException {
        RequestContext.createContext();
        return this.metadataService.deleteEntities(Arrays.asList(guids));
    }

    private void assertAuditEvents(String id, EntityAuditEvent.EntityAuditAction expectedAction) throws Exception {
        List events = this.auditRepository.listEvents(id, null, (short)10);
        for (EntityAuditEvent event : events) {
            if (event.getAction() != expectedAction) continue;
            return;
        }
        Assert.fail((String)("Expected audit action " + expectedAction));
    }

    private void assertAuditEvents(String entityId, int numEvents) throws Exception {
        List events = this.metadataService.getAuditEvents(entityId, null, (short)numEvents);
        Assert.assertNotNull((Object)events);
        Assert.assertEquals((int)events.size(), (int)numEvents);
    }

    @Test
    public void testCreateEntityWithUniqueAttributeWithReference() throws Exception {
        Referenceable db = TestUtils.createDBEntity();
        String dbId = TestUtils.createInstance(this.metadataService, db);
        this.assertAuditEvents(dbId, 1);
        this.assertAuditEvents(dbId, EntityAuditEvent.EntityAuditAction.ENTITY_CREATE);
        Referenceable table = new Referenceable("hive_table", new String[0]);
        table.set("name", (Object)TestUtils.randomString());
        table.set("description", (Object)"random table");
        table.set("type", (Object)"type");
        table.set("tableType", (Object)"MANAGED");
        table.set("database", (Object)new Id(dbId, 0, "hive_database"));
        table.set("databaseComposite", (Object)db);
        TestUtils.createInstance(this.metadataService, table);
        String tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)table.get("name"));
        Referenceable tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Referenceable actualDb = (Referenceable)tableDefinition.get("databaseComposite");
        Assert.assertEquals((String)actualDb.getId().id, (String)dbId);
        this.assertAuditEvents(dbId, 1);
    }

    @Test
    public void testUpdateEntityByUniqueAttribute() throws Exception {
        ImmutableList colNameList = ImmutableList.of((Object)"col1", (Object)"col2");
        Referenceable tableUpdated = new Referenceable("hive_table", (Map)new HashMap<String, Object>((List)colNameList){
            final /* synthetic */ List val$colNameList;
            {
                this.val$colNameList = list;
                this.put("columnNames", this.val$colNameList);
            }
        });
        this.metadataService.updateEntityByUniqueAttribute(this.table.getTypeName(), "name", (String)this.table.get("name"), tableUpdated);
        String tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        Referenceable tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        List actualColumns = (List)tableDefinition.get("columnNames");
        Assert.assertEquals((Collection)actualColumns, (Collection)colNameList);
    }

    @Test
    public void testUpdateEntityWithMap() throws Exception {
        HashMap<String, Struct> partsMap = new HashMap<String, Struct>();
        partsMap.put("part0", new Struct("partition_struct_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "test");
            }
        }));
        this.table.set("partitionsMap", partsMap);
        this.updateInstance(this.table);
        String tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        Referenceable tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertTrue((boolean)((Struct)partsMap.get("part0")).equalsContents(((Map)tableDefinition.get("partitionsMap")).get("part0")));
        partsMap.put("part1", new Struct("partition_struct_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "test1");
            }
        }));
        this.table.set("partitionsMap", partsMap);
        this.updateInstance(this.table);
        tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertEquals((int)((Map)tableDefinition.get("partitionsMap")).size(), (int)2);
        Assert.assertTrue((boolean)((Struct)partsMap.get("part1")).equalsContents(((Map)tableDefinition.get("partitionsMap")).get("part1")));
        partsMap.remove("part0");
        partsMap.put("part2", new Struct("partition_struct_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "test2");
            }
        }));
        this.table.set("partitionsMap", partsMap);
        this.updateInstance(this.table);
        tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertEquals((int)((Map)tableDefinition.get("partitionsMap")).size(), (int)2);
        Assert.assertNull(((Map)tableDefinition.get("partitionsMap")).get("part0"));
        Assert.assertTrue((boolean)((Struct)partsMap.get("part2")).equalsContents(((Map)tableDefinition.get("partitionsMap")).get("part2")));
        Struct partition2 = (Struct)partsMap.get("part2");
        partition2.set("name", (Object)"test2Updated");
        this.updateInstance(this.table);
        tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertEquals((int)((Map)tableDefinition.get("partitionsMap")).size(), (int)2);
        Assert.assertNull(((Map)tableDefinition.get("partitionsMap")).get("part0"));
        Assert.assertTrue((boolean)((Struct)partsMap.get("part2")).equalsContents(((Map)tableDefinition.get("partitionsMap")).get("part2")));
        HashMap<String, Referenceable> columnsMap = new HashMap<String, Referenceable>();
        Referenceable col0Type = new Referenceable("column_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "test1");
                this.put("type", "string");
            }
        });
        columnsMap.put("col0", col0Type);
        Referenceable col1Type = new Referenceable("column_type", (Map)new HashMap<String, Object>(){
            {
                this.put("name", "test2");
                this.put("type", "string");
            }
        });
        columnsMap.put("col1", col1Type);
        this.table.set("columnsMap", columnsMap);
        this.updateInstance(this.table);
        this.verifyMapUpdates("hive_table", "name", (String)this.table.get("name"), columnsMap, "columnsMap");
        columnsMap.clear();
        columnsMap.put("col0", col1Type);
        columnsMap.put("col1", col0Type);
        this.table.set("columnsMap", columnsMap);
        this.updateInstance(this.table);
        this.verifyMapUpdates("hive_table", "name", (String)this.table.get("name"), columnsMap, "columnsMap");
        columnsMap.clear();
        columnsMap.put("col0", col0Type);
        this.table.set("columnsMap", columnsMap);
        this.updateInstance(this.table);
        this.verifyMapUpdates("hive_table", "name", (String)this.table.get("name"), columnsMap, "columnsMap");
        this.table.setNull("columnsMap");
        this.updateInstance(this.table);
        this.verifyMapUpdates("hive_table", "name", (String)this.table.get("name"), null, "columnsMap");
    }

    private void verifyMapUpdates(String typeName, String uniqAttrName, String uniqAttrValue, Map<String, Referenceable> expectedMap, String mapAttrName) throws AtlasException {
        String json = this.metadataService.getEntityDefinition(typeName, uniqAttrName, uniqAttrValue);
        Referenceable tableDefinition = InstanceSerialization.fromJsonReferenceable((String)json, (boolean)true);
        Map actualMap = (Map)tableDefinition.get(mapAttrName);
        if (expectedMap == null && actualMap != null) {
            for (String key : actualMap.keySet()) {
                Assert.assertEquals((Object)((Referenceable)actualMap.get((Object)key)).getId().state, (Object)Id.EntityState.DELETED);
            }
        } else if (expectedMap == null) {
            Assert.assertNull((Object)actualMap);
        } else {
            Assert.assertTrue((actualMap.size() >= expectedMap.size() ? 1 : 0) != 0);
            for (String key : expectedMap.keySet()) {
                Assert.assertTrue((boolean)((Referenceable)actualMap.get(key)).equalsContents((Object)expectedMap.get(key)));
            }
            ArrayList extraKeys = new ArrayList(actualMap.keySet());
            extraKeys.removeAll(expectedMap.keySet());
            for (String key : extraKeys) {
                Assert.assertEquals((Object)((Referenceable)actualMap.get(key)).getId().getState(), (Object)Id.EntityState.DELETED);
            }
        }
    }

    @Test
    public void testUpdateEntityAddAndUpdateArrayAttr() throws Exception {
        ImmutableList colNameList = ImmutableList.of((Object)"col1", (Object)"col2");
        Referenceable tableUpdated = new Referenceable("hive_table", (Map)new HashMap<String, Object>((List)colNameList){
            final /* synthetic */ List val$colNameList;
            {
                this.val$colNameList = list;
                this.put("columnNames", this.val$colNameList);
            }
        });
        this.metadataService.updateEntityPartialByGuid(this.tableId._getId(), tableUpdated);
        String tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        Referenceable tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        List actualColumns = (List)tableDefinition.get("columnNames");
        Assert.assertEquals((Collection)actualColumns, (Collection)colNameList);
        ImmutableList updatedColNameList = ImmutableList.of((Object)"col2", (Object)"col3");
        tableUpdated = new Referenceable("hive_table", (Map)new HashMap<String, Object>((List)updatedColNameList){
            final /* synthetic */ List val$updatedColNameList;
            {
                this.val$updatedColNameList = list;
                this.put("columnNames", this.val$updatedColNameList);
            }
        });
        this.metadataService.updateEntityPartialByGuid(this.tableId.getId()._getId(), tableUpdated);
        tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        actualColumns = (List)tableDefinition.get("columnNames");
        Assert.assertEquals((Collection)actualColumns, (Collection)updatedColNameList);
    }

    private AtlasClient.EntityResult updateEntityPartial(String guid, Referenceable entity) throws AtlasException {
        RequestContext.createContext();
        return this.metadataService.updateEntityPartialByGuid(guid, entity);
    }

    @Test
    public void testUpdateEntityArrayOfClass() throws Exception {
        final ArrayList<Referenceable> columns = new ArrayList<Referenceable>();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("name", "col1");
        values.put("type", "type");
        Referenceable col1 = new Referenceable("column_type", values);
        columns.add(col1);
        Referenceable tableUpdated = new Referenceable("hive_table", (Map)new HashMap<String, Object>(){
            {
                this.put("columns", columns);
            }
        });
        AtlasClient.EntityResult entityResult = this.updateEntityPartial(this.tableId._getId(), tableUpdated);
        Assert.assertEquals((int)entityResult.getCreatedEntities().size(), (int)1);
        Assert.assertEquals((int)entityResult.getUpdateEntities().size(), (int)1);
        Assert.assertEquals((String)((String)entityResult.getUpdateEntities().get(0)), (String)this.tableId._getId());
        this.verifyArrayUpdates("hive_table", "name", (String)this.table.get("name"), columns, "columns");
        HashMap<String, String> valuesCol5 = new HashMap<String, String>();
        valuesCol5.put("name", "col2");
        valuesCol5.put("type", "type");
        Referenceable col2 = new Referenceable("column_type", valuesCol5);
        col1.set("type", (Object)"type1");
        columns.add(col2);
        tableUpdated = new Referenceable("hive_table", (Map)new HashMap<String, Object>(){
            {
                this.put("columns", columns);
            }
        });
        entityResult = this.updateEntityPartial(this.tableId._getId(), tableUpdated);
        Assert.assertEquals((int)entityResult.getCreatedEntities().size(), (int)1);
        Assert.assertEquals((int)entityResult.getUpdateEntities().size(), (int)2);
        this.verifyArrayUpdates("hive_table", "name", (String)this.table.get("name"), columns, "columns");
        HashMap<String, String> values1 = new HashMap<String, String>();
        values1.put("name", "col3");
        values1.put("type", "type");
        Referenceable col3 = new Referenceable("column_type", values1);
        columns.add(col3);
        HashMap<String, String> values2 = new HashMap<String, String>();
        values2.put("name", "col4");
        values2.put("type", "type");
        Referenceable col4 = new Referenceable("column_type", values2);
        columns.add(col4);
        this.table.set("columns", columns);
        entityResult = this.updateInstance(this.table);
        Assert.assertEquals((int)entityResult.getCreatedEntities().size(), (int)2);
        this.verifyArrayUpdates("hive_table", "name", (String)this.table.get("name"), columns, "columns");
        columns.clear();
        columns.add(col4);
        columns.add(col3);
        this.table.set("columns", columns);
        entityResult = this.updateInstance(this.table);
        Assert.assertEquals((int)entityResult.getDeletedEntities().size(), (int)2);
        this.verifyArrayUpdates("hive_table", "name", (String)this.table.get("name"), columns, "columns");
        columns.clear();
        columns.add(col3);
        this.table.set("columns", columns);
        entityResult = this.updateInstance(this.table);
        Assert.assertEquals((int)entityResult.getDeletedEntities().size(), (int)1);
        this.verifyArrayUpdates("hive_table", "name", (String)this.table.get("name"), columns, "columns");
        values.clear();
        columns.clear();
        values.put("name", "col5");
        values.put("type", "type");
        Referenceable col5 = new Referenceable("column_type", values);
        columns.add(col5);
        this.table.set("columns", columns);
        entityResult = this.updateInstance(this.table);
        Assert.assertEquals((int)entityResult.getCreatedEntities().size(), (int)1);
        Assert.assertEquals((int)entityResult.getDeletedEntities().size(), (int)1);
        this.verifyArrayUpdates("hive_table", "name", (String)this.table.get("name"), columns, "columns");
        this.table.setNull("columns");
        entityResult = this.updateInstance(this.table);
        Assert.assertEquals((int)entityResult.getDeletedEntities().size(), (int)1);
        this.verifyArrayUpdates("hive_table", "name", (String)this.table.get("name"), null, "columns");
    }

    private void verifyArrayUpdates(String typeName, String uniqAttrName, String uniqAttrValue, List<Referenceable> expectedArray, String arrAttrName) throws AtlasException {
        String json = this.metadataService.getEntityDefinition(typeName, uniqAttrName, uniqAttrValue);
        Referenceable entityDefinition = InstanceSerialization.fromJsonReferenceable((String)json, (boolean)true);
        List actualArray = (List)entityDefinition.get(arrAttrName);
        if (expectedArray == null && actualArray != null) {
            for (int index = 0; index < actualArray.size(); ++index) {
                Assert.assertEquals((Object)((Referenceable)actualArray.get((int)index)).getId().state, (Object)Id.EntityState.DELETED);
            }
        } else if (expectedArray == null) {
            Assert.assertNull((Object)actualArray);
        } else {
            int index;
            for (index = 0; index < expectedArray.size(); ++index) {
                Assert.assertTrue((boolean)((Referenceable)actualArray.get(index)).equalsContents((Object)expectedArray.get(index)));
            }
            while (index < actualArray.size()) {
                Assert.assertEquals((Object)((Referenceable)actualArray.get((int)index)).getId().state, (Object)Id.EntityState.DELETED);
                ++index;
            }
        }
    }

    @Test
    public void testStructs() throws Exception {
        Struct serdeInstance = new Struct("serdeType");
        serdeInstance.set("name", (Object)"serde1Name");
        serdeInstance.set("serde", (Object)"test");
        serdeInstance.set("description", (Object)"testDesc");
        this.table.set("serde1", (Object)serdeInstance);
        String newtableId = (String)this.updateInstance(this.table).getUpdateEntities().get(0);
        Assert.assertEquals((String)newtableId, (String)this.tableId._getId());
        String tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        Referenceable tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertNotNull((Object)tableDefinition.get("serde1"));
        Assert.assertTrue((boolean)serdeInstance.equalsContents(tableDefinition.get("serde1")));
        serdeInstance.set("serde", (Object)"testUpdated");
        this.updateInstance(this.table);
        tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertTrue((boolean)serdeInstance.equalsContents(tableDefinition.get("serde1")));
        serdeInstance.setNull("description");
        this.updateInstance(this.table);
        tableDefinitionJson = this.metadataService.getEntityDefinition(this.tableId._getId());
        tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertNull((Object)((Struct)tableDefinition.get("serde1")).get("description"));
    }

    @Test
    public void testCreateEntityWithReferenceableHavingIdNoValue() throws Exception {
        Referenceable sdReferenceable = new Referenceable("hive_storagedesc", new String[0]);
        sdReferenceable.set("qualifiedName", (Object)TestUtils.randomString());
        sdReferenceable.set("compressed", (Object)"false");
        sdReferenceable.set("location", (Object)"hdfs://tmp/hive-user");
        String sdGuid = TestUtils.createInstance(this.metadataService, sdReferenceable);
        Referenceable sdRef2 = new Referenceable(sdGuid, "hive_storagedesc", null);
        Referenceable partRef = new Referenceable("partition_class_type", new String[0]);
        partRef.set("qualifiedName", (Object)"part-unique");
        partRef.set("values", (Object)ImmutableList.of((Object)"2014-10-01"));
        partRef.set("table", (Object)this.table);
        partRef.set("sd", (Object)sdRef2);
        String partGuid = TestUtils.createInstance(this.metadataService, partRef);
        Assert.assertNotNull((Object)partGuid);
    }

    @Test
    public void testClassUpdate() throws Exception {
        Referenceable databaseInstance = new Referenceable("hive_database", new String[0]);
        databaseInstance.set("name", (Object)TestUtils.randomString());
        databaseInstance.set("description", (Object)"new database");
        String dbId = TestUtils.createInstance(this.metadataService, databaseInstance);
        this.metadataService.updateEntityAttributeByGuid(this.tableId._getId(), "database", dbId);
        String tableDefinitionJson = this.metadataService.getEntityDefinition(this.tableId._getId());
        Referenceable tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertEquals((String)dbId, (String)((Id)tableDefinition.get("database"))._getId());
    }

    @Test
    public void testArrayOfStructs() throws Exception {
        TestUtils.dumpGraph((TitanGraph)this.graphProvider.get());
        final Struct partition1 = new Struct("partition_struct_type");
        partition1.set("name", (Object)"part1");
        final Struct partition2 = new Struct("partition_struct_type");
        partition2.set("name", (Object)"part2");
        ArrayList<Struct> partitions = new ArrayList<Struct>(){
            {
                this.add(partition1);
                this.add(partition2);
            }
        };
        this.table.set("partitions", (Object)partitions);
        String newtableId = (String)this.updateInstance(this.table).getUpdateEntities().get(0);
        Assert.assertEquals((String)newtableId, (String)this.tableId._getId());
        String tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        Referenceable tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertNotNull((Object)tableDefinition.get("partitions"));
        List partitionsActual = (List)tableDefinition.get("partitions");
        this.assertPartitions(partitionsActual, (List<Struct>)partitions);
        Struct partition3 = new Struct("partition_struct_type");
        partition3.set("name", (Object)"part3");
        partitions.add(partition3);
        this.table.set("partitions", (Object)partitions);
        newtableId = (String)this.updateInstance(this.table).getUpdateEntities().get(0);
        Assert.assertEquals((String)newtableId, (String)this.tableId._getId());
        tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertNotNull((Object)tableDefinition.get("partitions"));
        partitionsActual = (List)tableDefinition.get("partitions");
        this.assertPartitions(partitionsActual, (List<Struct>)partitions);
        partitions.remove(1);
        this.table.set("partitions", (Object)partitions);
        newtableId = (String)this.updateInstance(this.table).getUpdateEntities().get(0);
        Assert.assertEquals((String)newtableId, (String)this.tableId._getId());
        tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertNotNull((Object)tableDefinition.get("partitions"));
        partitionsActual = (List)tableDefinition.get("partitions");
        this.assertPartitions(partitionsActual, (List<Struct>)partitions);
        ((Struct)partitions.get(0)).set("name", (Object)"part4");
        newtableId = (String)this.updateInstance(this.table).getUpdateEntities().get(0);
        Assert.assertEquals((String)newtableId, (String)this.tableId._getId());
        tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertNotNull((Object)tableDefinition.get("partitions"));
        partitionsActual = (List)tableDefinition.get("partitions");
        this.assertPartitions(partitionsActual, (List<Struct>)partitions);
        Struct partition4 = new Struct("partition_struct_type");
        partition4.set("name", (Object)"part4");
        partitions.add(partition4);
        this.table.set("partitions", (Object)partitions);
        newtableId = (String)this.updateInstance(this.table).getUpdateEntities().get(0);
        Assert.assertEquals((String)newtableId, (String)this.tableId._getId());
        tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertNotNull((Object)tableDefinition.get("partitions"));
        partitionsActual = (List)tableDefinition.get("partitions");
        this.assertPartitions(partitionsActual, (List<Struct>)partitions);
        partitions.clear();
        newtableId = (String)this.updateInstance(this.table).getUpdateEntities().get(0);
        Assert.assertEquals((String)newtableId, (String)this.tableId._getId());
        tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertNull((Object)tableDefinition.get("partitions"));
    }

    private void assertPartitions(List<Struct> partitionsActual, List<Struct> partitions) {
        Assert.assertEquals((int)partitionsActual.size(), (int)partitions.size());
        for (int index = 0; index < partitions.size(); ++index) {
            Assert.assertTrue((boolean)partitionsActual.get(index).equalsContents((Object)partitions.get(index)));
        }
    }

    @Test(expectedExceptions={ValueConversionException.class})
    public void testCreateRequiredAttrNull() throws Exception {
        Referenceable tableEntity = new Referenceable("hive_table", new String[0]);
        tableEntity.set("name", (Object)("table_" + TestUtils.randomString()));
        TestUtils.createInstance(this.metadataService, tableEntity);
        Assert.fail((String)"Expected exception while creating with required attribute null");
    }

    @Test(expectedExceptions={ValueConversionException.class})
    public void testUpdateRequiredAttrToNull() throws Exception {
        String tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        Referenceable tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertEquals((Object)tableDefinition.get("description"), (Object)"random table");
        this.table.setNull("description");
        this.updateInstance(this.table);
        Assert.fail((String)"Expected exception while updating required attribute to null");
    }

    @Test
    public void testCheckOptionalAttrValueRetention() throws Exception {
        Referenceable entity = TestUtils.createDBEntity();
        String dbId = TestUtils.createInstance(this.metadataService, entity);
        entity = this.getEntity(dbId);
        String isReplicatedAttr = "isReplicated";
        String paramsAttr = "parameters";
        Assert.assertNotNull((Object)entity.get("isReplicated"));
        Assert.assertEquals((Object)entity.get("isReplicated"), (Object)Boolean.FALSE);
        Assert.assertNull((Object)entity.get("parameters"));
        entity.set("isReplicated", (Object)Boolean.TRUE);
        HashMap<String, String> params = new HashMap<String, String>(){
            {
                this.put("param1", "val1");
                this.put("param2", "val2");
            }
        };
        entity.set("parameters", (Object)params);
        this.updateInstance(entity);
        entity = this.getEntity(dbId);
        Assert.assertNotNull((Object)entity.get("isReplicated"));
        Assert.assertEquals((Object)entity.get("isReplicated"), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)entity.get("parameters"), (Object)params);
        Referenceable newEntity = TestUtils.createDBEntity();
        newEntity.set("name", entity.get("name"));
        this.updateInstance(newEntity);
        entity = this.getEntity(dbId);
        Assert.assertNotNull((Object)entity.get("isReplicated"));
        Assert.assertEquals((Object)entity.get("isReplicated"), (Object)Boolean.TRUE);
        Assert.assertEquals((Object)entity.get("parameters"), (Object)params);
    }

    private Referenceable getEntity(String guid) throws AtlasException {
        String entityJson = this.metadataService.getEntityDefinition(guid);
        Assert.assertNotNull((Object)entityJson);
        return InstanceSerialization.fromJsonReferenceable((String)entityJson, (boolean)true);
    }

    @Test
    public void testUpdateOptionalAttrToNull() throws Exception {
        String tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        Referenceable tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertNotNull((Object)tableDefinition.get("created"));
        this.table.setNull("created");
        String newtableId = (String)this.updateInstance(this.table).getUpdateEntities().get(0);
        Assert.assertEquals((String)newtableId, (String)this.tableId._getId());
        tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        Assert.assertNull((Object)tableDefinition.get("created"));
    }

    @Test
    public void testCreateEntityWithEnum() throws Exception {
        String tableDefinitionJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)this.table.get("name"));
        Referenceable tableDefinition = InstanceSerialization.fromJsonReferenceable((String)tableDefinitionJson, (boolean)true);
        EnumValue tableType = (EnumValue)tableDefinition.get("tableType");
        Assert.assertEquals((Object)tableType, (Object)new EnumValue("MANAGED", 1));
    }

    @Test
    public void testGetEntityByUniqueAttribute() throws Exception {
        Referenceable entity = TestUtils.createDBEntity();
        TestUtils.createInstance(this.metadataService, entity);
        String entityJson = this.metadataService.getEntityDefinition("hive_database", "name", (String)entity.get("name"));
        Assert.assertNotNull((Object)entityJson);
        Referenceable referenceable = InstanceSerialization.fromJsonReferenceable((String)entityJson, (boolean)true);
        Assert.assertEquals((Object)referenceable.get("name"), (Object)entity.get("name"));
        try {
            this.metadataService.getEntityDefinition("hive_database", "name", "random");
            Assert.fail((String)"Expected EntityNotFoundException");
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
        try {
            this.metadataService.getEntityDefinition("hive_database", "description", (String)entity.get("description"));
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteEntities() throws Exception {
        Referenceable dbEntity = TestUtils.createDBEntity();
        String dbGuid = TestUtils.createInstance(this.metadataService, dbEntity);
        Referenceable table1Entity = TestUtils.createTableEntity(dbGuid);
        Referenceable col1 = TestUtils.createColumnEntity();
        Referenceable col2 = TestUtils.createColumnEntity();
        Referenceable col3 = TestUtils.createColumnEntity();
        table1Entity.set("columns", (Object)ImmutableList.of((Object)col1, (Object)col2, (Object)col3));
        TestUtils.createInstance(this.metadataService, table1Entity);
        String entityJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)table1Entity.get("name"));
        Assert.assertNotNull((Object)entityJson);
        table1Entity = InstanceSerialization.fromJsonReferenceable((String)entityJson, (boolean)true);
        List table1Columns = (List)table1Entity.get("columns");
        EntitiesChangeListener listener = new EntitiesChangeListener();
        this.metadataService.registerListener((EntityChangeListener)listener);
        String columnId = ((IReferenceableInstance)table1Columns.get(0)).getId()._getId();
        AtlasClient.EntityResult entityResult = this.deleteEntities(columnId);
        Assert.assertEquals((String)((String)entityResult.getDeletedEntities().get(0)), (String)columnId);
        Assert.assertEquals((String)((String)entityResult.getUpdateEntities().get(0)), (String)table1Entity.getId()._getId());
        Assert.assertEquals((Collection)entityResult.getDeletedEntities(), listener.getDeletedEntities());
        Assert.assertEquals((Collection)entityResult.getUpdateEntities(), listener.getUpdatedEntities());
        entityResult = this.deleteEntities(table1Entity.getId()._getId());
        Assert.assertTrue((boolean)entityResult.getDeletedEntities().contains(table1Entity.getId()._getId()));
        Assert.assertTrue((boolean)entityResult.getDeletedEntities().contains(((IReferenceableInstance)table1Columns.get(1)).getId()._getId()));
        Assert.assertTrue((boolean)entityResult.getDeletedEntities().contains(((IReferenceableInstance)table1Columns.get(2)).getId()._getId()));
        this.assertEntityDeleted("hive_table", "name", table1Entity.get("name"));
        this.assertEntityDeleted("column_type", "name", col2.get("name"));
        this.assertEntityDeleted("column_type", "name", col3.get("name"));
        List<String> deletedEntitiesFromListener = listener.getDeletedEntities();
        Assert.assertNotNull(deletedEntitiesFromListener);
        Assert.assertEquals((int)deletedEntitiesFromListener.size(), (int)entityResult.getDeletedEntities().size());
        Assert.assertTrue((boolean)deletedEntitiesFromListener.containsAll(entityResult.getDeletedEntities()));
    }

    private void assertEntityDeleted(String typeName, String attributeName, Object attributeValue) throws AtlasException {
        try {
            this.metadataService.getEntityDefinition(typeName, attributeName, (String)attributeValue);
            Assert.fail((String)"Expected EntityNotFoundException");
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteEntityByUniqueAttribute() throws Exception {
        Referenceable dbEntity = TestUtils.createDBEntity();
        String dbGuid = TestUtils.createInstance(this.metadataService, dbEntity);
        Referenceable table1Entity = TestUtils.createTableEntity(dbGuid);
        Referenceable col1 = TestUtils.createColumnEntity();
        Referenceable col2 = TestUtils.createColumnEntity();
        Referenceable col3 = TestUtils.createColumnEntity();
        table1Entity.set("columns", (Object)ImmutableList.of((Object)col1, (Object)col2, (Object)col3));
        TestUtils.createInstance(this.metadataService, table1Entity);
        String entityJson = this.metadataService.getEntityDefinition("hive_table", "name", (String)table1Entity.get("name"));
        Assert.assertNotNull((Object)entityJson);
        table1Entity = InstanceSerialization.fromJsonReferenceable((String)entityJson, (boolean)true);
        List table1Columns = (List)table1Entity.get("columns");
        EntitiesChangeListener listener = new EntitiesChangeListener();
        this.metadataService.registerListener((EntityChangeListener)listener);
        List deletedGuids = this.metadataService.deleteEntityByUniqueAttribute("hive_table", "name", (String)table1Entity.get("name")).getDeletedEntities();
        Assert.assertTrue((boolean)deletedGuids.contains(table1Entity.getId()._getId()));
        for (IReferenceableInstance column : table1Columns) {
            Assert.assertTrue((boolean)deletedGuids.contains(column.getId()._getId()));
        }
        this.assertEntityDeleted("hive_table", "name", table1Entity.get("name"));
        this.assertEntityDeleted("column_type", "name", col1.get("name"));
        this.assertEntityDeleted("column_type", "name", col2.get("name"));
        this.assertEntityDeleted("column_type", "name", col3.get("name"));
        List<String> deletedEntitiesFromListener = listener.getDeletedEntities();
        Assert.assertNotNull(deletedEntitiesFromListener);
        Assert.assertEquals((int)deletedEntitiesFromListener.size(), (int)deletedGuids.size());
        Assert.assertTrue((boolean)deletedEntitiesFromListener.containsAll(deletedGuids));
    }

    @Test
    public void testTypeUpdateFailureShouldRollBack() throws AtlasException, JSONException {
        String typeName = "test_type_" + RandomStringUtils.randomAlphanumeric((int)10);
        HierarchicalTypeDefinition typeDef = TypesUtil.createClassTypeDef((String)typeName, (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createUniqueRequiredAttrDef((String)"test_type_attribute", (IDataType)DataTypes.STRING_TYPE)});
        TypesDef typesDef = new TypesDef(typeDef, false);
        JSONObject type = this.metadataService.createType(TypesSerialization.toJson((TypesDef)typesDef));
        Assert.assertNotNull((Object)type.get("types"));
        HierarchicalTypeDefinition updatedTypeDef = TypesUtil.createClassTypeDef((String)typeName, (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createUniqueRequiredAttrDef((String)"test_type_attribute", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createRequiredAttrDef((String)"test_type_invalid_attribute$", (IDataType)DataTypes.STRING_TYPE)});
        TypesDef updatedTypesDef = new TypesDef(updatedTypeDef, false);
        try {
            this.metadataService.updateType(TypesSerialization.toJson((TypesDef)updatedTypesDef));
            Assert.fail((String)"Expected AtlasException");
        }
        catch (AtlasException e) {
            // empty catch block
        }
        String typeDefinition = this.metadataService.getTypeDefinition(typeName);
        typesDef = TypesSerialization.fromJson((String)typeDefinition);
        Assert.assertEquals((int)((HierarchicalTypeDefinition)typesDef.classTypes().head()).attributeDefinitions.length, (int)1);
    }

    @Test
    public void testAuditEventsInvalidParams() throws Exception {
        try {
            this.metadataService.getAuditEvents(null, "key", (short)10);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"entity id cannot be null");
        }
        try {
            this.metadataService.getAuditEvents("", "key", (short)10);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"entity id cannot be empty");
        }
        this.metadataService.getAuditEvents("id", null, (short)10);
        try {
            this.metadataService.getAuditEvents("id", "", (short)10);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"start key cannot be empty");
        }
        try {
            this.metadataService.getAuditEvents("id", "key", (short)10000);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"count should be <= 1000, current value 10000");
        }
        try {
            this.metadataService.getAuditEvents("id", "key", (short)-1);
            Assert.fail((String)"expected IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"count should be > 0, current value -1");
        }
    }

    private static class EntitiesChangeListener
    implements EntityChangeListener {
        private List<String> deletedEntities = new ArrayList<String>();
        private List<String> updatedEntities = new ArrayList<String>();

        private EntitiesChangeListener() {
        }

        public void onEntitiesAdded(Collection<ITypedReferenceableInstance> entities) throws AtlasException {
        }

        public void onEntitiesUpdated(Collection<ITypedReferenceableInstance> entities) throws AtlasException {
            this.updatedEntities.clear();
            for (ITypedReferenceableInstance entity : entities) {
                this.updatedEntities.add(entity.getId()._getId());
            }
        }

        public void onTraitAdded(ITypedReferenceableInstance entity, IStruct trait) throws AtlasException {
        }

        public void onTraitDeleted(ITypedReferenceableInstance entity, String traitName) throws AtlasException {
        }

        public void onEntitiesDeleted(Collection<ITypedReferenceableInstance> entities) throws AtlasException {
            this.deletedEntities.clear();
            for (ITypedReferenceableInstance entity : entities) {
                this.deletedEntities.add(entity.getId()._getId());
            }
        }

        public List<String> getDeletedEntities() {
            return this.deletedEntities;
        }

        public List<String> getUpdatedEntities() {
            return this.updatedEntities;
        }
    }
}

