/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.typestore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RepositoryMetadataModule;
import org.apache.atlas.TestUtils;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.atlas.repository.typestore.ITypeStore;
import org.apache.atlas.repository.typestore.StoreBackedTypeCache;
import org.apache.atlas.typesystem.types.AttributeInfo;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.HierarchicalType;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.TraitType;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.apache.atlas.typesystem.types.TypeUtils;
import org.apache.atlas.typesystem.types.cache.TypeCache;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={RepositoryMetadataModule.class})
public class StoreBackedTypeCacheTest {
    @Inject
    private GraphProvider<TitanGraph> graphProvider;
    @Inject
    private ITypeStore typeStore;
    @Inject
    private StoreBackedTypeCache typeCache;
    private TypeSystem ts;
    private Map<String, ClassType> classTypesToTest = new HashMap<String, ClassType>();

    @BeforeClass
    public void setUp() throws Exception {
        this.ts = TypeSystem.getInstance();
        this.ts.reset();
        this.ts.setTypeCache((TypeCache)this.typeCache);
        TestUtils.defineDeptEmployeeTypes(this.ts);
        TestUtils.createHiveTypes(this.ts);
        ImmutableList typeNames = this.ts.getTypeNames();
        this.typeStore.store(this.ts, typeNames);
        ClassType type = (ClassType)this.ts.getDataType(ClassType.class, "Manager");
        this.classTypesToTest.put("Manager", type);
        type = (ClassType)this.ts.getDataType(ClassType.class, "hive_table");
        this.classTypesToTest.put("hive_table", type);
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.ts.reset();
        try {
            ((TitanGraph)this.graphProvider.get()).shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TitanCleanup.clear((TitanGraph)((TitanGraph)this.graphProvider.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @BeforeMethod
    public void setupTestMethod() throws Exception {
        this.ts.reset();
    }

    @Test
    public void testGetClassType() throws Exception {
        for (Map.Entry<String, ClassType> typeEntry : this.classTypesToTest.entrySet()) {
            Assert.assertFalse((boolean)this.typeCache.isCachedInMemory(typeEntry.getKey()));
            IDataType dataType = (IDataType)this.ts.getDataType(IDataType.class, typeEntry.getKey());
            Assert.assertTrue((boolean)this.typeCache.isCachedInMemory(typeEntry.getKey()));
            Assert.assertTrue((boolean)(dataType instanceof ClassType));
            ClassType cachedType = (ClassType)dataType;
            this.verifyHierarchicalType((HierarchicalType)cachedType, (HierarchicalType)((HierarchicalType)typeEntry.getValue()));
        }
    }

    @Test
    public void testGetTraitType() throws Exception {
        ImmutableList traitNames = this.ts.getTypeNamesByCategory(DataTypes.TypeCategory.TRAIT);
        for (String traitTypeName : traitNames) {
            Assert.assertFalse((boolean)this.typeCache.isCachedInMemory(traitTypeName));
            IDataType dataType = this.typeCache.get(traitTypeName);
            Assert.assertTrue((boolean)this.typeCache.isCachedInMemory(traitTypeName));
            Assert.assertTrue((boolean)(dataType instanceof TraitType));
            TraitType cachedType = (TraitType)dataType;
            this.verifyHierarchicalType((HierarchicalType)cachedType, (HierarchicalType)((HierarchicalType)this.ts.getDataType(TraitType.class, traitTypeName)));
        }
    }

    private <T extends HierarchicalType> void verifyHierarchicalType(T dataType, T expectedDataType) throws AtlasException {
        Assert.assertEquals((int)dataType.numFields, (int)expectedDataType.numFields);
        Assert.assertEquals((int)dataType.immediateAttrs.size(), (int)expectedDataType.immediateAttrs.size());
        Assert.assertEquals((int)dataType.fieldMapping().fields.size(), (int)expectedDataType.fieldMapping().fields.size());
        ImmutableSet superTypes = dataType.superTypes;
        Assert.assertEquals((int)superTypes.size(), (int)expectedDataType.superTypes.size());
        for (String superTypeName : superTypes) {
            Assert.assertTrue((boolean)this.typeCache.has(superTypeName));
        }
        block6: for (AttributeInfo attrInfo : dataType.fieldMapping().fields.values()) {
            switch (attrInfo.dataType().getTypeCategory()) {
                case CLASS: 
                case STRUCT: 
                case ENUM: {
                    Assert.assertTrue((boolean)this.typeCache.has(attrInfo.dataType().getName()), (String)(attrInfo.dataType().getName() + " should be cached"));
                    break;
                }
                case ARRAY: {
                    String elementTypeName = TypeUtils.parseAsArrayType((String)attrInfo.dataType().getName());
                    if (this.ts.getCoreTypes().contains((Object)elementTypeName)) break;
                    Assert.assertTrue((boolean)this.typeCache.has(elementTypeName), (String)(elementTypeName + " should be cached"));
                    break;
                }
                case MAP: {
                    String[] mapTypeNames;
                    for (String typeName : mapTypeNames = TypeUtils.parseAsMapType((String)attrInfo.dataType().getName())) {
                        if (this.ts.getCoreTypes().contains((Object)typeName)) continue;
                        Assert.assertTrue((boolean)this.typeCache.has(typeName), (String)(typeName + " should be cached"));
                    }
                    continue block6;
                }
            }
        }
    }
}

