/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.typestore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RepositoryMetadataModule;
import org.apache.atlas.TestUtils;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.atlas.repository.typestore.GraphBackedTypeStore;
import org.apache.atlas.repository.typestore.ITypeStore;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.AttributeInfo;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.EnumType;
import org.apache.atlas.typesystem.types.EnumTypeDefinition;
import org.apache.atlas.typesystem.types.EnumValue;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.StructType;
import org.apache.atlas.typesystem.types.StructTypeDefinition;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.apache.atlas.typesystem.types.utils.TypesUtil;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={RepositoryMetadataModule.class})
public class GraphBackedTypeStoreTest {
    private static final String DESCRIPTION = "_description";
    @Inject
    private GraphProvider<TitanGraph> graphProvider;
    @Inject
    private ITypeStore typeStore;
    private TypeSystem ts;

    @BeforeClass
    public void setUp() throws Exception {
        this.ts = TypeSystem.getInstance();
        this.ts.reset();
        TestUtils.defineDeptEmployeeTypes(this.ts);
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.ts.reset();
        try {
            ((TitanGraph)this.graphProvider.get()).shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TitanCleanup.clear((TitanGraph)((TitanGraph)this.graphProvider.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testStore() throws AtlasException {
        ImmutableList typeNames = this.ts.getTypeNames();
        this.typeStore.store(this.ts, typeNames);
        this.dumpGraph();
    }

    @Test(dependsOnMethods={"testStore"})
    public void testRestoreType() throws Exception {
        TypesDef typesDef = ((GraphBackedTypeStore)this.typeStore).restoreType("Manager");
        this.verifyRestoredClassType(typesDef, "Manager");
    }

    private void dumpGraph() {
        TitanGraph graph = (TitanGraph)this.graphProvider.get();
        for (Vertex v : graph.getVertices()) {
            System.out.println("****v = " + GraphHelper.vertexString((Vertex)v));
            for (Edge e : v.getEdges(Direction.OUT, new String[0])) {
                System.out.println("****e = " + GraphHelper.edgeString((Edge)e));
            }
        }
    }

    @Test(dependsOnMethods={"testStore"})
    public void testRestore() throws Exception {
        TypesDef types = this.typeStore.restore();
        List enumTypes = types.enumTypesAsJavaList();
        Assert.assertEquals((int)1, (int)enumTypes.size());
        EnumTypeDefinition orgLevel = (EnumTypeDefinition)enumTypes.get(0);
        Assert.assertEquals((String)orgLevel.name, (String)"OrgLevel");
        Assert.assertEquals((String)orgLevel.description, (String)"OrgLevel_description");
        Assert.assertEquals((int)orgLevel.enumValues.length, (int)2);
        EnumValue enumValue = orgLevel.enumValues[0];
        Assert.assertEquals((String)enumValue.value, (String)"L1");
        Assert.assertEquals((int)enumValue.ordinal, (int)1);
        List structTypes = types.structTypesAsJavaList();
        Assert.assertEquals((int)1, (int)structTypes.size());
        this.verifyRestoredClassType(types, "Manager");
        List traitTypes = types.traitTypesAsJavaList();
        Assert.assertEquals((int)1, (int)traitTypes.size());
        HierarchicalTypeDefinition trait = (HierarchicalTypeDefinition)traitTypes.get(0);
        Assert.assertEquals((String)"SecurityClearance", (String)trait.typeName);
        Assert.assertEquals((String)(trait.typeName + DESCRIPTION), (String)trait.typeDescription);
        Assert.assertEquals((int)1, (int)trait.attributeDefinitions.length);
        AttributeDefinition attribute = trait.attributeDefinitions[0];
        Assert.assertEquals((String)"level", (String)attribute.name);
        Assert.assertEquals((String)DataTypes.INT_TYPE.getName(), (String)attribute.dataTypeName);
        this.ts.reset();
        this.ts.defineTypes(types);
    }

    @Test(dependsOnMethods={"testStore"})
    public void testTypeUpdate() throws Exception {
        String _description = "_description_updated";
        EnumTypeDefinition orgLevelEnum = new EnumTypeDefinition("OrgLevel", "OrgLevel" + _description, new EnumValue[]{new EnumValue("L1", 1), new EnumValue("L2", 2), new EnumValue("L3", 3)});
        StructTypeDefinition addressDetails = TypesUtil.createStructTypeDef((String)"Address", (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createRequiredAttrDef((String)"street", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createRequiredAttrDef((String)"city", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createOptionalAttrDef((String)"state", (IDataType)DataTypes.STRING_TYPE)});
        HierarchicalTypeDefinition deptTypeDef = TypesUtil.createClassTypeDef((String)"Department", (String)("Department" + _description), (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createRequiredAttrDef((String)"name", (IDataType)DataTypes.STRING_TYPE), new AttributeDefinition("employees", String.format("array<%s>", "Person"), Multiplicity.OPTIONAL, true, "department")});
        TypesDef typesDef = TypesUtil.getTypesDef((ImmutableList)ImmutableList.of((Object)orgLevelEnum), (ImmutableList)ImmutableList.of((Object)addressDetails), (ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of((Object)deptTypeDef));
        Map typesAdded = this.ts.updateTypes(typesDef);
        this.typeStore.store(this.ts, ImmutableList.copyOf(typesAdded.keySet()));
        this.verifyEdges();
        TypesDef types = this.typeStore.restore();
        this.ts.reset();
        this.ts.defineTypes(types);
        EnumType orgLevel = (EnumType)this.ts.getDataType(EnumType.class, orgLevelEnum.name);
        Assert.assertEquals((String)orgLevel.name, (String)orgLevelEnum.name);
        Assert.assertEquals((String)orgLevel.description, (String)orgLevelEnum.description);
        Assert.assertEquals((int)orgLevel.values().size(), (int)orgLevelEnum.enumValues.length);
        Assert.assertEquals((int)orgLevel.fromValue((String)"L3").ordinal, (int)3);
        StructType addressType = (StructType)this.ts.getDataType(StructType.class, addressDetails.typeName);
        Assert.assertEquals((int)addressType.numFields, (int)3);
        Assert.assertEquals((Object)((AttributeInfo)addressType.fieldMapping.fields.get("state")).dataType(), (Object)DataTypes.STRING_TYPE);
        typesDef = TypesUtil.getTypesDef((ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of((Object)deptTypeDef));
        typesAdded = this.ts.updateTypes(typesDef);
        this.typeStore.store(this.ts, ImmutableList.copyOf(typesAdded.keySet()));
        this.verifyEdges();
    }

    private void verifyEdges() {
        if (this.typeStore instanceof GraphBackedTypeStore) {
            GraphBackedTypeStore gbTypeStore = (GraphBackedTypeStore)this.typeStore;
            Vertex typeVertex = gbTypeStore.findVertex(DataTypes.TypeCategory.CLASS, "Department");
            int edgeCount = this.countOutgoingEdges(typeVertex, gbTypeStore.getEdgeLabel("Department", "employees"));
            Assert.assertEquals((int)edgeCount, (int)1, (String)"Should only be 1 edge for employees attribute on Department type vertex");
        }
    }

    private int countOutgoingEdges(Vertex typeVertex, String edgeLabel) {
        Iterator outGoingEdgesByLabel = GraphHelper.getInstance().getOutGoingEdgesByLabel(typeVertex, edgeLabel);
        int edgeCount = 0;
        Iterator iterator = outGoingEdgesByLabel;
        while (iterator.hasNext()) {
            iterator.next();
            ++edgeCount;
        }
        return edgeCount;
    }

    private void verifyRestoredClassType(TypesDef types, String typeName) throws AtlasException {
        boolean clsTypeFound = false;
        List classTypes = types.classTypesAsJavaList();
        for (HierarchicalTypeDefinition classType : classTypes) {
            if (!classType.typeName.equals(typeName)) continue;
            ClassType expectedType = (ClassType)this.ts.getDataType(ClassType.class, classType.typeName);
            Assert.assertEquals((int)expectedType.immediateAttrs.size(), (int)classType.attributeDefinitions.length);
            Assert.assertEquals((int)expectedType.superTypes.size(), (int)classType.superTypes.size());
            Assert.assertEquals((String)classType.typeDescription, (String)(classType.typeName + DESCRIPTION));
            clsTypeFound = true;
        }
        Assert.assertTrue((boolean)clsTypeFound, (String)(typeName + " type not restored"));
    }
}

