/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.atlas.repository.graph.TitanGraphProvider;
import org.apache.commons.configuration.Configuration;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test
public class TitanGraphProviderTest {
    private Configuration configuration;
    private TitanGraph graph;

    @BeforeTest
    public void setUp() throws AtlasException {
        this.graph = TitanGraphProvider.getGraphInstance();
        this.configuration = ApplicationProperties.getSubsetConfiguration((Configuration)ApplicationProperties.get(), (String)"atlas.graph");
    }

    @AfterClass
    public void tearDown() throws Exception {
        try {
            this.graph.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TitanCleanup.clear((TitanGraph)this.graph);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testValidate() throws AtlasException {
        try {
            TitanGraphProvider.validateIndexBackend((Configuration)this.configuration);
        }
        catch (Exception e) {
            Assert.fail((String)"Unexpected exception ", (Throwable)e);
        }
        this.configuration.setProperty("index.search.backend", (Object)"lucene");
        try {
            TitanGraphProvider.validateIndexBackend((Configuration)this.configuration);
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Configured Index Backend lucene differs from earlier configured Index Backend elasticsearch. Aborting!");
        }
    }
}

