/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanGraphQuery;
import com.thinkaurelius.titan.core.TitanIndexQuery;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.inject.Inject;
import org.apache.atlas.GraphTransaction;
import org.apache.atlas.RepositoryMetadataModule;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestUtils;
import org.apache.atlas.repository.graph.GraphBackedMetadataRepository;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.atlas.typesystem.ITypedReferenceableInstance;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.Struct;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test
@Guice(modules={RepositoryMetadataModule.class})
public class GraphRepoMapperScaleTest {
    private static final String DATABASE_NAME = "foo";
    private static final String TABLE_NAME = "bar";
    @Inject
    GraphProvider<TitanGraph> graphProvider;
    @Inject
    private GraphBackedMetadataRepository repositoryService;
    @Inject
    private GraphBackedSearchIndexer searchIndexer;
    private TypeSystem typeSystem = TypeSystem.getInstance();
    private String dbGUID;

    @BeforeClass
    @GraphTransaction
    public void setUp() throws Exception {
        Collection<IDataType> typesAdded = TestUtils.createHiveTypes(this.typeSystem);
        this.searchIndexer.onAdd(typesAdded);
    }

    @BeforeMethod
    public void setupContext() {
        RequestContext.createContext();
    }

    @AfterClass
    public void tearDown() throws Exception {
        TypeSystem.getInstance().reset();
        try {
            ((TitanGraph)this.graphProvider.get()).shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TitanCleanup.clear((TitanGraph)((TitanGraph)this.graphProvider.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testSubmitEntity() throws Exception {
        Referenceable databaseInstance = new Referenceable("hive_database", new String[0]);
        databaseInstance.set("name", (Object)DATABASE_NAME);
        databaseInstance.set("description", (Object)"foo database");
        ClassType dbType = (ClassType)this.typeSystem.getDataType(ClassType.class, "hive_database");
        ITypedReferenceableInstance db = dbType.convert((Object)databaseInstance, Multiplicity.REQUIRED);
        this.dbGUID = (String)this.repositoryService.createEntities(new ITypedReferenceableInstance[]{db}).get(0);
        Referenceable dbInstance = new Referenceable(this.dbGUID, "hive_database", databaseInstance.getValuesMap());
        for (int index = 0; index < 1000; ++index) {
            ITypedReferenceableInstance table = this.createHiveTableInstance(dbInstance, index);
            this.repositoryService.createEntities(new ITypedReferenceableInstance[]{table});
        }
    }

    @Test(dependsOnMethods={"testSubmitEntity"})
    public void testSearchIndex() throws Exception {
        Thread.sleep(5000L);
        this.searchWithOutIndex("__guid", this.dbGUID);
        this.searchWithOutIndex("__typeName", "column_type");
        this.searchWithOutIndex("__typeName", "hive_table");
        this.searchWithOutIndex("hive_table.name", "bar-999");
        this.searchWithIndex("hive_table.name", "bar-999");
        this.searchWithIndex("hive_table.created", (Predicate)Compare.GREATER_THAN_EQUAL, 1418265358440L, 1000);
        for (int index = 500; index < 600; ++index) {
            this.searchWithIndex("hive_table.name", "bar-" + index);
        }
        this.searchWithIndex("__state", Id.EntityState.ACTIVE.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchWithOutIndex(String key, String value) {
        TitanGraph graph = (TitanGraph)this.graphProvider.get();
        long start = System.currentTimeMillis();
        int count = 0;
        try {
            TitanGraphQuery query = graph.query().has(key, (Predicate)Compare.EQUAL, (Object)value);
            for (Vertex ignored : query.vertices()) {
                ++count;
            }
        }
        finally {
            System.out.println("Search on [" + key + "=" + value + "] returned results: " + count + ", took " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchWithIndex(String key, String value) {
        TitanGraph graph = (TitanGraph)this.graphProvider.get();
        long start = System.currentTimeMillis();
        int count = 0;
        try {
            String queryString = "v.\"" + key + "\":(" + value + ")";
            TitanIndexQuery query = graph.indexQuery("vertex_index", queryString);
            for (TitanIndexQuery.Result ignored : query.vertices()) {
                ++count;
            }
        }
        finally {
            System.out.println("Search on [" + key + "=" + value + "] returned results: " + count + ", took " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchWithIndex(String key, Predicate searchPredicate, Object value, int expectedResults) {
        TitanGraph graph = (TitanGraph)this.graphProvider.get();
        long start = System.currentTimeMillis();
        int count = 0;
        try {
            TitanGraphQuery query = graph.query().has(key, searchPredicate, value);
            for (Vertex ignored : query.vertices()) {
                ++count;
            }
        }
        finally {
            System.out.println("Search on [" + key + "=" + value + "] returned results: " + count + ", took " + (System.currentTimeMillis() - start) + " ms");
            Assert.assertEquals((int)count, (int)expectedResults);
        }
    }

    private ITypedReferenceableInstance createHiveTableInstance(Referenceable databaseInstance, int uberIndex) throws Exception {
        Referenceable tableInstance = new Referenceable("hive_table", new String[0]);
        tableInstance.set("name", (Object)("bar-" + uberIndex));
        tableInstance.set("description", (Object)("bar table-" + uberIndex));
        tableInstance.set("type", (Object)"managed");
        tableInstance.set("created", (Object)new Date(1418265358440L));
        tableInstance.set("tableType", (Object)1);
        tableInstance.set("database", (Object)databaseInstance);
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("first_name-" + uberIndex);
        columnNames.add("last_name-" + uberIndex);
        tableInstance.set("columnNames", columnNames);
        Struct serde1Instance = new Struct("serdeType");
        serde1Instance.set("name", (Object)("serde1-" + uberIndex));
        serde1Instance.set("serde", (Object)("serde1-" + uberIndex));
        tableInstance.set("serde1", (Object)serde1Instance);
        Struct serde2Instance = new Struct("serdeType");
        serde2Instance.set("name", (Object)("serde2-" + uberIndex));
        serde2Instance.set("serde", (Object)("serde2-" + uberIndex));
        tableInstance.set("serde2", (Object)serde2Instance);
        ArrayList<Referenceable> columns = new ArrayList<Referenceable>();
        for (int index = 0; index < 5; ++index) {
            Referenceable columnInstance = new Referenceable("column_type", new String[0]);
            columnInstance.set("name", (Object)("column_-" + uberIndex + "-" + index));
            columnInstance.set("type", (Object)"string");
            columns.add(columnInstance);
        }
        tableInstance.set("columns", columns);
        ArrayList<Struct> partitions = new ArrayList<Struct>();
        for (int index = 0; index < 5; ++index) {
            Struct partitionInstance = new Struct("partition_struct_type");
            partitionInstance.set("name", (Object)("partition_-" + uberIndex + "-" + index));
            partitions.add(partitionInstance);
        }
        tableInstance.set("partitions", partitions);
        ClassType tableType = (ClassType)this.typeSystem.getDataType(ClassType.class, "hive_table");
        return tableType.convert((Object)tableInstance, Multiplicity.REQUIRED);
    }
}

