/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanVertex;
import com.tinkerpop.blueprints.Vertex;
import java.util.Iterator;
import javax.inject.Inject;
import org.apache.atlas.RepositoryMetadataModule;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graph.GraphProvider;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={RepositoryMetadataModule.class})
public class GraphHelperTest {
    @Inject
    private GraphProvider<TitanGraph> graphProvider;

    @DataProvider(name="encodeDecodeTestData")
    private Object[][] createTestData() {
        return new Object[][]{{"hivedb$", "hivedb_d"}, {"hivedb", "hivedb"}, {"{hivedb}", "_ohivedb_c"}, {"%hivedb}", "_phivedb_c"}, {"\"hivedb\"", "_qhivedb_q"}, {"\"$%{}", "_q_d_p_o_c"}, {"", ""}, {"  ", "  "}, {"\n\r", "\n\r"}, {null, null}};
    }

    @Test(dataProvider="encodeDecodeTestData")
    public void testEncodeDecode(String str, String expectedEncodedStr) throws Exception {
        String encodedStr = GraphHelper.encodePropertyKey((String)str);
        Assert.assertEquals((String)encodedStr, (String)expectedEncodedStr);
        String decodedStr = GraphHelper.decodePropertyKey((String)encodedStr);
        Assert.assertEquals((String)decodedStr, (String)str);
    }

    @Test
    public void testGetOutgoingEdgesByLabel() throws Exception {
        TitanGraph graph = (TitanGraph)this.graphProvider.get();
        TitanVertex v1 = graph.addVertex();
        TitanVertex v2 = graph.addVertex();
        v1.addEdge("l1", v2);
        v1.addEdge("l2", v2);
        Iterator iterator = GraphHelper.getInstance().getOutGoingEdgesByLabel((Vertex)v1, "l1");
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertNotNull(iterator.next());
        Assert.assertNull(iterator.next());
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

