/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanVertex;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.Iterator;
import org.apache.atlas.repository.RepositoryException;
import org.apache.atlas.repository.graph.GraphHelper;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GraphHelperMockTest {
    private GraphHelper graphHelperInstance;
    private TitanGraph graph;

    @BeforeClass
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.graph = (TitanGraph)Mockito.mock(TitanGraph.class);
        this.graphHelperInstance = GraphHelper.getInstance((TitanGraph)this.graph);
    }

    @Test(expectedExceptions={RepositoryException.class})
    public void testGetOrCreateEdgeLabelWithMaxRetries() throws Exception {
        String edgeLabel = "testLabel";
        TitanVertex v1 = (TitanVertex)Mockito.mock(TitanVertex.class);
        TitanVertex v2 = (TitanVertex)Mockito.mock(TitanVertex.class);
        Iterable<Edge> noEdgesIterable = new Iterable<Edge>(){

            @Override
            public Iterator<Edge> iterator() {
                return new Iterator<Edge>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public Edge next() {
                        return null;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
        Mockito.when((Object)v2.getEdges(Direction.IN, new String[0])).thenReturn((Object)noEdgesIterable);
        Mockito.when((Object)v1.getEdges(Direction.OUT, new String[0])).thenReturn((Object)noEdgesIterable);
        Mockito.when((Object)v1.getId()).thenReturn((Object)new String("1234"));
        Mockito.when((Object)v2.getId()).thenReturn((Object)new String("5678"));
        Mockito.when((Object)this.graph.addEdge(null, (Vertex)v1, (Vertex)v2, "testLabel")).thenThrow(new Throwable[]{new RuntimeException("Unique property constraint violated")});
        this.graphHelperInstance.getOrCreateEdge((Vertex)v1, (Vertex)v2, "testLabel");
    }

    @Test
    public void testGetOrCreateEdgeLabelWithRetries() throws Exception {
        String edgeLabel = "testLabel";
        TitanVertex v1 = (TitanVertex)Mockito.mock(TitanVertex.class);
        TitanVertex v2 = (TitanVertex)Mockito.mock(TitanVertex.class);
        Edge edge = (Edge)Mockito.mock(Edge.class);
        Iterable<Edge> noEdgesIterable = new Iterable<Edge>(){

            @Override
            public Iterator<Edge> iterator() {
                return new Iterator<Edge>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public Edge next() {
                        return null;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
        Mockito.when((Object)v2.getEdges(Direction.IN, new String[0])).thenReturn((Object)noEdgesIterable);
        Mockito.when((Object)v1.getEdges(Direction.OUT, new String[0])).thenReturn((Object)noEdgesIterable);
        Mockito.when((Object)v1.getId()).thenReturn((Object)new String("v1"));
        Mockito.when((Object)v2.getId()).thenReturn((Object)new String("v2"));
        Mockito.when((Object)edge.getId()).thenReturn((Object)new String("edge"));
        Mockito.when((Object)this.graph.addEdge(null, (Vertex)v1, (Vertex)v2, "testLabel")).thenThrow(new Throwable[]{new RuntimeException("Unique property constraint violated")}).thenReturn((Object)edge);
        Edge redge = this.graphHelperInstance.getOrCreateEdge((Vertex)v1, (Vertex)v2, "testLabel");
        Assert.assertEquals((Object)edge, (Object)redge);
    }
}

