/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import com.google.inject.Inject;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RepositoryMetadataModule;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.EnumType;
import org.apache.atlas.typesystem.types.EnumValue;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.apache.atlas.typesystem.types.utils.TypesUtil;
import org.apache.commons.lang.RandomStringUtils;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={RepositoryMetadataModule.class})
public class GraphBackedSearchIndexerTest {
    @Inject
    private GraphProvider<TitanGraph> graphProvider;
    @Inject
    private GraphBackedSearchIndexer graphBackedSearchIndexer;

    @Test
    public void verifySystemMixedIndexes() {
        TitanGraph titanGraph = (TitanGraph)this.graphProvider.get();
        TitanManagement managementSystem = titanGraph.getManagementSystem();
        TitanGraphIndex vertexIndex = managementSystem.getGraphIndex("vertex_index");
        org.testng.Assert.assertNotNull((Object)vertexIndex);
        Assert.assertTrue((boolean)vertexIndex.isMixedIndex());
        Assert.assertTrue((boolean)Vertex.class.isAssignableFrom(vertexIndex.getIndexedElement()));
        TitanGraphIndex edgeIndex = managementSystem.getGraphIndex("edge_index");
        org.testng.Assert.assertNotNull((Object)edgeIndex);
        Assert.assertTrue((boolean)edgeIndex.isMixedIndex());
        Assert.assertTrue((boolean)Edge.class.isAssignableFrom(edgeIndex.getIndexedElement()));
        this.verifyVertexIndexContains(managementSystem, "__state");
    }

    @Test
    public void verifySystemCompositeIndexes() {
        TitanGraph titanGraph = (TitanGraph)this.graphProvider.get();
        TitanManagement managementSystem = titanGraph.getManagementSystem();
        this.verifySystemCompositeIndex(managementSystem, "__guid", true);
        this.verifyVertexIndexContains(managementSystem, "__guid");
        this.verifySystemCompositeIndex(managementSystem, "__typeName", false);
        this.verifyVertexIndexContains(managementSystem, "__typeName");
        this.verifySystemCompositeIndex(managementSystem, "__superTypeNames", false);
        this.verifyVertexIndexContains(managementSystem, "__superTypeNames");
        this.verifySystemCompositeIndex(managementSystem, "__traitNames", false);
        this.verifyVertexIndexContains(managementSystem, "__traitNames");
    }

    @Test
    public void verifyFullTextIndex() {
        TitanGraph titanGraph = (TitanGraph)this.graphProvider.get();
        TitanManagement managementSystem = titanGraph.getManagementSystem();
        TitanGraphIndex fullTextIndex = managementSystem.getGraphIndex("fulltext_index");
        Assert.assertTrue((boolean)fullTextIndex.isMixedIndex());
        Arrays.asList(fullTextIndex.getFieldKeys()).contains(managementSystem.getPropertyKey("entityText"));
    }

    @Test
    public void verifyTypeStoreIndexes() {
        TitanGraph titanGraph = (TitanGraph)this.graphProvider.get();
        TitanManagement managementSystem = titanGraph.getManagementSystem();
        this.verifySystemCompositeIndex(managementSystem, "__type.name", true);
        this.verifyVertexIndexContains(managementSystem, "__type.name");
        this.verifySystemCompositeIndex(managementSystem, "__type", false);
        this.verifyVertexIndexContains(managementSystem, "__type");
    }

    @Test
    public void verifyUserDefinedTypeIndex() throws AtlasException {
        TitanGraph titanGraph = (TitanGraph)this.graphProvider.get();
        TitanManagement managementSystem = titanGraph.getManagementSystem();
        TypeSystem typeSystem = TypeSystem.getInstance();
        String enumName = "randomEnum" + RandomStringUtils.randomAlphanumeric((int)10);
        EnumType managedType = typeSystem.defineEnumType(enumName, new EnumValue[]{new EnumValue("randomEnumValue", 0)});
        HierarchicalTypeDefinition databaseTypeDefinition = TypesUtil.createClassTypeDef((String)"Database", (String)"Database type description", null, (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createUniqueRequiredAttrDef((String)"name", (IDataType)DataTypes.STRING_TYPE), TypesUtil.createRequiredAttrDef((String)"managedType", (IDataType)managedType)});
        ClassType databaseType = typeSystem.defineClassType(databaseTypeDefinition);
        this.graphBackedSearchIndexer.onAdd(Arrays.asList(databaseType));
        this.verifySystemCompositeIndex(managementSystem, "Database.name__typeName", false);
        this.verifyVertexIndexContains(managementSystem, "Database.name__typeName");
        this.verifySystemCompositeIndex(managementSystem, "Database.name__superTypeNames", false);
        this.verifyVertexIndexContains(managementSystem, "Database.managedType");
    }

    private void verifyVertexIndexContains(TitanManagement managementSystem, String indexName) {
        TitanGraphIndex vertexIndex = managementSystem.getGraphIndex("vertex_index");
        PropertyKey[] fieldKeys = vertexIndex.getFieldKeys();
        Arrays.asList(fieldKeys).contains(managementSystem.getPropertyKey(indexName));
    }

    private void verifySystemCompositeIndex(TitanManagement managementSystem, String indexName, boolean isUnique) {
        TitanGraphIndex systemIndex = managementSystem.getGraphIndex(indexName);
        org.testng.Assert.assertNotNull((Object)systemIndex);
        Assert.assertTrue((boolean)systemIndex.isCompositeIndex());
        if (isUnique) {
            Assert.assertTrue((boolean)systemIndex.isUnique());
        } else {
            org.testng.Assert.assertFalse((boolean)systemIndex.isUnique());
        }
    }
}

