/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import org.apache.atlas.AtlasException;
import org.apache.atlas.repository.IndexException;
import org.apache.atlas.repository.RepositoryException;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.commons.configuration.Configuration;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GraphBackedSearchIndexerMockTest {
    @Mock
    private Configuration configuration;
    @Mock
    private GraphProvider<TitanGraph> graphProvider;
    @Mock
    private TitanGraph titanGraph;
    @Mock
    private TitanManagement titanManagement;

    @BeforeMethod
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testSearchIndicesAreInitializedOnConstructionWhenHAIsDisabled() throws IndexException, RepositoryException {
        Mockito.when((Object)this.configuration.getBoolean("atlas.server.ha.enabled", false)).thenReturn((Object)false);
        Mockito.when((Object)this.graphProvider.get()).thenReturn((Object)this.titanGraph);
        Mockito.when((Object)this.titanGraph.getManagementSystem()).thenReturn((Object)this.titanManagement);
        Mockito.when((Object)this.titanManagement.containsPropertyKey("__type")).thenReturn((Object)true);
        GraphBackedSearchIndexer graphBackedSearchIndexer = new GraphBackedSearchIndexer(this.graphProvider, this.configuration);
        ((TitanManagement)Mockito.verify((Object)this.titanManagement)).containsPropertyKey("__type");
    }

    @Test
    public void testSearchIndicesAreNotInitializedOnConstructionWhenHAIsEnabled() throws IndexException, RepositoryException {
        Mockito.when((Object)this.configuration.containsKey("atlas.server.ha.enabled")).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getBoolean("atlas.server.ha.enabled")).thenReturn((Object)true);
        Mockito.when((Object)this.graphProvider.get()).thenReturn((Object)this.titanGraph);
        Mockito.when((Object)this.titanGraph.getManagementSystem()).thenReturn((Object)this.titanManagement);
        Mockito.when((Object)this.titanManagement.containsPropertyKey("__type")).thenReturn((Object)true);
        new GraphBackedSearchIndexer(this.graphProvider, this.configuration);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.titanManagement});
    }

    @Test
    public void testIndicesAreReinitializedWhenServerBecomesActive() throws AtlasException {
        Mockito.when((Object)this.configuration.containsKey("atlas.server.ha.enabled")).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getBoolean("atlas.server.ha.enabled")).thenReturn((Object)true);
        Mockito.when((Object)this.graphProvider.get()).thenReturn((Object)this.titanGraph);
        Mockito.when((Object)this.titanGraph.getManagementSystem()).thenReturn((Object)this.titanManagement);
        Mockito.when((Object)this.titanManagement.containsPropertyKey("__type")).thenReturn((Object)true);
        GraphBackedSearchIndexer graphBackedSearchIndexer = new GraphBackedSearchIndexer(this.graphProvider, this.configuration);
        graphBackedSearchIndexer.instanceIsActive();
        ((TitanManagement)Mockito.verify((Object)this.titanManagement)).containsPropertyKey("__type");
    }
}

