/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import com.tinkerpop.blueprints.Vertex;
import java.util.List;
import java.util.Map;
import org.apache.atlas.AtlasException;
import org.apache.atlas.repository.graph.DeleteHandler;
import org.apache.atlas.repository.graph.GraphBackedMetadataRepositoryDeleteTestBase;
import org.apache.atlas.repository.graph.SoftDeleteHandler;
import org.apache.atlas.typesystem.IReferenceableInstance;
import org.apache.atlas.typesystem.IStruct;
import org.apache.atlas.typesystem.ITypedReferenceableInstance;
import org.apache.atlas.typesystem.ITypedStruct;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.testng.Assert;

public class GraphBackedRepositorySoftDeleteTest
extends GraphBackedMetadataRepositoryDeleteTestBase {
    @Override
    DeleteHandler getDeleteHandler(TypeSystem typeSystem) {
        return new SoftDeleteHandler(typeSystem);
    }

    @Override
    protected void assertTestDeleteEntityWithTraits(String guid) throws Exception {
        ITypedReferenceableInstance instance = this.repositoryService.getEntityDefinition(guid);
        Assert.assertTrue((boolean)instance.getTraits().contains((Object)"PII"));
    }

    @Override
    protected void assertTableForTestDeleteReference(String tableId) throws Exception {
        ITypedReferenceableInstance table = this.repositoryService.getEntityDefinition(tableId);
        Assert.assertNotNull((Object)table.get("name"));
        Assert.assertNotNull((Object)table.get("description"));
        Assert.assertNotNull((Object)table.get("type"));
        Assert.assertNotNull((Object)table.get("tableType"));
        Assert.assertNotNull((Object)table.get("created"));
        Id dbId = (Id)table.get("database");
        Assert.assertNotNull((Object)dbId);
        ITypedReferenceableInstance db = this.repositoryService.getEntityDefinition(dbId.getId()._getId());
        Assert.assertNotNull((Object)db);
        Assert.assertEquals((Object)db.getId().getState(), (Object)Id.EntityState.ACTIVE);
    }

    @Override
    protected void assertColumnForTestDeleteReference(ITypedReferenceableInstance tableInstance) throws AtlasException {
        List columns = (List)tableInstance.get("columns");
        Assert.assertEquals((int)columns.size(), (int)1);
        Assert.assertEquals((Object)((ITypedReferenceableInstance)columns.get(0)).getId().getState(), (Object)Id.EntityState.DELETED);
    }

    @Override
    protected void assertProcessForTestDeleteReference(ITypedReferenceableInstance expected) throws Exception {
        ITypedReferenceableInstance process = this.repositoryService.getEntityDefinition(expected.getId()._getId());
        List outputs = (List)process.get("outputs");
        List expectedOutputs = (List)process.get("outputs");
        Assert.assertEquals((int)outputs.size(), (int)expectedOutputs.size());
    }

    @Override
    protected void assertEntityDeleted(String id) throws Exception {
        ITypedReferenceableInstance entity = this.repositoryService.getEntityDefinition(id);
        Assert.assertEquals((Object)entity.getId().getState(), (Object)Id.EntityState.DELETED);
    }

    @Override
    protected void assertDeletedColumn(ITypedReferenceableInstance tableInstance) throws AtlasException {
        List columns = (List)tableInstance.get("columns");
        Assert.assertEquals((int)columns.size(), (int)3);
        Assert.assertEquals((Object)((IReferenceableInstance)columns.get(0)).getId().getState(), (Object)Id.EntityState.DELETED);
    }

    @Override
    protected void assertTestDeleteEntities(ITypedReferenceableInstance expected) throws Exception {
        ITypedReferenceableInstance table = this.repositoryService.getEntityDefinition(expected.getId()._getId());
        List columns = (List)table.get("columns");
        List expectedColumns = (List)table.get("columns");
        Assert.assertEquals((int)columns.size(), (int)expectedColumns.size());
        Assert.assertNotNull((Object)table.get("database"));
    }

    @Override
    protected void assertVerticesDeleted(List<Vertex> vertices) {
        for (Vertex vertex : vertices) {
            Assert.assertEquals((Object)vertex.getProperty("__state"), (Object)Id.EntityState.DELETED.name());
        }
    }

    @Override
    protected void assertTestUpdateEntity_MultiplicityOneNonCompositeReference(String janeGuid) throws Exception {
        ITypedReferenceableInstance jane = this.repositoryService.getEntityDefinition(janeGuid);
        List subordinates = (List)jane.get("subordinates");
        Assert.assertEquals((int)subordinates.size(), (int)2);
    }

    @Override
    protected void assertJohnForTestDisconnectBidirectionalReferences(ITypedReferenceableInstance john, String janeGuid) throws Exception {
        Id mgr = (Id)john.get("manager");
        Assert.assertNotNull((Object)mgr);
        Assert.assertEquals((String)mgr._getId(), (String)janeGuid);
        Assert.assertEquals((Object)mgr.getState(), (Object)Id.EntityState.DELETED);
    }

    @Override
    protected void assertMaxForTestDisconnectBidirectionalReferences(Map<String, String> nameGuidMap) throws Exception {
        ITypedReferenceableInstance hrDept = this.repositoryService.getEntityDefinition(nameGuidMap.get("hr"));
        List employees = (List)hrDept.get("employees");
        Assert.assertEquals((int)employees.size(), (int)4);
        String maxGuid = nameGuidMap.get("Max");
        for (ITypedReferenceableInstance employee : employees) {
            if (!employee.getId()._getId().equals(maxGuid)) continue;
            Assert.assertEquals((Object)employee.getId().getState(), (Object)Id.EntityState.DELETED);
        }
        ITypedReferenceableInstance jane = this.repositoryService.getEntityDefinition(nameGuidMap.get("Jane"));
        List subordinates = (List)jane.get("subordinates");
        Assert.assertEquals((int)subordinates.size(), (int)2);
        for (ITypedReferenceableInstance subordinate : subordinates) {
            if (!subordinate.getId()._getId().equals(maxGuid)) continue;
            Assert.assertEquals((Object)subordinate.getId().getState(), (Object)Id.EntityState.DELETED);
        }
        ITypedReferenceableInstance john = this.repositoryService.getEntityDefinition(nameGuidMap.get("John"));
        Id mentor = (Id)john.get("mentor");
        Assert.assertEquals((String)mentor._getId(), (String)maxGuid);
        Assert.assertEquals((Object)mentor.getState(), (Object)Id.EntityState.DELETED);
    }

    @Override
    protected void assertTestDisconnectUnidirectionalArrayReferenceFromClassType(List<ITypedReferenceableInstance> columns, String columnGuid) {
        Assert.assertEquals((int)columns.size(), (int)5);
        for (ITypedReferenceableInstance column : columns) {
            if (column.getId()._getId().equals(columnGuid)) {
                Assert.assertEquals((Object)column.getId().getState(), (Object)Id.EntityState.DELETED);
                continue;
            }
            Assert.assertEquals((Object)column.getId().getState(), (Object)Id.EntityState.ACTIVE);
        }
    }

    @Override
    protected void assertTestDisconnectUnidirectionalArrayReferenceFromStructAndTraitTypes(String structContainerGuid) throws Exception {
        ITypedReferenceableInstance structContainerConvertedEntity = this.repositoryService.getEntityDefinition(structContainerGuid);
        ITypedStruct struct = (ITypedStruct)structContainerConvertedEntity.get("struct");
        Assert.assertNotNull((Object)struct.get("target"));
        IStruct trait = structContainerConvertedEntity.getTrait("TestTrait");
        Assert.assertNotNull((Object)trait);
        Assert.assertNotNull((Object)trait.get("target"));
    }

    @Override
    protected void assertTestDisconnectMapReferenceFromClassType(String mapOwnerGuid) throws Exception {
        ITypedReferenceableInstance mapOwnerInstance = this.repositoryService.getEntityDefinition(mapOwnerGuid);
        Map map = (Map)mapOwnerInstance.get("map");
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((int)map.size(), (int)1);
        Map biMap = (Map)mapOwnerInstance.get("biMap");
        Assert.assertNotNull((Object)biMap);
        Assert.assertEquals((int)biMap.size(), (int)1);
    }

    @Override
    protected void assertTestDeleteTargetOfMultiplicityRequiredReference() throws Exception {
    }
}

