/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import com.tinkerpop.blueprints.Vertex;
import java.util.List;
import java.util.Map;
import org.apache.atlas.AtlasException;
import org.apache.atlas.repository.graph.DeleteHandler;
import org.apache.atlas.repository.graph.GraphBackedMetadataRepositoryDeleteTestBase;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graph.HardDeleteHandler;
import org.apache.atlas.typesystem.IStruct;
import org.apache.atlas.typesystem.ITypedReferenceableInstance;
import org.apache.atlas.typesystem.ITypedStruct;
import org.apache.atlas.typesystem.exception.EntityNotFoundException;
import org.apache.atlas.typesystem.exception.NullRequiredAttributeException;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.testng.Assert;
import org.testng.AssertJUnit;

public class GraphBackedRepositoryHardDeleteTest
extends GraphBackedMetadataRepositoryDeleteTestBase {
    @Override
    DeleteHandler getDeleteHandler(TypeSystem typeSystem) {
        return new HardDeleteHandler(typeSystem);
    }

    @Override
    protected void assertTestDeleteEntityWithTraits(String guid) {
    }

    @Override
    protected void assertTableForTestDeleteReference(String tableId) {
    }

    @Override
    protected void assertColumnForTestDeleteReference(ITypedReferenceableInstance tableInstance) throws AtlasException {
        List columns = (List)tableInstance.get("columns");
        Assert.assertNull((Object)columns);
    }

    @Override
    protected void assertProcessForTestDeleteReference(ITypedReferenceableInstance processInstance) throws Exception {
        ITypedReferenceableInstance newProcess = this.repositoryService.getEntityDefinition(processInstance.getId()._getId());
        Assert.assertNull((Object)newProcess.get("outputs"));
    }

    @Override
    protected void assertEntityDeleted(String id) throws Exception {
        try {
            this.repositoryService.getEntityDefinition(id);
            Assert.fail((String)"Expected EntityNotFoundException");
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    @Override
    protected void assertDeletedColumn(ITypedReferenceableInstance tableInstance) throws AtlasException {
        Assert.assertEquals((int)((List)tableInstance.get("columns")).size(), (int)2);
    }

    @Override
    protected void assertTestDeleteEntities(ITypedReferenceableInstance tableInstance) {
        int vertexCount = this.getVertices("__typeName", "hive_table").size();
        Assert.assertEquals((int)vertexCount, (int)0);
        vertexCount = this.getVertices("__typeName", "column_type").size();
        Assert.assertEquals((int)vertexCount, (int)0);
    }

    @Override
    protected void assertVerticesDeleted(List<Vertex> vertices) {
        Assert.assertEquals((int)vertices.size(), (int)0);
    }

    @Override
    protected void assertTestUpdateEntity_MultiplicityOneNonCompositeReference(String janeGuid) throws Exception {
        ITypedReferenceableInstance jane = this.repositoryService.getEntityDefinition(janeGuid);
        List subordinates = (List)jane.get("subordinates");
        Assert.assertEquals((int)subordinates.size(), (int)1);
    }

    @Override
    protected void assertJohnForTestDisconnectBidirectionalReferences(ITypedReferenceableInstance john, String janeGuid) throws Exception {
        Assert.assertNull((Object)john.get("manager"));
    }

    @Override
    protected void assertMaxForTestDisconnectBidirectionalReferences(Map<String, String> nameGuidMap) throws Exception {
        ITypedReferenceableInstance hrDept = this.repositoryService.getEntityDefinition(nameGuidMap.get("hr"));
        List employees = (List)hrDept.get("employees");
        Assert.assertEquals((int)employees.size(), (int)3);
        String maxGuid = nameGuidMap.get("Max");
        for (ITypedReferenceableInstance employee : employees) {
            Assert.assertNotEquals((Object)employee.getId()._getId(), (Object)maxGuid);
        }
        ITypedReferenceableInstance jane = this.repositoryService.getEntityDefinition(nameGuidMap.get("Jane"));
        List subordinates = (List)jane.get("subordinates");
        Assert.assertEquals((int)subordinates.size(), (int)1);
        ITypedReferenceableInstance john = this.repositoryService.getEntityDefinition(nameGuidMap.get("John"));
        Assert.assertNull((Object)john.get("mentor"));
    }

    @Override
    protected void assertTestDisconnectUnidirectionalArrayReferenceFromClassType(List<ITypedReferenceableInstance> columns, String columnGuid) {
        Assert.assertEquals((int)columns.size(), (int)4);
        for (ITypedReferenceableInstance column : columns) {
            Assert.assertFalse((boolean)column.getId()._getId().equals(columnGuid));
        }
    }

    @Override
    protected void assertTestDisconnectUnidirectionalArrayReferenceFromStructAndTraitTypes(String structContainerGuid) throws Exception {
        ITypedReferenceableInstance structContainerConvertedEntity = this.repositoryService.getEntityDefinition(structContainerGuid);
        ITypedStruct struct = (ITypedStruct)structContainerConvertedEntity.get("struct");
        Assert.assertNull((Object)struct.get("target"));
        IStruct trait = structContainerConvertedEntity.getTrait("TestTrait");
        AssertJUnit.assertNotNull((Object)trait);
        Assert.assertNull((Object)trait.get("target"));
    }

    @Override
    protected void assertTestDisconnectMapReferenceFromClassType(String mapOwnerGuid) throws Exception {
        ITypedReferenceableInstance mapOwnerInstance = this.repositoryService.getEntityDefinition(mapOwnerGuid);
        Assert.assertNull((Object)mapOwnerInstance.get("map"));
        Assert.assertNull((Object)mapOwnerInstance.get("biMap"));
        Vertex mapOwnerVertex = GraphHelper.getInstance().getVertexForGUID(mapOwnerGuid);
        Object object = mapOwnerVertex.getProperty("MapOwner.map.value1");
        Assert.assertNull((Object)object);
        object = mapOwnerVertex.getProperty("MapOwner.biMap.value1");
        Assert.assertNull((Object)object);
    }

    @Override
    protected void assertTestDeleteTargetOfMultiplicityRequiredReference() throws Exception {
        Assert.fail((String)("Lower bound on attribute Manager.subordinates was not enforced - " + NullRequiredAttributeException.class.getSimpleName() + " was expected but none thrown"));
    }
}

