/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanGraphQuery;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import org.apache.atlas.GraphTransaction;
import org.apache.atlas.RepositoryMetadataModule;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestUtils;
import org.apache.atlas.discovery.graph.GraphBackedDiscoveryService;
import org.apache.atlas.query.QueryParams;
import org.apache.atlas.repository.RepositoryException;
import org.apache.atlas.repository.graph.GraphBackedMetadataRepository;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.atlas.typesystem.IStruct;
import org.apache.atlas.typesystem.ITypedReferenceableInstance;
import org.apache.atlas.typesystem.ITypedStruct;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.Struct;
import org.apache.atlas.typesystem.exception.EntityNotFoundException;
import org.apache.atlas.typesystem.exception.TraitNotFoundException;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.TraitType;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.apache.atlas.typesystem.types.utils.TypesUtil;
import org.apache.commons.lang.RandomStringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;
import scala.actors.threadpool.Arrays;

@Guice(modules={RepositoryMetadataModule.class})
public class GraphBackedMetadataRepositoryTest {
    @Inject
    private GraphProvider<TitanGraph> graphProvider;
    @Inject
    private GraphBackedMetadataRepository repositoryService;
    @Inject
    private GraphBackedDiscoveryService discoveryService;
    private TypeSystem typeSystem;
    private String guid;
    private QueryParams queryParams = new QueryParams(100, 0);

    @BeforeClass
    public void setUp() throws Exception {
        this.typeSystem = TypeSystem.getInstance();
        this.typeSystem.reset();
        new GraphBackedSearchIndexer(this.graphProvider);
        TestUtils.defineDeptEmployeeTypes(this.typeSystem);
        TestUtils.createHiveTypes(this.typeSystem);
    }

    @BeforeMethod
    public void setupContext() {
        RequestContext.createContext();
    }

    @AfterClass
    public void tearDown() throws Exception {
        TypeSystem.getInstance().reset();
        try {
            ((TitanGraph)this.graphProvider.get()).shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TitanCleanup.clear((TitanGraph)((TitanGraph)this.graphProvider.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testConcurrentCalls() throws Exception {
        HierarchicalTypeDefinition refType = TypesUtil.createClassTypeDef((String)this.randomString(), (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition type = TypesUtil.createClassTypeDef((String)this.randomString(), (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{new AttributeDefinition("ref", refType.typeName, Multiplicity.OPTIONAL, true, null)});
        this.typeSystem.defineClassType(refType);
        this.typeSystem.defineClassType(type);
        String refId1 = this.createEntity(new Referenceable(refType.typeName, new String[0])).get(0);
        String refId2 = this.createEntity(new Referenceable(refType.typeName, new String[0])).get(0);
        final Referenceable instance1 = new Referenceable(type.typeName, new String[0]);
        instance1.set("ref", (Object)new Referenceable(refId1, refType.typeName, null));
        final Referenceable instance2 = new Referenceable(type.typeName, new String[0]);
        instance2.set("ref", (Object)new Referenceable(refId2, refType.typeName, null));
        ExecutorService executor = Executors.newFixedThreadPool(3);
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        futures.add(executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return GraphBackedMetadataRepositoryTest.this.createEntity(instance1).get(0);
            }
        }));
        futures.add(executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return GraphBackedMetadataRepositoryTest.this.createEntity(instance2).get(0);
            }
        }));
        futures.add(executor.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return GraphBackedMetadataRepositoryTest.this.discoveryService.searchByDSL("hive_table", new QueryParams(10, 0));
            }
        }));
        String id1 = (String)((Future)futures.get(0)).get();
        String id2 = (String)((Future)futures.get(1)).get();
        ((Future)futures.get(2)).get();
        executor.shutdown();
        boolean validated1 = this.assertEdge(id1, type.typeName);
        boolean validated2 = this.assertEdge(id2, type.typeName);
        Assert.assertTrue((boolean)(validated1 | validated2));
    }

    private boolean assertEdge(String id, String typeName) throws Exception {
        TitanGraph graph = (TitanGraph)this.graphProvider.get();
        Vertex vertex = (Vertex)graph.query().has("__guid", (Object)id).vertices().iterator().next();
        Iterable edges = vertex.getEdges(Direction.OUT, new String[]{"__" + typeName + ".ref"});
        if (!edges.iterator().hasNext()) {
            ITypedReferenceableInstance entity = this.repositoryService.getEntityDefinition(id);
            Assert.assertNotNull((Object)entity.get("ref"));
            return true;
        }
        return false;
    }

    @Test
    public void testSubmitEntity() throws Exception {
        ITypedReferenceableInstance hrDept = TestUtils.createDeptEg1(this.typeSystem);
        List guids = this.repositoryService.createEntities(new ITypedReferenceableInstance[]{hrDept});
        Assert.assertNotNull((Object)guids);
        Assert.assertEquals((int)guids.size(), (int)5);
        this.guid = (String)guids.get(4);
        Assert.assertNotNull((Object)this.guid);
    }

    @Test(dependsOnMethods={"testSubmitEntity"})
    public void testGetEntityDefinitionForDepartment() throws Exception {
        ITypedReferenceableInstance entity = this.repositoryService.getEntityDefinition(this.guid);
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)entity.getId().getState(), (Object)Id.EntityState.ACTIVE);
    }

    @Test(expectedExceptions={EntityNotFoundException.class})
    public void testGetEntityDefinitionNonExistent() throws Exception {
        this.repositoryService.getEntityDefinition("blah");
        Assert.fail();
    }

    @Test(dependsOnMethods={"testSubmitEntity"})
    public void testGetEntityList() throws Exception {
        List entityList = this.repositoryService.getEntityList("Department");
        System.out.println("entityList = " + entityList);
        Assert.assertNotNull((Object)entityList);
        Assert.assertTrue((boolean)entityList.contains(this.guid));
    }

    @Test
    public void testGetTypeAttributeName() throws Exception {
        Assert.assertEquals((String)this.repositoryService.getTypeAttributeName(), (String)"__typeName");
    }

    @Test(dependsOnMethods={"testSubmitEntity"})
    public void testGetTraitLabel() throws Exception {
        Assert.assertEquals((String)this.repositoryService.getTraitLabel((IDataType)this.typeSystem.getDataType(ClassType.class, "hive_table"), "classification"), (String)"classification");
    }

    @Test
    public void testCreateEntity() throws Exception {
        Referenceable databaseInstance = new Referenceable("hive_database", new String[0]);
        databaseInstance.set("name", (Object)"foo");
        databaseInstance.set("description", (Object)"foo database");
        databaseInstance.set("created", (Object)new Date(1418265358440L));
        databaseInstance.set("namespace", (Object)"colo:cluster:hive:db");
        databaseInstance.set("cluster", (Object)"cluster-1");
        databaseInstance.set("colo", (Object)"colo-1");
        System.out.println("databaseInstance = " + databaseInstance);
        ClassType dbType = (ClassType)this.typeSystem.getDataType(ClassType.class, "hive_database");
        ITypedReferenceableInstance db = dbType.convert((Object)databaseInstance, Multiplicity.REQUIRED);
        System.out.println("db = " + db);
        ITypedReferenceableInstance table = this.createHiveTableInstance(databaseInstance);
        List<String> guids = this.createEntities(db, table);
        Assert.assertEquals((int)guids.size(), (int)7);
        System.out.println("added db = " + guids.get(0));
        System.out.println("added table = " + guids.get(6));
    }

    @Test(dependsOnMethods={"testCreateEntity"})
    public void testGetEntityDefinition() throws Exception {
        String guid = this.getGUID();
        ITypedReferenceableInstance table = this.repositoryService.getEntityDefinition(guid);
        Assert.assertEquals((Object)table.getDate("created"), (Object)new Date(1418265358440L));
        System.out.println("*** table = " + table);
    }

    private List<String> createEntities(ITypedReferenceableInstance ... instances) throws Exception {
        RequestContext.createContext();
        return this.repositoryService.createEntities(instances);
    }

    private List<String> createEntity(Referenceable entity) throws Exception {
        ClassType type = (ClassType)this.typeSystem.getDataType(ClassType.class, entity.getTypeName());
        ITypedReferenceableInstance instance = type.convert((Object)entity, Multiplicity.REQUIRED);
        return this.createEntities(instance);
    }

    @GraphTransaction
    String getGUID() {
        Vertex tableVertex = this.getTableEntityVertex();
        String guid = (String)tableVertex.getProperty("__guid");
        if (guid == null) {
            Assert.fail();
        }
        return guid;
    }

    @GraphTransaction
    Vertex getTableEntityVertex() {
        Vertex tableVertex;
        TitanGraph graph = (TitanGraph)this.graphProvider.get();
        TitanGraphQuery query = graph.query().has("__typeName", (Predicate)Compare.EQUAL, (Object)"hive_table");
        Iterator results = query.vertices().iterator();
        Vertex vertex = tableVertex = results.hasNext() ? (Vertex)results.next() : null;
        if (tableVertex == null) {
            Assert.fail();
        }
        return tableVertex;
    }

    @Test(dependsOnMethods={"testCreateEntity"})
    public void testGetTraitNames() throws Exception {
        List traitNames = this.repositoryService.getTraitNames(this.getGUID());
        Assert.assertEquals((int)traitNames.size(), (int)1);
        Assert.assertEquals((Collection)traitNames, (Collection)Arrays.asList((Object[])new String[]{"classification"}));
    }

    @Test
    public void testGetTraitNamesForEmptyTraits() throws Exception {
        List traitNames = this.repositoryService.getTraitNames(this.guid);
        Assert.assertEquals((int)traitNames.size(), (int)0);
    }

    @Test(expectedExceptions={EntityNotFoundException.class})
    public void testGetTraitNamesForBadEntity() throws Exception {
        this.repositoryService.getTraitNames(UUID.randomUUID().toString());
        Assert.fail();
    }

    @Test
    public void testMultipleTypesWithSameUniqueAttribute() throws Exception {
        HierarchicalTypeDefinition supertype = TypesUtil.createClassTypeDef((String)this.randomString(), (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createUniqueRequiredAttrDef((String)"name", (IDataType)DataTypes.STRING_TYPE)});
        HierarchicalTypeDefinition t1 = TypesUtil.createClassTypeDef((String)this.randomString(), (ImmutableSet)ImmutableSet.of((Object)supertype.typeName), (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition t2 = TypesUtil.createClassTypeDef((String)this.randomString(), (ImmutableSet)ImmutableSet.of((Object)supertype.typeName), (AttributeDefinition[])new AttributeDefinition[0]);
        this.typeSystem.defineClassTypes(new HierarchicalTypeDefinition[]{supertype, t1, t2});
        final String name = this.randomString();
        String id1 = this.createEntity(new Referenceable(t1.typeName, new String[0]){
            {
                super(x0, x1);
                this.set("name", name);
            }
        }).get(0);
        String id2 = this.createEntity(new Referenceable(t2.typeName, new String[0]){
            {
                super(x0, x1);
                this.set("name", name);
            }
        }).get(0);
        Assert.assertNotEquals((Object)id1, (Object)id2);
        ITypedReferenceableInstance entity = this.repositoryService.getEntityDefinition(t1.typeName, "name", (Object)name);
        Assert.assertEquals((String)entity.getTypeName(), (String)t1.typeName);
        Assert.assertEquals((String)entity.getId()._getId(), (String)id1);
        entity = this.repositoryService.getEntityDefinition(t2.typeName, "name", (Object)name);
        Assert.assertEquals((String)entity.getTypeName(), (String)t2.typeName);
        Assert.assertEquals((String)entity.getId()._getId(), (String)id2);
    }

    @Test(dependsOnMethods={"testGetTraitNames"})
    public void testAddTrait() throws Exception {
        String aGUID = this.getGUID();
        Vertex vertex = GraphHelper.getInstance().getVertexForGUID(aGUID);
        Long modificationTimestampPreUpdate = (Long)vertex.getProperty("__modificationTimestamp");
        Assert.assertNotNull((Object)modificationTimestampPreUpdate);
        List traitNames = this.repositoryService.getTraitNames(aGUID);
        System.out.println("traitNames = " + traitNames);
        Assert.assertEquals((int)traitNames.size(), (int)1);
        Assert.assertTrue((boolean)traitNames.contains("classification"));
        Assert.assertFalse((boolean)traitNames.contains("PII"));
        TraitType traitType = (TraitType)this.typeSystem.getDataType(TraitType.class, "PII");
        ITypedStruct traitInstance = traitType.createInstance();
        this.repositoryService.addTrait(aGUID, traitInstance);
        traitNames = this.repositoryService.getTraitNames(aGUID);
        Assert.assertEquals((int)traitNames.size(), (int)2);
        Assert.assertTrue((boolean)traitNames.contains("PII"));
        Assert.assertTrue((boolean)traitNames.contains("classification"));
        GraphHelper.getInstance().getVertexForGUID(aGUID);
        Long modificationTimestampPostUpdate = (Long)vertex.getProperty("__modificationTimestamp");
        Assert.assertNotNull((Object)modificationTimestampPostUpdate);
    }

    @Test(dependsOnMethods={"testAddTrait"})
    public void testAddTraitWithAttribute() throws Exception {
        String aGUID = this.getGUID();
        String traitName = "P_I_I";
        HierarchicalTypeDefinition piiTrait = TypesUtil.createTraitTypeDef((String)"P_I_I", (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createRequiredAttrDef((String)"type", (IDataType)DataTypes.STRING_TYPE)});
        TraitType traitType = this.typeSystem.defineTraitType(piiTrait);
        ITypedStruct traitInstance = traitType.createInstance();
        traitInstance.set("type", (Object)"SSN");
        this.repositoryService.addTrait(aGUID, traitInstance);
        TestUtils.dumpGraph((TitanGraph)this.graphProvider.get());
        List traitNames = this.repositoryService.getTraitNames(aGUID);
        Assert.assertEquals((int)traitNames.size(), (int)3);
        Assert.assertTrue((boolean)traitNames.contains("P_I_I"));
        ITypedReferenceableInstance instance = this.repositoryService.getEntityDefinition(aGUID);
        IStruct traitInstanceRef = instance.getTrait("P_I_I");
        String type = (String)traitInstanceRef.get("type");
        Assert.assertEquals((String)type, (String)"SSN");
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testAddTraitWithNullInstance() throws Exception {
        this.repositoryService.addTrait(this.getGUID(), null);
        Assert.fail();
    }

    @Test(dependsOnMethods={"testAddTrait"}, expectedExceptions={RepositoryException.class})
    public void testAddTraitForBadEntity() throws Exception {
        TraitType traitType = (TraitType)this.typeSystem.getDataType(TraitType.class, "PII");
        ITypedStruct traitInstance = traitType.createInstance();
        this.repositoryService.addTrait(UUID.randomUUID().toString(), traitInstance);
        Assert.fail();
    }

    @Test(dependsOnMethods={"testAddTrait"})
    public void testDeleteTrait() throws Exception {
        String aGUID = this.getGUID();
        Vertex vertex = GraphHelper.getInstance().getVertexForGUID(aGUID);
        Long modificationTimestampPreUpdate = (Long)vertex.getProperty("__modificationTimestamp");
        Assert.assertNotNull((Object)modificationTimestampPreUpdate);
        List traitNames = this.repositoryService.getTraitNames(aGUID);
        Assert.assertEquals((int)traitNames.size(), (int)3);
        Assert.assertTrue((boolean)traitNames.contains("PII"));
        Assert.assertTrue((boolean)traitNames.contains("classification"));
        Assert.assertTrue((boolean)traitNames.contains("P_I_I"));
        this.repositoryService.deleteTrait(aGUID, "PII");
        traitNames = this.repositoryService.getTraitNames(aGUID);
        Assert.assertEquals((int)traitNames.size(), (int)2);
        Assert.assertTrue((boolean)traitNames.contains("classification"));
        Assert.assertFalse((boolean)traitNames.contains("PII"));
        GraphHelper.getInstance().getVertexForGUID(aGUID);
        Long modificationTimestampPostUpdate = (Long)vertex.getProperty("__modificationTimestamp");
        Assert.assertNotNull((Object)modificationTimestampPostUpdate);
        Assert.assertTrue((modificationTimestampPostUpdate > modificationTimestampPreUpdate ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={EntityNotFoundException.class})
    public void testDeleteTraitForNonExistentEntity() throws Exception {
        this.repositoryService.deleteTrait(UUID.randomUUID().toString(), "PII");
        Assert.fail();
    }

    @Test(expectedExceptions={TraitNotFoundException.class})
    public void testDeleteTraitForNonExistentTrait() throws Exception {
        String aGUID = this.getGUID();
        this.repositoryService.deleteTrait(aGUID, "PCI");
        Assert.fail();
    }

    @Test(dependsOnMethods={"testCreateEntity"})
    public void testGetIdFromVertex() throws Exception {
        Vertex tableVertex = this.getTableEntityVertex();
        String guid = (String)tableVertex.getProperty("__guid");
        if (guid == null) {
            Assert.fail();
        }
        Id expected = new Id(guid, ((Integer)tableVertex.getProperty("__version")).intValue(), "hive_table");
        Assert.assertEquals((Object)GraphHelper.getIdFromVertex((String)"hive_table", (Vertex)tableVertex), (Object)expected);
    }

    @Test(dependsOnMethods={"testCreateEntity"})
    public void testGetTypeName() throws Exception {
        Vertex tableVertex = this.getTableEntityVertex();
        Assert.assertEquals((String)GraphHelper.getTypeName((Vertex)tableVertex), (String)"hive_table");
    }

    @Test(dependsOnMethods={"testCreateEntity"})
    public void testSearchByDSLQuery() throws Exception {
        String dslQuery = "hive_database as PII";
        System.out.println("Executing dslQuery = " + dslQuery);
        String jsonResults = this.discoveryService.searchByDSL(dslQuery, this.queryParams);
        Assert.assertNotNull((Object)jsonResults);
        JSONObject results = new JSONObject(jsonResults);
        Assert.assertEquals((int)results.length(), (int)3);
        System.out.println("results = " + results);
        Object query = results.get("query");
        Assert.assertNotNull((Object)query);
        JSONObject dataType = results.getJSONObject("dataType");
        Assert.assertNotNull((Object)dataType);
        String typeName = dataType.getString("typeName");
        Assert.assertNotNull((Object)typeName);
        JSONArray rows = results.getJSONArray("rows");
        Assert.assertNotNull((Object)rows);
        Assert.assertTrue((rows.length() > 0 ? 1 : 0) != 0);
        for (int index = 0; index < rows.length(); ++index) {
            JSONObject row = rows.getJSONObject(index);
            String type = row.getString("$typeName$");
            Assert.assertEquals((String)type, (String)"hive_database");
            String name = row.getString("name");
            Assert.assertEquals((String)name, (String)"foo");
        }
    }

    @Test(dependsOnMethods={"testSubmitEntity"})
    public void testSearchByDSLWithInheritance() throws Exception {
        String dslQuery = "Person where name = 'Jane'";
        System.out.println("Executing dslQuery = " + dslQuery);
        String jsonResults = this.discoveryService.searchByDSL(dslQuery, this.queryParams);
        Assert.assertNotNull((Object)jsonResults);
        JSONObject results = new JSONObject(jsonResults);
        Assert.assertEquals((int)results.length(), (int)3);
        System.out.println("results = " + results);
        Object query = results.get("query");
        Assert.assertNotNull((Object)query);
        JSONObject dataType = results.getJSONObject("dataType");
        Assert.assertNotNull((Object)dataType);
        String typeName = dataType.getString("typeName");
        Assert.assertEquals((String)typeName, (String)"Person");
        JSONArray rows = results.getJSONArray("rows");
        Assert.assertEquals((int)rows.length(), (int)1);
        JSONObject row = rows.getJSONObject(0);
        Assert.assertEquals((String)row.getString("$typeName$"), (String)"Manager");
        Assert.assertEquals((String)row.getString("name"), (String)"Jane");
    }

    @Test(dependsOnMethods={"testCreateEntity"})
    public void testBug37860() throws Exception {
        String dslQuery = "hive_table as t where name = 'bar' database where name = 'foo' and description = 'foo database' select t";
        TestUtils.dumpGraph((TitanGraph)this.graphProvider.get());
        System.out.println("Executing dslQuery = " + dslQuery);
        String jsonResults = this.discoveryService.searchByDSL(dslQuery, this.queryParams);
        Assert.assertNotNull((Object)jsonResults);
        JSONObject results = new JSONObject(jsonResults);
        Assert.assertEquals((int)results.length(), (int)3);
        System.out.println("results = " + results);
        Object query = results.get("query");
        Assert.assertNotNull((Object)query);
        JSONObject dataType = results.getJSONObject("dataType");
        Assert.assertNotNull((Object)dataType);
        JSONArray rows = results.getJSONArray("rows");
        Assert.assertEquals((int)rows.length(), (int)1);
    }

    @Test(dependsOnMethods={"testSubmitEntity"})
    public void testFullTextSearch() throws Exception {
        long sleepInterval = 1000L;
        TestUtils.dumpGraph((TitanGraph)this.graphProvider.get());
        Thread.sleep(sleepInterval);
        String response = this.discoveryService.searchByFullText("john", this.queryParams);
        Assert.assertNotNull((Object)response);
        JSONArray results = new JSONArray(response);
        Assert.assertEquals((int)results.length(), (int)1);
        JSONObject row = (JSONObject)results.get(0);
        Assert.assertEquals((Object)row.get("typeName"), (Object)"Person");
        response = this.discoveryService.searchByFullText("Jane AND santa AND clara", this.queryParams);
        Assert.assertNotNull((Object)response);
        results = new JSONArray(response);
        Assert.assertEquals((int)results.length(), (int)1);
        row = (JSONObject)results.get(0);
        Assert.assertEquals((Object)row.get("typeName"), (Object)"Manager");
        response = this.discoveryService.searchByFullText("hr AND (john OR jahn)", this.queryParams);
        Assert.assertNotNull((Object)response);
        results = new JSONArray(response);
        Assert.assertEquals((int)results.length(), (int)1);
        row = (JSONObject)results.get(0);
        Assert.assertEquals((Object)row.get("typeName"), (Object)"Person");
        results = new JSONArray(this.discoveryService.searchByFullText("Department", this.queryParams));
        Assert.assertEquals((int)results.length(), (int)5);
        results = new JSONArray(this.discoveryService.searchByFullText("Department", new QueryParams(2, 0)));
        Assert.assertEquals((int)results.length(), (int)2);
        results = new JSONArray(this.discoveryService.searchByFullText("Department", new QueryParams(5, 2)));
        Assert.assertEquals((int)results.length(), (int)3);
        results = new JSONArray(this.discoveryService.searchByFullText("Department", new QueryParams(2, 6)));
        Assert.assertEquals((int)results.length(), (int)0);
    }

    private ITypedReferenceableInstance createHiveTableInstance(Referenceable databaseInstance) throws Exception {
        Referenceable tableInstance = new Referenceable("hive_table", new String[]{"classification"});
        tableInstance.set("name", (Object)"bar");
        tableInstance.set("description", (Object)"bar table");
        tableInstance.set("type", (Object)"managed");
        tableInstance.set("created", (Object)new Date(1418265358440L));
        tableInstance.set("tableType", (Object)1);
        tableInstance.set("namespace", (Object)"colo:cluster:hive:db:table");
        tableInstance.set("cluster", (Object)"cluster-1");
        tableInstance.set("colo", (Object)"colo-1");
        tableInstance.set("database", (Object)databaseInstance);
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("first_name");
        columnNames.add("last_name");
        tableInstance.set("columnNames", columnNames);
        Struct traitInstance = (Struct)tableInstance.getTrait("classification");
        traitInstance.set("tag", (Object)"foundation_etl");
        Struct serde1Instance = new Struct("serdeType");
        serde1Instance.set("name", (Object)"serde1");
        serde1Instance.set("serde", (Object)"serde1");
        tableInstance.set("serde1", (Object)serde1Instance);
        Struct serde2Instance = new Struct("serdeType");
        serde2Instance.set("name", (Object)"serde2");
        serde2Instance.set("serde", (Object)"serde2");
        tableInstance.set("serde2", (Object)serde2Instance);
        ArrayList<Referenceable> columns = new ArrayList<Referenceable>();
        for (int index = 0; index < 5; ++index) {
            Referenceable columnInstance = new Referenceable("column_type", new String[0]);
            String name = "column_" + index;
            columnInstance.set("name", (Object)name);
            columnInstance.set("type", (Object)"string");
            columns.add(columnInstance);
        }
        tableInstance.set("columns", columns);
        ArrayList<Struct> partitions = new ArrayList<Struct>();
        for (int index = 0; index < 5; ++index) {
            Struct partitionInstance = new Struct("partition_struct_type");
            String name = "partition_" + index;
            partitionInstance.set("name", (Object)name);
            partitions.add(partitionInstance);
        }
        tableInstance.set("partitions", partitions);
        HashMap<String, String> parametersMap = new HashMap<String, String>();
        parametersMap.put("foo", "bar");
        parametersMap.put("bar", "baz");
        parametersMap.put("some", "thing");
        tableInstance.set("parametersMap", parametersMap);
        ClassType tableType = (ClassType)this.typeSystem.getDataType(ClassType.class, "hive_table");
        return tableType.convert((Object)tableInstance, Multiplicity.REQUIRED);
    }

    private String randomUTF() {
        return RandomStringUtils.random((int)10);
    }

    private String randomString() {
        return RandomStringUtils.randomAlphanumeric((int)10);
    }

    @Test
    public void testUTFValues() throws Exception {
        Referenceable hrDept = new Referenceable("Department", new String[0]);
        Referenceable john = new Referenceable("Person", new String[0]);
        john.set("name", (Object)this.randomUTF());
        john.set("department", (Object)hrDept);
        hrDept.set("name", (Object)this.randomUTF());
        hrDept.set("employees", (Object)ImmutableList.of((Object)john));
        ClassType deptType = (ClassType)this.typeSystem.getDataType(ClassType.class, "Department");
        ITypedReferenceableInstance hrDept2 = deptType.convert((Object)hrDept, Multiplicity.REQUIRED);
        List guids = this.repositoryService.createEntities(new ITypedReferenceableInstance[]{hrDept2});
        Assert.assertNotNull((Object)guids);
        Assert.assertEquals((int)guids.size(), (int)2);
        Assert.assertNotNull(guids.get(0));
        Assert.assertNotNull(guids.get(1));
    }
}

