/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.AtlasClient;
import org.apache.atlas.AtlasException;
import org.apache.atlas.RepositoryMetadataModule;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestUtils;
import org.apache.atlas.repository.RepositoryException;
import org.apache.atlas.repository.graph.AtlasEdgeLabel;
import org.apache.atlas.repository.graph.DeleteHandler;
import org.apache.atlas.repository.graph.GraphBackedMetadataRepository;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graph.GraphHelper;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.atlas.typesystem.IReferenceableInstance;
import org.apache.atlas.typesystem.IStruct;
import org.apache.atlas.typesystem.ITypedReferenceableInstance;
import org.apache.atlas.typesystem.ITypedStruct;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.Struct;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.exception.EntityNotFoundException;
import org.apache.atlas.typesystem.exception.NullRequiredAttributeException;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.AttributeInfo;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.StructTypeDefinition;
import org.apache.atlas.typesystem.types.TraitType;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.apache.atlas.typesystem.types.utils.TypesUtil;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={RepositoryMetadataModule.class})
public abstract class GraphBackedMetadataRepositoryDeleteTestBase {
    @Inject
    private GraphProvider<TitanGraph> graphProvider;
    protected GraphBackedMetadataRepository repositoryService;
    private TypeSystem typeSystem;

    @BeforeClass
    public void setUp() throws Exception {
        this.typeSystem = TypeSystem.getInstance();
        this.typeSystem.reset();
        new GraphBackedSearchIndexer(this.graphProvider);
        this.repositoryService = new GraphBackedMetadataRepository(this.graphProvider, this.getDeleteHandler(this.typeSystem));
        TestUtils.defineDeptEmployeeTypes(this.typeSystem);
        TestUtils.createHiveTypes(this.typeSystem);
    }

    abstract DeleteHandler getDeleteHandler(TypeSystem var1);

    @BeforeMethod
    public void setupContext() {
        RequestContext.createContext();
    }

    @AfterClass
    public void tearDown() throws Exception {
        TypeSystem.getInstance().reset();
        try {
            ((TitanGraph)this.graphProvider.get()).shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TitanCleanup.clear((TitanGraph)((TitanGraph)this.graphProvider.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testDeleteAndCreate() throws Exception {
        Referenceable entity = TestUtils.createDBEntity();
        String id = this.createInstance(entity);
        ITypedReferenceableInstance instance = this.repositoryService.getEntityDefinition("hive_database", "name", entity.get("name"));
        Assert.assertEquals((String)instance.getId()._getId(), (String)id);
        List results = this.deleteEntities(id).getDeletedEntities();
        Assert.assertEquals((String)((String)results.get(0)), (String)id);
        this.assertEntityDeleted(id);
        try {
            this.repositoryService.getEntityDefinition("hive_database", "name", entity.get("name"));
            Assert.fail((String)"Expected EntityNotFoundException");
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
        String newId = this.createInstance(entity);
        Assert.assertNotEquals((Object)id, (Object)newId);
        instance = this.repositoryService.getEntityDefinition("hive_database", "name", entity.get("name"));
        Assert.assertEquals((String)instance.getId()._getId(), (String)newId);
    }

    @Test
    public void testDeleteEntityWithTraits() throws Exception {
        Referenceable entity = TestUtils.createDBEntity();
        String id = this.createInstance(entity);
        TraitType dataType = (TraitType)this.typeSystem.getDataType(TraitType.class, "PII");
        ITypedStruct trait = dataType.convert((Object)new Struct("PII"), Multiplicity.REQUIRED);
        this.repositoryService.addTrait(id, trait);
        ITypedReferenceableInstance instance = this.repositoryService.getEntityDefinition(id);
        Assert.assertTrue((boolean)instance.getTraits().contains((Object)"PII"));
        this.deleteEntities(id);
        this.assertEntityDeleted(id);
        this.assertTestDeleteEntityWithTraits(id);
    }

    protected abstract void assertTestDeleteEntityWithTraits(String var1) throws EntityNotFoundException, RepositoryException, Exception;

    @Test
    public void testDeleteReference() throws Exception {
        Referenceable db = TestUtils.createDBEntity();
        String dbId = this.createInstance(db);
        Referenceable column = TestUtils.createColumnEntity();
        String colId = this.createInstance(column);
        Referenceable table = TestUtils.createTableEntity(dbId);
        table.set("columns", Arrays.asList(new Id(colId, 0, "column_type")));
        String tableId = this.createInstance(table);
        AtlasClient.EntityResult entityResult = this.deleteEntities(colId);
        Assert.assertEquals((int)entityResult.getDeletedEntities().size(), (int)1);
        Assert.assertEquals((String)((String)entityResult.getDeletedEntities().get(0)), (String)colId);
        Assert.assertEquals((int)entityResult.getUpdateEntities().size(), (int)1);
        Assert.assertEquals((String)((String)entityResult.getUpdateEntities().get(0)), (String)tableId);
        this.assertEntityDeleted(colId);
        ITypedReferenceableInstance tableInstance = this.repositoryService.getEntityDefinition(tableId);
        this.assertColumnForTestDeleteReference(tableInstance);
        Referenceable process = new Referenceable("hive_process", new String[0]);
        process.set("outputs", Arrays.asList(new Id(tableId, 0, "hive_table")));
        String processId = this.createInstance(process);
        ITypedReferenceableInstance processInstance = this.repositoryService.getEntityDefinition(processId);
        this.deleteEntities(tableId);
        this.assertEntityDeleted(tableId);
        this.assertTableForTestDeleteReference(tableId);
        this.assertProcessForTestDeleteReference(processInstance);
    }

    protected abstract void assertTableForTestDeleteReference(String var1) throws Exception;

    protected abstract void assertColumnForTestDeleteReference(ITypedReferenceableInstance var1) throws AtlasException;

    protected abstract void assertProcessForTestDeleteReference(ITypedReferenceableInstance var1) throws Exception;

    protected abstract void assertEntityDeleted(String var1) throws Exception;

    private AtlasClient.EntityResult deleteEntities(String ... id) throws Exception {
        RequestContext.createContext();
        return this.repositoryService.deleteEntities(Arrays.asList(id));
    }

    private String createInstance(Referenceable entity) throws Exception {
        ClassType dataType = (ClassType)this.typeSystem.getDataType(ClassType.class, entity.getTypeName());
        ITypedReferenceableInstance instance = dataType.convert((Object)entity, Multiplicity.REQUIRED);
        List results = this.repositoryService.createEntities(new ITypedReferenceableInstance[]{instance});
        return (String)results.get(results.size() - 1);
    }

    @Test
    public void testDeleteEntities() throws Exception {
        Referenceable dbEntity = TestUtils.createDBEntity();
        String dbGuid = this.createInstance(dbEntity);
        Referenceable table1Entity = TestUtils.createTableEntity(dbGuid);
        Referenceable col1 = TestUtils.createColumnEntity();
        Referenceable col2 = TestUtils.createColumnEntity();
        Referenceable col3 = TestUtils.createColumnEntity();
        table1Entity.set("columns", (Object)ImmutableList.of((Object)col1, (Object)col2, (Object)col3));
        this.createInstance(table1Entity);
        ITypedReferenceableInstance tableInstance = this.repositoryService.getEntityDefinition("hive_table", "name", table1Entity.get("name"));
        List columns = (List)tableInstance.get("columns");
        String colId = ((IReferenceableInstance)columns.get(0)).getId()._getId();
        String tableId = tableInstance.getId()._getId();
        AtlasClient.EntityResult entityResult = this.deleteEntities(colId);
        Assert.assertEquals((int)entityResult.getDeletedEntities().size(), (int)1);
        Assert.assertEquals((String)((String)entityResult.getDeletedEntities().get(0)), (String)colId);
        Assert.assertEquals((int)entityResult.getUpdateEntities().size(), (int)1);
        Assert.assertEquals((String)((String)entityResult.getUpdateEntities().get(0)), (String)tableId);
        this.assertEntityDeleted(colId);
        tableInstance = this.repositoryService.getEntityDefinition("hive_table", "name", table1Entity.get("name"));
        this.assertDeletedColumn(tableInstance);
        tableInstance.set("columns", (Object)ImmutableList.of((Object)col3));
        entityResult = this.updatePartial(tableInstance);
        colId = ((IReferenceableInstance)columns.get(1)).getId()._getId();
        Assert.assertEquals((int)entityResult.getDeletedEntities().size(), (int)1);
        Assert.assertEquals((String)((String)entityResult.getDeletedEntities().get(0)), (String)colId);
        this.assertEntityDeleted(colId);
        tableInstance = this.repositoryService.getEntityDefinition("hive_table", "name", table1Entity.get("name"));
        List deletedGuids = this.deleteEntities(tableInstance.getId()._getId()).getDeletedEntities();
        Assert.assertEquals((int)deletedGuids.size(), (int)2);
        Assert.assertTrue((boolean)deletedGuids.contains(tableInstance.getId()._getId()));
        Assert.assertTrue((boolean)deletedGuids.contains(((IReferenceableInstance)columns.get(2)).getId()._getId()));
        for (String guid : deletedGuids) {
            this.assertEntityDeleted(guid);
        }
        this.assertTestDeleteEntities(tableInstance);
    }

    protected abstract void assertDeletedColumn(ITypedReferenceableInstance var1) throws AtlasException;

    protected abstract void assertTestDeleteEntities(ITypedReferenceableInstance var1) throws Exception;

    @Test
    public void testDeleteEntitiesWithCompositeArrayReference() throws Exception {
        String hrDeptGuid = this.createHrDeptGraph();
        ITypedReferenceableInstance hrDept = this.repositoryService.getEntityDefinition(hrDeptGuid);
        List employees = (List)hrDept.get("employees");
        Assert.assertEquals((int)employees.size(), (int)4);
        ArrayList<String> employeeGuids = new ArrayList<String>(4);
        for (ITypedReferenceableInstance employee : employees) {
            employeeGuids.add(employee.getId()._getId());
        }
        int vertexCount = this.getVertices("__typeName", "Address").size();
        Assert.assertEquals((int)vertexCount, (int)4);
        vertexCount = this.getVertices("__typeName", "SecurityClearance").size();
        Assert.assertEquals((int)vertexCount, (int)1);
        List deletedEntities = this.deleteEntities(hrDeptGuid).getDeletedEntities();
        Assert.assertTrue((boolean)deletedEntities.contains(hrDeptGuid));
        this.assertEntityDeleted(hrDeptGuid);
        for (String employeeGuid : employeeGuids) {
            Assert.assertTrue((boolean)deletedEntities.contains(employeeGuid));
            this.assertEntityDeleted(employeeGuid);
        }
        this.assertVerticesDeleted(this.getVertices("__typeName", "Address"));
        this.assertVerticesDeleted(this.getVertices("__typeName", "SecurityClearance"));
    }

    protected abstract void assertVerticesDeleted(List<Vertex> var1);

    @Test
    public void testDeleteEntitiesWithCompositeMapReference() throws Exception {
        HierarchicalTypeDefinition mapValueDef = TypesUtil.createClassTypeDef((String)"CompositeMapValue", (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)"attr1", (IDataType)DataTypes.STRING_TYPE)});
        HierarchicalTypeDefinition mapOwnerDef = TypesUtil.createClassTypeDef((String)"CompositeMapOwner", (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{new AttributeDefinition("map", DataTypes.mapTypeName((String)DataTypes.STRING_TYPE.getName(), (String)"CompositeMapValue"), Multiplicity.OPTIONAL, true, null)});
        TypesDef typesDef = TypesUtil.getTypesDef((ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of((Object)mapOwnerDef, (Object)mapValueDef));
        this.typeSystem.defineTypes(typesDef);
        ClassType mapOwnerType = (ClassType)this.typeSystem.getDataType(ClassType.class, "CompositeMapOwner");
        ClassType mapValueType = (ClassType)this.typeSystem.getDataType(ClassType.class, "CompositeMapValue");
        ITypedReferenceableInstance mapOwnerInstance = mapOwnerType.createInstance();
        ITypedReferenceableInstance mapValueInstance = mapValueType.createInstance();
        mapOwnerInstance.set("map", Collections.singletonMap("value1", mapValueInstance));
        List createEntitiesResult = this.repositoryService.createEntities(new ITypedReferenceableInstance[]{mapOwnerInstance, mapValueInstance});
        Assert.assertEquals((int)createEntitiesResult.size(), (int)2);
        List guids = this.repositoryService.getEntityList("CompositeMapOwner");
        Assert.assertEquals((int)guids.size(), (int)1);
        String mapOwnerGuid = (String)guids.get(0);
        mapOwnerInstance = this.repositoryService.getEntityDefinition(mapOwnerGuid);
        Object object = mapOwnerInstance.get("map");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Map));
        Map map = (Map)object;
        Assert.assertEquals((int)map.size(), (int)1);
        mapValueInstance = (ITypedReferenceableInstance)map.get("value1");
        Assert.assertNotNull((Object)mapValueInstance);
        String mapValueGuid = mapValueInstance.getId()._getId();
        String edgeLabel = GraphHelper.getEdgeLabel((IDataType)mapOwnerType, (AttributeInfo)((AttributeInfo)mapOwnerType.fieldMapping.fields.get("map")));
        String mapEntryLabel = edgeLabel + "." + "value1";
        AtlasEdgeLabel atlasEdgeLabel = new AtlasEdgeLabel(mapEntryLabel);
        Vertex mapOwnerVertex = GraphHelper.getInstance().getVertexForGUID(mapOwnerGuid);
        object = mapOwnerVertex.getProperty(atlasEdgeLabel.getQualifiedMapKey());
        Assert.assertNotNull((Object)object);
        List deletedEntities = this.deleteEntities(mapOwnerGuid).getDeletedEntities();
        Assert.assertEquals((int)deletedEntities.size(), (int)2);
        Assert.assertTrue((boolean)deletedEntities.contains(mapOwnerGuid));
        Assert.assertTrue((boolean)deletedEntities.contains(mapValueGuid));
        this.assertEntityDeleted(mapOwnerGuid);
        this.assertEntityDeleted(mapValueGuid);
    }

    private AtlasClient.EntityResult updatePartial(ITypedReferenceableInstance entity) throws RepositoryException {
        RequestContext.createContext();
        return this.repositoryService.updatePartial(entity);
    }

    @Test
    public void testUpdateEntity_MultiplicityOneNonCompositeReference() throws Exception {
        String hrDeptGuid = this.createHrDeptGraph();
        ITypedReferenceableInstance hrDept = this.repositoryService.getEntityDefinition(hrDeptGuid);
        Map<String, String> nameGuidMap = this.getEmployeeNameGuidMap(hrDept);
        ITypedReferenceableInstance john = this.repositoryService.getEntityDefinition(nameGuidMap.get("John"));
        Id johnGuid = john.getId();
        ITypedReferenceableInstance max = this.repositoryService.getEntityDefinition(nameGuidMap.get("Max"));
        String maxGuid = max.getId()._getId();
        Vertex vertex = GraphHelper.getInstance().getVertexForGUID(maxGuid);
        Long creationTimestamp = (Long)vertex.getProperty("__timestamp");
        Assert.assertNotNull((Object)creationTimestamp);
        Long modificationTimestampPreUpdate = (Long)vertex.getProperty("__modificationTimestamp");
        Assert.assertNotNull((Object)modificationTimestampPreUpdate);
        ITypedReferenceableInstance jane = this.repositoryService.getEntityDefinition(nameGuidMap.get("Jane"));
        Id janeGuid = jane.getId();
        ClassType personType = (ClassType)this.typeSystem.getDataType(ClassType.class, "Person");
        ITypedReferenceableInstance maxEntity = personType.createInstance(max.getId(), new String[0]);
        maxEntity.set("mentor", (Object)johnGuid);
        AtlasClient.EntityResult entityResult = this.updatePartial(maxEntity);
        Assert.assertEquals((int)entityResult.getUpdateEntities().size(), (int)1);
        Assert.assertTrue((boolean)entityResult.getUpdateEntities().contains(maxGuid));
        max = this.repositoryService.getEntityDefinition(maxGuid);
        ITypedReferenceableInstance refTarget = (ITypedReferenceableInstance)max.get("mentor");
        Assert.assertEquals((String)refTarget.getId()._getId(), (String)johnGuid._getId());
        vertex = GraphHelper.getInstance().getVertexForGUID(maxGuid);
        Long modificationTimestampPostUpdate = (Long)vertex.getProperty("__modificationTimestamp");
        Assert.assertNotNull((Object)modificationTimestampPostUpdate);
        Assert.assertTrue((creationTimestamp < modificationTimestampPostUpdate ? 1 : 0) != 0);
        maxEntity.set("mentor", (Object)janeGuid);
        entityResult = this.updatePartial(maxEntity);
        Assert.assertEquals((int)entityResult.getUpdateEntities().size(), (int)1);
        Assert.assertTrue((boolean)entityResult.getUpdateEntities().contains(maxGuid));
        max = this.repositoryService.getEntityDefinition(maxGuid);
        refTarget = (ITypedReferenceableInstance)max.get("mentor");
        Assert.assertEquals((String)refTarget.getId()._getId(), (String)janeGuid._getId());
        vertex = GraphHelper.getInstance().getVertexForGUID(maxGuid);
        Long modificationTimestampPost2ndUpdate = (Long)vertex.getProperty("__modificationTimestamp");
        Assert.assertNotNull((Object)modificationTimestampPost2ndUpdate);
        Assert.assertTrue((modificationTimestampPostUpdate < modificationTimestampPost2ndUpdate ? 1 : 0) != 0);
        ITypedReferenceableInstance julius = this.repositoryService.getEntityDefinition(nameGuidMap.get("Julius"));
        Id juliusGuid = julius.getId();
        maxEntity = personType.createInstance(max.getId(), new String[0]);
        maxEntity.set("manager", (Object)juliusGuid);
        entityResult = this.updatePartial(maxEntity);
        Assert.assertEquals((int)entityResult.getUpdateEntities().size(), (int)2);
        Assert.assertTrue((boolean)entityResult.getUpdateEntities().contains(maxGuid));
        Assert.assertTrue((boolean)entityResult.getUpdateEntities().contains(janeGuid._getId()));
        max = this.repositoryService.getEntityDefinition(maxGuid);
        refTarget = (ITypedReferenceableInstance)max.get("manager");
        Assert.assertEquals((String)refTarget.getId()._getId(), (String)juliusGuid._getId());
        this.assertTestUpdateEntity_MultiplicityOneNonCompositeReference(janeGuid._getId());
    }

    protected abstract void assertTestUpdateEntity_MultiplicityOneNonCompositeReference(String var1) throws Exception;

    @Test
    public void testDisconnectBidirectionalReferences() throws Exception {
        String hrDeptGuid = this.createHrDeptGraph();
        ITypedReferenceableInstance hrDept = this.repositoryService.getEntityDefinition(hrDeptGuid);
        Map<String, String> nameGuidMap = this.getEmployeeNameGuidMap(hrDept);
        String maxGuid = nameGuidMap.get("Max");
        String janeGuid = nameGuidMap.get("Jane");
        String johnGuid = nameGuidMap.get("John");
        Assert.assertNotNull((Object)maxGuid);
        Assert.assertNotNull((Object)janeGuid);
        Assert.assertNotNull((Object)johnGuid);
        ITypedReferenceableInstance jane = this.repositoryService.getEntityDefinition(janeGuid);
        Object refValue = jane.get("subordinates");
        Assert.assertTrue((boolean)(refValue instanceof List));
        List subordinates = (List)refValue;
        Assert.assertEquals((int)subordinates.size(), (int)2);
        ArrayList<String> subordinateIds = new ArrayList<String>(2);
        for (Object listValue : subordinates) {
            Assert.assertTrue((boolean)(listValue instanceof ITypedReferenceableInstance));
            ITypedReferenceableInstance employee = (ITypedReferenceableInstance)listValue;
            subordinateIds.add(employee.getId()._getId());
        }
        Assert.assertTrue((boolean)subordinateIds.contains(maxGuid));
        AtlasClient.EntityResult entityResult = this.deleteEntities(maxGuid);
        ITypedReferenceableInstance john = this.repositoryService.getEntityDefinition("Person", "name", (Object)"John");
        Assert.assertEquals((int)entityResult.getDeletedEntities().size(), (int)1);
        Assert.assertTrue((boolean)entityResult.getDeletedEntities().contains(maxGuid));
        Assert.assertEquals((int)entityResult.getUpdateEntities().size(), (int)3);
        Assert.assertTrue((boolean)entityResult.getUpdateEntities().containsAll(Arrays.asList(jane.getId()._getId(), hrDeptGuid, john.getId()._getId())));
        this.assertEntityDeleted(maxGuid);
        this.assertMaxForTestDisconnectBidirectionalReferences(nameGuidMap);
        entityResult = this.deleteEntities(janeGuid);
        Assert.assertEquals((int)entityResult.getDeletedEntities().size(), (int)1);
        Assert.assertTrue((boolean)entityResult.getDeletedEntities().contains(janeGuid));
        Assert.assertEquals((int)entityResult.getUpdateEntities().size(), (int)2);
        Assert.assertTrue((boolean)entityResult.getUpdateEntities().containsAll(Arrays.asList(hrDeptGuid, john.getId()._getId())));
        this.assertEntityDeleted(janeGuid);
        john = this.repositoryService.getEntityDefinition("Person", "name", (Object)"John");
        this.assertJohnForTestDisconnectBidirectionalReferences(john, janeGuid);
    }

    protected abstract void assertJohnForTestDisconnectBidirectionalReferences(ITypedReferenceableInstance var1, String var2) throws Exception;

    protected abstract void assertMaxForTestDisconnectBidirectionalReferences(Map<String, String> var1) throws Exception;

    @Test
    public void testDisconnectUnidirectionalArrayReferenceFromClassType() throws Exception {
        this.createDbTableGraph("foo", "bar");
        ITypedReferenceableInstance table = this.repositoryService.getEntityDefinition("hive_table", "name", (Object)"bar");
        String tableGuid = table.getId()._getId();
        List columns = (List)table.get("columns");
        Assert.assertEquals((int)columns.size(), (int)5);
        String columnGuid = ((ITypedReferenceableInstance)columns.get(0)).getId()._getId();
        AtlasClient.EntityResult entityResult = this.deleteEntities(columnGuid);
        Assert.assertEquals((int)entityResult.getDeletedEntities().size(), (int)1);
        Assert.assertTrue((boolean)entityResult.getDeletedEntities().contains(columnGuid));
        Assert.assertEquals((int)entityResult.getUpdateEntities().size(), (int)1);
        Assert.assertTrue((boolean)entityResult.getUpdateEntities().contains(tableGuid));
        this.assertEntityDeleted(columnGuid);
        table = this.repositoryService.getEntityDefinition(tableGuid);
        this.assertTestDisconnectUnidirectionalArrayReferenceFromClassType((List)table.get("columns"), columnGuid);
    }

    protected abstract void assertTestDisconnectUnidirectionalArrayReferenceFromClassType(List<ITypedReferenceableInstance> var1, String var2);

    @Test
    public void testDisconnectUnidirectionalArrayReferenceFromStructAndTraitTypes() throws Exception {
        HierarchicalTypeDefinition structTargetDef = TypesUtil.createClassTypeDef((String)"StructTarget", (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)"attr1", (IDataType)DataTypes.STRING_TYPE)});
        HierarchicalTypeDefinition traitTargetDef = TypesUtil.createClassTypeDef((String)"TraitTarget", (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)"attr1", (IDataType)DataTypes.STRING_TYPE)});
        HierarchicalTypeDefinition structContainerDef = TypesUtil.createClassTypeDef((String)"StructContainer", (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)"struct", (String)"TestStruct")});
        StructTypeDefinition structDef = TypesUtil.createStructTypeDef((String)"TestStruct", (AttributeDefinition[])new AttributeDefinition[]{new AttributeDefinition("target", DataTypes.arrayTypeName((String)"StructTarget"), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("nestedStructs", DataTypes.arrayTypeName((String)"NestedStruct"), Multiplicity.OPTIONAL, false, null)});
        StructTypeDefinition nestedStructDef = TypesUtil.createStructTypeDef((String)"NestedStruct", (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)"attr1", (IDataType)DataTypes.STRING_TYPE)});
        HierarchicalTypeDefinition traitDef = TypesUtil.createTraitTypeDef((String)"TestTrait", (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{new AttributeDefinition("target", DataTypes.arrayTypeName((String)"TraitTarget"), Multiplicity.OPTIONAL, false, null)});
        TypesDef typesDef = TypesUtil.getTypesDef((ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of((Object)structDef, (Object)nestedStructDef), (ImmutableList)ImmutableList.of((Object)traitDef), (ImmutableList)ImmutableList.of((Object)structTargetDef, (Object)traitTargetDef, (Object)structContainerDef));
        this.typeSystem.defineTypes(typesDef);
        Referenceable structTargetEntity = new Referenceable("StructTarget", new String[0]);
        Referenceable traitTargetEntity = new Referenceable("TraitTarget", new String[0]);
        Referenceable structContainerEntity = new Referenceable("StructContainer", new String[0]);
        Struct structInstance = new Struct("TestStruct");
        Struct nestedStructInstance = new Struct("NestedStruct");
        Referenceable traitInstance = new Referenceable("TestTrait", new String[0]);
        structContainerEntity.set("struct", (Object)structInstance);
        structInstance.set("target", (Object)ImmutableList.of((Object)structTargetEntity));
        structInstance.set("nestedStructs", (Object)ImmutableList.of((Object)nestedStructInstance));
        ClassType structTargetType = (ClassType)this.typeSystem.getDataType(ClassType.class, "StructTarget");
        ClassType traitTargetType = (ClassType)this.typeSystem.getDataType(ClassType.class, "TraitTarget");
        ClassType structContainerType = (ClassType)this.typeSystem.getDataType(ClassType.class, "StructContainer");
        ITypedReferenceableInstance structTargetConvertedEntity = structTargetType.convert((Object)structTargetEntity, Multiplicity.REQUIRED);
        ITypedReferenceableInstance traitTargetConvertedEntity = traitTargetType.convert((Object)traitTargetEntity, Multiplicity.REQUIRED);
        ITypedReferenceableInstance structContainerConvertedEntity = structContainerType.convert((Object)structContainerEntity, Multiplicity.REQUIRED);
        List guids = this.repositoryService.createEntities(new ITypedReferenceableInstance[]{structTargetConvertedEntity, traitTargetConvertedEntity, structContainerConvertedEntity});
        Assert.assertEquals((int)guids.size(), (int)3);
        guids = this.repositoryService.getEntityList("StructTarget");
        Assert.assertEquals((int)guids.size(), (int)1);
        String structTargetGuid = (String)guids.get(0);
        guids = this.repositoryService.getEntityList("TraitTarget");
        Assert.assertEquals((int)guids.size(), (int)1);
        String traitTargetGuid = (String)guids.get(0);
        guids = this.repositoryService.getEntityList("StructContainer");
        Assert.assertEquals((int)guids.size(), (int)1);
        String structContainerGuid = (String)guids.get(0);
        traitInstance.set("target", (Object)ImmutableList.of((Object)new Id(traitTargetGuid, 0, "TraitTarget")));
        TraitType traitType = (TraitType)this.typeSystem.getDataType(TraitType.class, "TestTrait");
        ITypedStruct convertedTrait = traitType.convert((Object)traitInstance, Multiplicity.REQUIRED);
        this.repositoryService.addTrait(structContainerGuid, convertedTrait);
        structContainerConvertedEntity = this.repositoryService.getEntityDefinition(structContainerGuid);
        Object object = structContainerConvertedEntity.get("struct");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof ITypedStruct));
        ITypedStruct struct = (ITypedStruct)object;
        object = struct.get("target");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof List));
        List refList = (List)object;
        Assert.assertEquals((int)refList.size(), (int)1);
        Assert.assertEquals((String)((ITypedReferenceableInstance)refList.get(0)).getId()._getId(), (String)structTargetGuid);
        IStruct trait = structContainerConvertedEntity.getTrait("TestTrait");
        Assert.assertNotNull((Object)trait);
        object = trait.get("target");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof List));
        refList = (List)object;
        Assert.assertEquals((int)refList.size(), (int)1);
        Assert.assertEquals((String)((ITypedReferenceableInstance)refList.get(0)).getId()._getId(), (String)traitTargetGuid);
        AtlasClient.EntityResult entityResult = this.deleteEntities(structTargetGuid, traitTargetGuid);
        Assert.assertEquals((int)entityResult.getDeletedEntities().size(), (int)2);
        Assert.assertTrue((boolean)entityResult.getDeletedEntities().containsAll(Arrays.asList(structTargetGuid, traitTargetGuid)));
        this.assertEntityDeleted(structTargetGuid);
        this.assertEntityDeleted(traitTargetGuid);
        this.assertTestDisconnectUnidirectionalArrayReferenceFromStructAndTraitTypes(structContainerGuid);
        entityResult = this.deleteEntities(structContainerGuid);
        Assert.assertEquals((int)entityResult.getDeletedEntities().size(), (int)1);
        Assert.assertTrue((boolean)entityResult.getDeletedEntities().contains(structContainerGuid));
        this.assertEntityDeleted(structContainerGuid);
        this.assertVerticesDeleted(this.getVertices("__typeName", "TestStruct"));
        this.assertVerticesDeleted(this.getVertices("__typeName", "NestedStruct"));
        this.assertVerticesDeleted(this.getVertices("__typeName", "TestTrait"));
    }

    protected abstract void assertTestDisconnectUnidirectionalArrayReferenceFromStructAndTraitTypes(String var1) throws Exception;

    @Test
    public void testDisconnectMapReferenceFromClassType() throws Exception {
        HierarchicalTypeDefinition mapValueDef = TypesUtil.createClassTypeDef((String)"MapValue", (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{new AttributeDefinition("biMapOwner", "MapOwner", Multiplicity.OPTIONAL, false, "biMap")});
        HierarchicalTypeDefinition mapOwnerDef = TypesUtil.createClassTypeDef((String)"MapOwner", (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{new AttributeDefinition("map", DataTypes.mapTypeName((String)DataTypes.STRING_TYPE.getName(), (String)"MapValue"), Multiplicity.OPTIONAL, false, null), new AttributeDefinition("biMap", DataTypes.mapTypeName((String)DataTypes.STRING_TYPE.getName(), (String)"MapValue"), Multiplicity.OPTIONAL, false, "biMapOwner")});
        TypesDef typesDef = TypesUtil.getTypesDef((ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of((Object)mapOwnerDef, (Object)mapValueDef));
        this.typeSystem.defineTypes(typesDef);
        ClassType mapOwnerType = (ClassType)this.typeSystem.getDataType(ClassType.class, "MapOwner");
        ClassType mapValueType = (ClassType)this.typeSystem.getDataType(ClassType.class, "MapValue");
        ITypedReferenceableInstance mapOwnerInstance = mapOwnerType.createInstance();
        ITypedReferenceableInstance mapValueInstance = mapValueType.createInstance();
        mapOwnerInstance.set("map", Collections.singletonMap("value1", mapValueInstance));
        mapOwnerInstance.set("biMap", Collections.singletonMap("value1", mapValueInstance));
        mapValueInstance.set("biMapOwner", (Object)mapOwnerInstance);
        List createEntitiesResult = this.repositoryService.createEntities(new ITypedReferenceableInstance[]{mapOwnerInstance, mapValueInstance});
        Assert.assertEquals((int)createEntitiesResult.size(), (int)2);
        List guids = this.repositoryService.getEntityList("MapOwner");
        Assert.assertEquals((int)guids.size(), (int)1);
        String mapOwnerGuid = (String)guids.get(0);
        String edgeLabel = GraphHelper.getEdgeLabel((IDataType)mapOwnerType, (AttributeInfo)((AttributeInfo)mapOwnerType.fieldMapping.fields.get("map")));
        String mapEntryLabel = edgeLabel + "." + "value1";
        AtlasEdgeLabel atlasEdgeLabel = new AtlasEdgeLabel(mapEntryLabel);
        String mapValueGuid = null;
        Vertex mapOwnerVertex = null;
        mapOwnerInstance = this.repositoryService.getEntityDefinition(mapOwnerGuid);
        for (String mapAttrName : Arrays.asList("map", "biMap")) {
            Object object = mapOwnerInstance.get(mapAttrName);
            Assert.assertNotNull((Object)object);
            Assert.assertTrue((boolean)(object instanceof Map));
            Map map = (Map)object;
            Assert.assertEquals((int)map.size(), (int)1);
            mapValueInstance = (ITypedReferenceableInstance)map.get("value1");
            Assert.assertNotNull((Object)mapValueInstance);
            mapValueGuid = mapValueInstance.getId()._getId();
            mapOwnerVertex = GraphHelper.getInstance().getVertexForGUID(mapOwnerGuid);
            object = mapOwnerVertex.getProperty(atlasEdgeLabel.getQualifiedMapKey());
            Assert.assertNotNull((Object)object);
        }
        this.deleteEntities(mapValueGuid);
        this.assertEntityDeleted(mapValueGuid);
        this.assertTestDisconnectMapReferenceFromClassType(mapOwnerGuid);
    }

    protected abstract void assertTestDisconnectMapReferenceFromClassType(String var1) throws Exception;

    @Test
    public void testDeleteTargetOfMultiplicityOneRequiredReference() throws Exception {
        this.createDbTableGraph("db1", "table1");
        ITypedReferenceableInstance db = this.repositoryService.getEntityDefinition("hive_database", "name", (Object)"db1");
        try {
            this.deleteEntities(db.getId()._getId());
            Assert.fail((String)("Lower bound on attribute hive_table.database was not enforced - " + NullRequiredAttributeException.class.getSimpleName() + " was expected but none thrown"));
        }
        catch (Exception e) {
            this.verifyExceptionThrown(e, NullRequiredAttributeException.class);
        }
        ITypedReferenceableInstance table1 = this.repositoryService.getEntityDefinition("hive_table", "name", (Object)"table1");
        Assert.assertNotNull((Object)table1);
        this.deleteEntities(table1.getId()._getId());
        this.deleteEntities(db.getId()._getId());
    }

    @Test
    public void testDeleteTargetOfMultiplicityManyRequiredReference() throws Exception {
        String deptGuid = this.createHrDeptGraph();
        ITypedReferenceableInstance hrDept = this.repositoryService.getEntityDefinition(deptGuid);
        Map<String, String> nameGuidMap = this.getEmployeeNameGuidMap(hrDept);
        this.deleteEntities(nameGuidMap.get("John"));
        try {
            this.deleteEntities(nameGuidMap.get("Max"));
            this.assertTestDeleteTargetOfMultiplicityRequiredReference();
        }
        catch (Exception e) {
            this.verifyExceptionThrown(e, NullRequiredAttributeException.class);
        }
    }

    protected abstract void assertTestDeleteTargetOfMultiplicityRequiredReference() throws Exception;

    @Test
    public void testDeleteTargetOfRequiredMapReference() throws Exception {
        HierarchicalTypeDefinition mapValueDef = TypesUtil.createClassTypeDef((String)"RequiredMapValue", (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition mapOwnerDef = TypesUtil.createClassTypeDef((String)"RequiredMapOwner", (ImmutableSet)ImmutableSet.of(), (AttributeDefinition[])new AttributeDefinition[]{new AttributeDefinition("map", DataTypes.mapTypeName((String)DataTypes.STRING_TYPE.getName(), (String)"RequiredMapValue"), Multiplicity.REQUIRED, false, null)});
        TypesDef typesDef = TypesUtil.getTypesDef((ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of((Object)mapOwnerDef, (Object)mapValueDef));
        this.typeSystem.defineTypes(typesDef);
        ClassType mapOwnerType = (ClassType)this.typeSystem.getDataType(ClassType.class, "RequiredMapOwner");
        ClassType mapValueType = (ClassType)this.typeSystem.getDataType(ClassType.class, "RequiredMapValue");
        ITypedReferenceableInstance mapOwnerInstance = mapOwnerType.createInstance();
        ITypedReferenceableInstance mapValueInstance = mapValueType.createInstance();
        mapOwnerInstance.set("map", Collections.singletonMap("value1", mapValueInstance));
        List createEntitiesResult = this.repositoryService.createEntities(new ITypedReferenceableInstance[]{mapOwnerInstance, mapValueInstance});
        Assert.assertEquals((int)createEntitiesResult.size(), (int)2);
        List guids = this.repositoryService.getEntityList("RequiredMapOwner");
        Assert.assertEquals((int)guids.size(), (int)1);
        String mapOwnerGuid = (String)guids.get(0);
        guids = this.repositoryService.getEntityList("RequiredMapValue");
        Assert.assertEquals((int)guids.size(), (int)1);
        String mapValueGuid = (String)guids.get(0);
        mapOwnerInstance = this.repositoryService.getEntityDefinition(mapOwnerGuid);
        Object object = mapOwnerInstance.get("map");
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Map));
        Map map = (Map)object;
        Assert.assertEquals((int)map.size(), (int)1);
        mapValueInstance = (ITypedReferenceableInstance)map.get("value1");
        Assert.assertNotNull((Object)mapValueInstance);
        Assert.assertEquals((String)mapValueInstance.getId()._getId(), (String)mapValueGuid);
        String edgeLabel = GraphHelper.getEdgeLabel((IDataType)mapOwnerType, (AttributeInfo)((AttributeInfo)mapOwnerType.fieldMapping.fields.get("map")));
        String mapEntryLabel = edgeLabel + "." + "value1";
        AtlasEdgeLabel atlasEdgeLabel = new AtlasEdgeLabel(mapEntryLabel);
        Vertex mapOwnerVertex = GraphHelper.getInstance().getVertexForGUID(mapOwnerGuid);
        object = mapOwnerVertex.getProperty(atlasEdgeLabel.getQualifiedMapKey());
        Assert.assertNotNull((Object)object);
        try {
            this.deleteEntities(mapValueGuid);
            Assert.fail((String)(NullRequiredAttributeException.class.getSimpleName() + " was expected but none thrown."));
        }
        catch (Exception e) {
            this.verifyExceptionThrown(e, NullRequiredAttributeException.class);
        }
    }

    private String createHrDeptGraph() throws Exception {
        ITypedReferenceableInstance hrDept = TestUtils.createDeptEg1(this.typeSystem);
        List guids = this.repositoryService.createEntities(new ITypedReferenceableInstance[]{hrDept});
        Assert.assertNotNull((Object)guids);
        Assert.assertEquals((int)guids.size(), (int)5);
        String hrDeptGuid = null;
        for (String guid : guids) {
            ITypedReferenceableInstance entityDefinition = this.repositoryService.getEntityDefinition(guid);
            Id id = entityDefinition.getId();
            if (!id.getTypeName().equals("Department")) continue;
            hrDeptGuid = id._getId();
            break;
        }
        if (hrDeptGuid == null) {
            Assert.fail((String)"Entity for type Department not found");
        }
        return hrDeptGuid;
    }

    private void createDbTableGraph(String dbName, String tableName) throws Exception {
        Referenceable databaseInstance = new Referenceable("hive_database", new String[0]);
        databaseInstance.set("name", (Object)dbName);
        databaseInstance.set("description", (Object)"foo database");
        ClassType dbType = (ClassType)this.typeSystem.getDataType(ClassType.class, "hive_database");
        ITypedReferenceableInstance db = dbType.convert((Object)databaseInstance, Multiplicity.REQUIRED);
        Referenceable tableInstance = new Referenceable("hive_table", new String[]{"classification"});
        tableInstance.set("name", (Object)tableName);
        tableInstance.set("description", (Object)"bar table");
        tableInstance.set("type", (Object)"managed");
        Struct traitInstance = (Struct)tableInstance.getTrait("classification");
        traitInstance.set("tag", (Object)"foundation_etl");
        tableInstance.set("tableType", (Object)1);
        tableInstance.set("database", (Object)databaseInstance);
        ArrayList<Referenceable> columns = new ArrayList<Referenceable>();
        for (int index = 0; index < 5; ++index) {
            Referenceable columnInstance = new Referenceable("column_type", new String[0]);
            String name = "column_" + index;
            columnInstance.set("name", (Object)name);
            columnInstance.set("type", (Object)"string");
            columns.add(columnInstance);
        }
        tableInstance.set("columns", columns);
        ClassType tableType = (ClassType)this.typeSystem.getDataType(ClassType.class, "hive_table");
        ITypedReferenceableInstance table = tableType.convert((Object)tableInstance, Multiplicity.REQUIRED);
        this.repositoryService.createEntities(new ITypedReferenceableInstance[]{db, table});
    }

    protected List<Vertex> getVertices(String propertyName, Object value) {
        Iterable vertices = ((TitanGraph)this.graphProvider.get()).getVertices(propertyName, value);
        ArrayList<Vertex> list = new ArrayList<Vertex>();
        for (Vertex vertex : vertices) {
            list.add(vertex);
        }
        return list;
    }

    private Map<String, String> getEmployeeNameGuidMap(final ITypedReferenceableInstance hrDept) throws AtlasException {
        Object refValue = hrDept.get("employees");
        Assert.assertTrue((boolean)(refValue instanceof List));
        List employees = (List)refValue;
        Assert.assertEquals((int)employees.size(), (int)4);
        HashMap<String, String> nameGuidMap = new HashMap<String, String>(){
            {
                this.put("hr", hrDept.getId()._getId());
            }
        };
        for (Object listValue : employees) {
            Assert.assertTrue((boolean)(listValue instanceof ITypedReferenceableInstance));
            ITypedReferenceableInstance employee = (ITypedReferenceableInstance)listValue;
            nameGuidMap.put((String)employee.get("name"), employee.getId()._getId());
        }
        return nameGuidMap;
    }

    private void verifyExceptionThrown(Exception thrown, Class expected) {
        boolean exceptionFound = false;
        for (Throwable cause = thrown; cause != null; cause = cause.getCause()) {
            if (!expected.isInstance(cause)) continue;
            exceptionFound = true;
            break;
        }
        if (!exceptionFound) {
            Assert.fail((String)(expected.getSimpleName() + " was expected but not thrown"), (Throwable)thrown);
        }
    }
}

