/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import java.io.IOException;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.repository.audit.HBaseBasedAuditRepository;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.client.Connection;

public class HBaseTestUtils {
    private static HBaseTestingUtility hbaseTestUtility;
    private static LocalHBaseCluster hbaseCluster;

    public static void startCluster() throws Exception {
        org.apache.hadoop.conf.Configuration hbaseConf = HBaseBasedAuditRepository.getHBaseConfiguration((Configuration)ApplicationProperties.get());
        hbaseTestUtility = HBaseTestingUtility.createLocalHTU((org.apache.hadoop.conf.Configuration)hbaseConf);
        int zkPort = hbaseConf.getInt("hbase.zookeeper.property.clientPort", 19026);
        hbaseTestUtility.startMiniZKCluster(1, new int[]{zkPort});
        hbaseCluster = new LocalHBaseCluster(hbaseTestUtility.getConfiguration());
        hbaseCluster.startup();
    }

    public static void stopCluster() throws Exception {
        hbaseTestUtility.getConnection().close();
        hbaseCluster.shutdown();
        hbaseTestUtility.shutdownMiniZKCluster();
    }

    public static Connection getConnection() throws IOException {
        return hbaseTestUtility.getConnection();
    }
}

