/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.repository.audit.AuditRepositoryTestBase;
import org.apache.atlas.repository.audit.HBaseBasedAuditRepository;
import org.apache.atlas.repository.audit.HBaseTestUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class HBaseBasedAuditRepositoryTest
extends AuditRepositoryTestBase {
    private TableName tableName;

    @BeforeClass
    public void setup() throws Exception {
        this.eventRepository = new HBaseBasedAuditRepository();
        HBaseTestUtils.startCluster();
        ((HBaseBasedAuditRepository)this.eventRepository).start();
        Configuration properties = ApplicationProperties.get();
        String tableNameStr = properties.getString("atlas.audit.hbase.tablename", "ATLAS_ENTITY_AUDIT_EVENTS");
        this.tableName = TableName.valueOf((String)tableNameStr);
    }

    @AfterClass
    public void teardown() throws Exception {
        ((HBaseBasedAuditRepository)this.eventRepository).stop();
        HBaseTestUtils.stopCluster();
    }

    @Test
    public void testTableCreated() throws Exception {
        Connection connection = HBaseTestUtils.getConnection();
        Admin admin = connection.getAdmin();
        Assert.assertTrue((boolean)admin.tableExists(this.tableName));
    }

    @Override
    protected void assertEventEquals(EntityAuditEvent actual, EntityAuditEvent expected) {
        super.assertEventEquals(actual, expected);
        Assert.assertNull((Object)actual.getEntityDefinition());
    }
}

