/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import java.io.IOException;
import org.apache.atlas.AtlasException;
import org.apache.atlas.repository.audit.HBaseBasedAuditRepository;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HBaseBasedAuditRepositoryHATest {
    @Mock
    private Configuration configuration;
    @Mock
    private org.apache.hadoop.conf.Configuration hbaseConf;
    @Mock
    private Connection connection;

    @BeforeMethod
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void testTableShouldNotBeCreatedOnStartIfHAIsEnabled() throws IOException, AtlasException {
        Mockito.when((Object)this.configuration.containsKey("atlas.server.ha.enabled")).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getBoolean("atlas.server.ha.enabled")).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getString("atlas.audit.hbase.tablename", "ATLAS_ENTITY_AUDIT_EVENTS")).thenReturn((Object)"ATLAS_ENTITY_AUDIT_EVENTS");
        HBaseBasedAuditRepository auditRepository = new HBaseBasedAuditRepository(){

            protected Connection createConnection(org.apache.hadoop.conf.Configuration hbaseConf) {
                return HBaseBasedAuditRepositoryHATest.this.connection;
            }
        };
        auditRepository.startInternal(this.configuration, this.hbaseConf);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.connection});
    }

    @Test
    public void testShouldCreateTableWhenReactingToActive() throws AtlasException, IOException {
        Mockito.when((Object)this.configuration.containsKey("atlas.server.ha.enabled")).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getBoolean("atlas.server.ha.enabled")).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getString("atlas.audit.hbase.tablename", "ATLAS_ENTITY_AUDIT_EVENTS")).thenReturn((Object)"ATLAS_ENTITY_AUDIT_EVENTS");
        TableName tableName = TableName.valueOf((String)"ATLAS_ENTITY_AUDIT_EVENTS");
        Admin admin = (Admin)Mockito.mock(Admin.class);
        Mockito.when((Object)this.connection.getAdmin()).thenReturn((Object)admin);
        Mockito.when((Object)admin.tableExists(tableName)).thenReturn((Object)true);
        HBaseBasedAuditRepository auditRepository = new HBaseBasedAuditRepository(){

            protected Connection createConnection(org.apache.hadoop.conf.Configuration hbaseConf) {
                return HBaseBasedAuditRepositoryHATest.this.connection;
            }
        };
        auditRepository.startInternal(this.configuration, this.hbaseConf);
        auditRepository.instanceIsActive();
        ((Connection)Mockito.verify((Object)this.connection)).getAdmin();
        ((Admin)Mockito.verify((Object)admin)).tableExists(tableName);
    }
}

