/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.audit;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.EntityAuditEvent;
import org.apache.atlas.repository.audit.EntityAuditRepository;
import org.apache.atlas.typesystem.IReferenceableInstance;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.commons.lang.RandomStringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuditRepositoryTestBase {
    protected EntityAuditRepository eventRepository;

    private String rand() {
        return RandomStringUtils.randomAlphanumeric((int)10);
    }

    @Test
    public void testAddEvents() throws Exception {
        EntityAuditEvent event = new EntityAuditEvent(this.rand(), Long.valueOf(System.currentTimeMillis()), "u1", EntityAuditEvent.EntityAuditAction.ENTITY_CREATE, "d1", (IReferenceableInstance)new Referenceable(this.rand(), new String[0]));
        this.eventRepository.putEvents(new EntityAuditEvent[]{event});
        List events = this.eventRepository.listEvents(event.getEntityId(), null, (short)10);
        Assert.assertEquals((int)events.size(), (int)1);
        this.assertEventEquals((EntityAuditEvent)events.get(0), event);
    }

    @Test
    public void testListPagination() throws Exception {
        String id1 = "id1" + this.rand();
        String id2 = "id2" + this.rand();
        String id3 = "id3" + this.rand();
        long ts = System.currentTimeMillis();
        Referenceable entity = new Referenceable(this.rand(), new String[0]);
        ArrayList<EntityAuditEvent> expectedEvents = new ArrayList<EntityAuditEvent>(3);
        for (int i = 0; i < 3; ++i) {
            EntityAuditEvent event = new EntityAuditEvent(id2, Long.valueOf(ts - (long)i), "user" + i, EntityAuditEvent.EntityAuditAction.ENTITY_UPDATE, "details" + i, (IReferenceableInstance)entity);
            this.eventRepository.putEvents(new EntityAuditEvent[]{event});
            expectedEvents.add(event);
            this.eventRepository.putEvents(new EntityAuditEvent[]{new EntityAuditEvent(id1, Long.valueOf(ts - (long)i), "user" + i, EntityAuditEvent.EntityAuditAction.TAG_DELETE, "details" + i, (IReferenceableInstance)entity)});
            this.eventRepository.putEvents(new EntityAuditEvent[]{new EntityAuditEvent(id3, Long.valueOf(ts - (long)i), "user" + i, EntityAuditEvent.EntityAuditAction.TAG_ADD, "details" + i, (IReferenceableInstance)entity)});
        }
        List events = this.eventRepository.listEvents(id2, null, (short)3);
        Assert.assertEquals((int)events.size(), (int)3);
        this.assertEventEquals((EntityAuditEvent)events.get(0), (EntityAuditEvent)expectedEvents.get(0));
        this.assertEventEquals((EntityAuditEvent)events.get(1), (EntityAuditEvent)expectedEvents.get(1));
        this.assertEventEquals((EntityAuditEvent)events.get(2), (EntityAuditEvent)expectedEvents.get(2));
        events = this.eventRepository.listEvents(id2, ((EntityAuditEvent)events.get(2)).getEventKey(), (short)3);
        Assert.assertEquals((int)events.size(), (int)1);
        this.assertEventEquals((EntityAuditEvent)events.get(0), (EntityAuditEvent)expectedEvents.get(2));
    }

    @Test
    public void testInvalidEntityId() throws Exception {
        List events = this.eventRepository.listEvents(this.rand(), null, (short)3);
        Assert.assertEquals((int)events.size(), (int)0);
    }

    protected void assertEventEquals(EntityAuditEvent actual, EntityAuditEvent expected) {
        if (expected != null) {
            Assert.assertNotNull((Object)actual);
        }
        Assert.assertEquals((String)actual.getEntityId(), (String)expected.getEntityId());
        Assert.assertEquals((Object)actual.getAction(), (Object)expected.getAction());
        Assert.assertEquals((long)actual.getTimestamp(), (long)expected.getTimestamp());
        Assert.assertEquals((String)actual.getDetails(), (String)expected.getDetails());
    }
}

