/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.typesafe.config.Config;
import java.io.File;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.atlas.query.GraphUtils;
import org.apache.atlas.query.GraphUtils$class;
import org.apache.atlas.query.HiveTitanSample$;
import org.apache.atlas.repository.graph.TitanGraphProvider;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.StructTypeDefinition;
import org.apache.atlas.typesystem.types.TraitType;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import scala.Array$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class QueryTestsUtils$
implements GraphUtils {
    public static final QueryTestsUtils$ MODULE$;

    static {
        new QueryTestsUtils$();
    }

    @Override
    public Configuration getConfiguration(Config config) {
        return GraphUtils$class.getConfiguration(this, config);
    }

    @Override
    public TitanGraph titanGraph(Configuration conf) {
        return GraphUtils$class.titanGraph(this, conf);
    }

    public void setupTypes() {
        TypeSystem.getInstance().defineTypes(ImmutableList.of(), ImmutableList.of((Object)this.hiveOrderDef$1()), ImmutableList.of((Object)this.dimTraitDef$1(), (Object)this.piiTraitDef$1(), (Object)this.metricTraitDef$1(), (Object)this.etlTraitDef$1(), (Object)this.jdbcTraitDef$1()), ImmutableList.of((Object)this.dbClsDef$1(), (Object)this.storageDescClsDef$1(), (Object)this.columnClsDef$1(), (Object)this.tblClsDef$1(), (Object)this.partitionClsDef$1(), (Object)this.loadProcessClsDef$1(), (Object)this.viewClsDef$1()));
    }

    /*
     * WARNING - void declaration
     */
    public TitanGraph setupTestGraph(TitanGraphProvider gp) {
        void var3_3;
        Configuration conf = TitanGraphProvider.getConfiguration();
        conf.setProperty("storage.directory", (Object)new StringBuilder().append((Object)conf.getString("storage.directory")).append((Object)"/../graph-data/").append((Object)RandomStringUtils.randomAlphanumeric((int)10)).toString());
        TitanGraph g = TitanFactory.open((Configuration)conf);
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("gremlin-groovy");
        Bindings bindings = engine.createBindings();
        bindings.put("g", (Object)g);
        String hiveGraphFile = new StringBuilder().append((Object)FileUtils.getTempDirectory().getPath()).append((Object)File.separator).append((Object)BoxesRunTime.boxToLong((long)System.nanoTime())).append((Object)".gson").toString();
        HiveTitanSample$.MODULE$.writeGson(hiveGraphFile);
        bindings.put("hiveGraphFile", (Object)hiveGraphFile);
        engine.eval("g.loadGraphSON(hiveGraphFile)", bindings);
        return var3_3;
    }

    private final AttributeDefinition attrDef$1(String name, IDataType dT, Multiplicity m, boolean isComposite, String reverseAttributeName) {
        Predef$.MODULE$.require(name != null);
        Predef$.MODULE$.require(dT != null);
        return new AttributeDefinition(name, dT.getName(), m, isComposite, reverseAttributeName);
    }

    private final Multiplicity attrDef$default$3$1() {
        return Multiplicity.OPTIONAL;
    }

    private final boolean attrDef$default$4$1() {
        return false;
    }

    private final String attrDef$default$5$1() {
        return null;
    }

    private final HierarchicalTypeDefinition dbClsDef$1() {
        return new HierarchicalTypeDefinition(ClassType.class, "DB", null, null, (AttributeDefinition[])((Object[])new AttributeDefinition[]{this.attrDef$1("name", (IDataType)DataTypes.STRING_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1()), this.attrDef$1("owner", (IDataType)DataTypes.STRING_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1()), this.attrDef$1("createTime", (IDataType)DataTypes.INT_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1()), this.attrDef$1("clusterName", (IDataType)DataTypes.STRING_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1())}));
    }

    private final StructTypeDefinition hiveOrderDef$1() {
        return new StructTypeDefinition("HiveOrder", (AttributeDefinition[])((Object[])new AttributeDefinition[]{this.attrDef$1("col", (IDataType)DataTypes.STRING_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1()), this.attrDef$1("order", (IDataType)DataTypes.INT_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1())}));
    }

    private final HierarchicalTypeDefinition storageDescClsDef$1() {
        AttributeDefinition[] attributeDefinitionArray = new AttributeDefinition[3];
        attributeDefinitionArray[0] = this.attrDef$1("inputFormat", (IDataType)DataTypes.STRING_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1());
        attributeDefinitionArray[1] = this.attrDef$1("outputFormat", (IDataType)DataTypes.STRING_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1());
        attributeDefinitionArray[2] = new AttributeDefinition("sortCols", DataTypes.arrayTypeName((String)"HiveOrder"), Multiplicity.REQUIRED, false, null);
        return new HierarchicalTypeDefinition(ClassType.class, "StorageDescriptor", null, null, (AttributeDefinition[])((Object[])attributeDefinitionArray));
    }

    private final HierarchicalTypeDefinition columnClsDef$1() {
        AttributeDefinition[] attributeDefinitionArray = new AttributeDefinition[3];
        attributeDefinitionArray[0] = this.attrDef$1("name", (IDataType)DataTypes.STRING_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1());
        attributeDefinitionArray[1] = this.attrDef$1("dataType", (IDataType)DataTypes.STRING_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1());
        attributeDefinitionArray[2] = new AttributeDefinition("sd", "StorageDescriptor", Multiplicity.REQUIRED, false, null);
        return new HierarchicalTypeDefinition(ClassType.class, "Column", null, null, (AttributeDefinition[])((Object[])attributeDefinitionArray));
    }

    private final HierarchicalTypeDefinition tblClsDef$1() {
        AttributeDefinition[] attributeDefinitionArray = new AttributeDefinition[4];
        attributeDefinitionArray[0] = this.attrDef$1("name", (IDataType)DataTypes.STRING_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1());
        attributeDefinitionArray[1] = new AttributeDefinition("db", "DB", Multiplicity.REQUIRED, false, null);
        attributeDefinitionArray[2] = new AttributeDefinition("sd", "StorageDescriptor", Multiplicity.REQUIRED, false, null);
        attributeDefinitionArray[3] = this.attrDef$1("created", (IDataType)DataTypes.DATE_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1());
        return new HierarchicalTypeDefinition(ClassType.class, "Table", null, null, (AttributeDefinition[])((Object[])attributeDefinitionArray));
    }

    private final HierarchicalTypeDefinition partitionClsDef$1() {
        AttributeDefinition[] attributeDefinitionArray = new AttributeDefinition[2];
        attributeDefinitionArray[0] = new AttributeDefinition("values", DataTypes.arrayTypeName((String)DataTypes.STRING_TYPE.getName()), Multiplicity.REQUIRED, false, null);
        attributeDefinitionArray[1] = new AttributeDefinition("table", "Table", Multiplicity.REQUIRED, false, null);
        return new HierarchicalTypeDefinition(ClassType.class, "Partition", null, null, (AttributeDefinition[])((Object[])attributeDefinitionArray));
    }

    private final HierarchicalTypeDefinition loadProcessClsDef$1() {
        AttributeDefinition[] attributeDefinitionArray = new AttributeDefinition[3];
        attributeDefinitionArray[0] = this.attrDef$1("name", (IDataType)DataTypes.STRING_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1());
        attributeDefinitionArray[1] = new AttributeDefinition("inputTables", DataTypes.arrayTypeName((String)"Table"), Multiplicity.COLLECTION, false, null);
        attributeDefinitionArray[2] = new AttributeDefinition("outputTable", "Table", Multiplicity.REQUIRED, false, null);
        return new HierarchicalTypeDefinition(ClassType.class, "LoadProcess", null, null, (AttributeDefinition[])((Object[])attributeDefinitionArray));
    }

    private final HierarchicalTypeDefinition viewClsDef$1() {
        AttributeDefinition[] attributeDefinitionArray = new AttributeDefinition[2];
        attributeDefinitionArray[0] = this.attrDef$1("name", (IDataType)DataTypes.STRING_TYPE, this.attrDef$default$3$1(), this.attrDef$default$4$1(), this.attrDef$default$5$1());
        attributeDefinitionArray[1] = new AttributeDefinition("inputTables", DataTypes.arrayTypeName((String)"Table"), Multiplicity.COLLECTION, false, null);
        return new HierarchicalTypeDefinition(ClassType.class, "View", null, null, (AttributeDefinition[])((Object[])attributeDefinitionArray));
    }

    private final HierarchicalTypeDefinition dimTraitDef$1() {
        return new HierarchicalTypeDefinition(TraitType.class, "Dimension", null, null, (AttributeDefinition[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(AttributeDefinition.class)));
    }

    private final HierarchicalTypeDefinition piiTraitDef$1() {
        return new HierarchicalTypeDefinition(TraitType.class, "PII", null, null, (AttributeDefinition[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(AttributeDefinition.class)));
    }

    private final HierarchicalTypeDefinition metricTraitDef$1() {
        return new HierarchicalTypeDefinition(TraitType.class, "Metric", null, null, (AttributeDefinition[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(AttributeDefinition.class)));
    }

    private final HierarchicalTypeDefinition etlTraitDef$1() {
        return new HierarchicalTypeDefinition(TraitType.class, "ETL", null, null, (AttributeDefinition[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(AttributeDefinition.class)));
    }

    private final HierarchicalTypeDefinition jdbcTraitDef$1() {
        return new HierarchicalTypeDefinition(TraitType.class, "JdbcAccess", null, null, (AttributeDefinition[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(AttributeDefinition.class)));
    }

    private QueryTestsUtils$() {
        MODULE$ = this;
        GraphUtils$class.$init$(this);
    }
}

