/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import org.apache.atlas.discovery.graph.DefaultGraphPersistenceStrategy;
import org.apache.atlas.query.BaseGremlinTest;
import org.apache.atlas.query.BaseGremlinTest$class;
import org.apache.atlas.query.Expressions;
import org.apache.atlas.query.Expressions$;
import org.apache.atlas.query.GraphPersistenceStrategies;
import org.apache.atlas.query.GraphPersistenceStrategy1$;
import org.apache.atlas.query.GraphResult;
import org.apache.atlas.query.GremlinQueryResult;
import org.apache.atlas.query.InputLineageClosureQuery;
import org.apache.atlas.query.OutputLineageClosureQuery;
import org.apache.atlas.query.QueryParams;
import org.apache.atlas.query.QueryParser$;
import org.apache.atlas.query.QueryProcessor$;
import org.apache.atlas.query.QueryTestsUtils$;
import org.apache.atlas.repository.MetadataRepository;
import org.apache.atlas.repository.graph.GraphBackedMetadataRepository;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.atlas.repository.graph.TitanGraphProvider;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001-\u0011Ab\u0012:f[2Lg\u000eV3tiJR!a\u0001\u0003\u0002\u000bE,XM]=\u000b\u0005\u00151\u0011!B1uY\u0006\u001c(BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005=\u0011\u0015m]3He\u0016lG.\u001b8UKN$\b\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\t\u0019\u0002\u0001C\u0004\u001c\u0001\u0001\u0007I\u0011\u0001\u000f\u0002\u0003\u001d,\u0012!\b\t\u0003=\u001dj\u0011a\b\u0006\u0003A\u0005\nAaY8sK*\u0011!eI\u0001\u0006i&$\u0018M\u001c\u0006\u0003I\u0015\nQ\u0002\u001e5j].\fWO]3mSV\u001c(\"\u0001\u0014\u0002\u0007\r|W.\u0003\u0002)?\tQA+\u001b;b]\u001e\u0013\u0018\r\u001d5\t\u000f)\u0002\u0001\u0019!C\u0001W\u0005)qm\u0018\u0013fcR\u0011Af\f\t\u0003\u001b5J!A\f\b\u0003\tUs\u0017\u000e\u001e\u0005\ba%\n\t\u00111\u0001\u001e\u0003\rAH%\r\u0005\u0007e\u0001\u0001\u000b\u0015B\u000f\u0002\u0005\u001d\u0004\u0003b\u0002\u001b\u0001\u0001\u0004%\t!N\u0001\nOB\u0013xN^5eKJ,\u0012A\u000e\t\u0003oqj\u0011\u0001\u000f\u0006\u0003si\nQa\u001a:ba\"T!a\u000f\u0003\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002>q\t\u0011B+\u001b;b]\u001e\u0013\u0018\r\u001d5Qe>4\u0018\u000eZ3s\u0011\u001dy\u0004\u00011A\u0005\u0002\u0001\u000bQb\u001a)s_ZLG-\u001a:`I\u0015\fHC\u0001\u0017B\u0011\u001d\u0001d(!AA\u0002YBaa\u0011\u0001!B\u00131\u0014AC4Qe>4\u0018\u000eZ3sA!9Q\t\u0001a\u0001\n\u00031\u0015AA4q+\u00059\u0005CA\nI\u0013\tI%A\u0001\u000eHe\u0006\u0004\b\u000eU3sg&\u001cH/\u001a8dKN#(/\u0019;fO&,7\u000fC\u0004L\u0001\u0001\u0007I\u0011\u0001'\u0002\r\u001d\u0004x\fJ3r)\taS\nC\u00041\u0015\u0006\u0005\t\u0019A$\t\r=\u0003\u0001\u0015)\u0003H\u0003\r9\u0007\u000f\t\u0005\u0006#\u0002!\tAU\u0001\nE\u00164wN]3BY2$\u0012\u0001\f\u0015\u0003!R\u0003\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\u0017\u0005tgn\u001c;bi&|gn\u001d\u0006\u00033\"\ta\u0001^3ti:<\u0017BA.W\u0005-\u0011UMZ8sK\u000ec\u0017m]:\t\u000bu\u0003A\u0011\u0001*\u0002\u0011\u00054G/\u001a:BY2D#\u0001X0\u0011\u0005U\u0003\u0017BA1W\u0005)\te\r^3s\u00072\f7o\u001d\u0005\u0006G\u0002!\t\u0001Z\u0001\u0010i\u0016\u001cH\u000f\u0016:bSR\u001cV\r\\3diV\tA\u0006\u000b\u0002cMB\u0011QkZ\u0005\u0003QZ\u0013A\u0001V3ti\")!\u000e\u0001C\u0001I\u0006IA/Z:u)J\f\u0017\u000e\u001e\u0015\u0003S\u001aDQ!\u001c\u0001\u0005\u0002\u0011\f\u0011\u0003^3tiR\u0013\u0018-\u001b;J]N$\u0018M\\2fQ\tag\rC\u0003q\u0001\u0011\u0005A-A\ruKN$\u0018J\\:uC:\u001cW-\u00113eK\u0012$vNR5mi\u0016\u0014\bFA8g\u0011\u0015\u0019\b\u0001\"\u0001e\u0003I!Xm\u001d;J]N$\u0018M\\2f\r&dG/\u001a:)\u0005I4\u0007\"\u0002<\u0001\t\u0003!\u0017a\u0005;fgRd\u0015N\\3bO\u0016<\u0016\u000e\u001e5QCRD\u0007FA;g\u0011\u0015I\b\u0001\"\u0001e\u0003q!Xm\u001d;MS:,\u0017mZ3BY2\u001cV\r\\3di^KG\u000f\u001b)bi\"D#\u0001\u001f4\t\u000bq\u0004A\u0011\u00013\u0002MQ,7\u000f\u001e'j]\u0016\fw-Z!mYN+G.Z2u/&$\b\u000eU1uQ\u001a\u0013x.\u001c)beN,'\u000f\u000b\u0002|M\")q\u0010\u0001C\u0001I\u00069C/Z:u\u0019&tW-Y4f\u00032d7+\u001a7fGR<\u0016\u000e\u001e5QCRDgI]8n!\u0006\u00148/\u001a:3Q\tqh\r\u0003\u0004\u0002\u0006\u0001!\t\u0001Z\u0001\u0015i\u0016\u001cH\u000fS5hQ2+g/\u001a7MS:,\u0017mZ3)\u0007\u0005\ra\r\u0003\u0004\u0002\f\u0001!\t\u0001Z\u0001 i\u0016\u001cH\u000fS5hQ2+g/\u001a7MS:,\u0017mZ3SKR,(O\\$sCBD\u0007fAA\u0005M\"1\u0011\u0011\u0003\u0001\u0005\u0002\u0011\fa\u0003^3ti\"Kw\r\u001b'fm\u0016dw\u000b[3sKV\u001bX\r\u001a\u0015\u0004\u0003\u001f1\u0007BBA\f\u0001\u0011\u0005A-A\u0011uKN$\b*[4i\u0019\u00164X\r\\,iKJ,Wk]3e%\u0016$XO\u001d8He\u0006\u0004\b\u000eK\u0002\u0002\u0016\u0019\u0004")
public class GremlinTest2
implements BaseGremlinTest {
    private TitanGraph g;
    private TitanGraphProvider gProvider;
    private GraphPersistenceStrategies gp;
    private final Regex STRUCT_NAME_REGEX;

    @Override
    public Regex STRUCT_NAME_REGEX() {
        return this.STRUCT_NAME_REGEX;
    }

    @Override
    public void org$apache$atlas$query$BaseGremlinTest$_setter_$STRUCT_NAME_REGEX_$eq(Regex x$1) {
        this.STRUCT_NAME_REGEX = x$1;
    }

    @Override
    public void validateJson(GremlinQueryResult r, String expected) {
        BaseGremlinTest$class.validateJson(this, r, expected);
    }

    @Override
    public String validateJson$default$2() {
        return BaseGremlinTest$class.validateJson$default$2(this);
    }

    public TitanGraph g() {
        return this.g;
    }

    public void g_$eq(TitanGraph x$1) {
        this.g = x$1;
    }

    public TitanGraphProvider gProvider() {
        return this.gProvider;
    }

    public void gProvider_$eq(TitanGraphProvider x$1) {
        this.gProvider = x$1;
    }

    public GraphPersistenceStrategies gp() {
        return this.gp;
    }

    public void gp_$eq(GraphPersistenceStrategies x$1) {
        this.gp = x$1;
    }

    @BeforeClass
    public void beforeAll() {
        TypeSystem.getInstance().reset();
        QueryTestsUtils$.MODULE$.setupTypes();
        this.gProvider_$eq(new TitanGraphProvider());
        this.gp_$eq((GraphPersistenceStrategies)new DefaultGraphPersistenceStrategy((MetadataRepository)new GraphBackedMetadataRepository((GraphProvider)this.gProvider(), null)));
        this.g_$eq(QueryTestsUtils$.MODULE$.setupTestGraph(this.gProvider()));
    }

    @AfterClass
    public void afterAll() {
        this.g().shutdown();
        try {
            TitanCleanup.clear((TitanGraph)this.g());
        }
        catch (Exception exception) {
            Predef$.MODULE$.print((Object)new Tuple2((Object)"Could not clear the graph ", (Object)exception));
        }
    }

    @Test
    public void testTraitSelect() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("Table").as("t").join("Dimension").as("dim").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expressions.Expression[]{Expressions$.MODULE$.id("t"), Expressions$.MODULE$.id("dim")})), this.g(), QueryProcessor$.MODULE$.evaluate$default$3());
        this.validateJson(r, "{\n  \"query\":\"Table as t.Dimension as dim select t as _col_0, dim as _col_1\",\n  \"dataType\":{\n    \"typeName\":\"\",\n    \"attributeDefinitions\":[\n      {\n        \"name\":\"_col_0\",\n        \"dataTypeName\":\"Table\",\n        \"multiplicity\":{\n          \"lower\":0,\n          \"upper\":1,\n          \"isUnique\":false\n        },\n        \"isComposite\":false,\n        \"isUnique\":false,\n        \"isIndexable\":true,\n        \"reverseAttributeName\":null\n      },\n      {\n        \"name\":\"_col_1\",\n        \"dataTypeName\":\"Dimension\",\n        \"multiplicity\":{\n          \"lower\":0,\n          \"upper\":1,\n          \"isUnique\":false\n        },\n        \"isComposite\":false,\n        \"isUnique\":false,\n        \"isIndexable\":true,\n        \"reverseAttributeName\":null\n      }\n    ]\n  },\n  \"rows\":[\n    {\n      \"$typeName$\":\"\",\n      \"_col_1\":{\n        \"$typeName$\":\"Dimension\"\n      },\n      \"_col_0\":{\n        \"id\":\"3328\",\n        \"$typeName$\":\"Table\",\n        \"version\":0\n      }\n    },\n    {\n      \"$typeName$\":\"\",\n      \"_col_1\":{\n        \"$typeName$\":\"Dimension\"\n      },\n      \"_col_0\":{\n        \"id\":\"4864\",\n        \"$typeName$\":\"Table\",\n        \"version\":0\n      }\n    },\n    {\n      \"$typeName$\":\"\",\n      \"_col_1\":{\n        \"$typeName$\":\"Dimension\"\n      },\n      \"_col_0\":{\n        \"id\":\"6656\",\n        \"$typeName$\":\"Table\",\n        \"version\":0\n      }\n    }\n  ]\n}");
    }

    @Test
    public void testTrait() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._trait("Dimension"), this.g(), QueryProcessor$.MODULE$.evaluate$default$3());
        this.validateJson(r, this.validateJson$default$2());
    }

    @Test
    public void testTraitInstance() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._trait("Dimension").traitInstance(), this.g(), QueryProcessor$.MODULE$.evaluate$default$3());
        this.validateJson(r, this.validateJson$default$2());
    }

    @Test
    public void testInstanceAddedToFilter() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._trait("Dimension").hasField("typeName"), this.g(), QueryProcessor$.MODULE$.evaluate$default$3());
        this.validateJson(r, this.validateJson$default$2());
    }

    @Test
    public void testInstanceFilter() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._trait("Dimension").traitInstance().hasField("name"), this.g(), QueryProcessor$.MODULE$.evaluate$default$3());
        this.validateJson(r, this.validateJson$default$2());
    }

    @Test
    public void testLineageWithPath() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("Table").loop((Expressions.Expression)Expressions$.MODULE$.id("LoadProcess").field("outputTable")).path(), this.g(), QueryProcessor$.MODULE$.evaluate$default$3());
        this.validateJson(r, this.validateJson$default$2());
    }

    @Test
    public void testLineageAllSelectWithPath() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("Table").as("src").loop((Expressions.Expression)Expressions$.MODULE$.id("LoadProcess").field("outputTable")).as("dest").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expressions.Expression[]{Expressions$.MODULE$.id("src").field("name").as("srcTable"), Expressions$.MODULE$.id("dest").field("name").as("destTable")})).path(), this.g(), QueryProcessor$.MODULE$.evaluate$default$3());
        this.validateJson(r, this.validateJson$default$2());
    }

    @Test
    public void testLineageAllSelectWithPathFromParser() {
        QueryParser$ p = QueryParser$.MODULE$;
        String x$1 = "Table as src loop (LoadProcess outputTable) as dest select src.name as srcTable, dest.name as destTable withPath";
        QueryParams x$2 = p.apply$default$2(x$1);
        Expressions.Expression e = (Expressions.Expression)p.apply(x$1, x$2).right().get();
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate(e, this.g(), QueryProcessor$.MODULE$.evaluate$default$3());
        this.validateJson(r, this.validateJson$default$2());
    }

    @Test
    public void testLineageAllSelectWithPathFromParser2() {
        QueryParser$ p = QueryParser$.MODULE$;
        String x$3 = "Table as src loop (`LoadProcess->outputTable` inputTables) as dest select src.name as srcTable, dest.name as destTable withPath";
        QueryParams x$4 = p.apply$default$2(x$3);
        Expressions.Expression e = (Expressions.Expression)p.apply(x$3, x$4).right().get();
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate(e, this.g(), QueryProcessor$.MODULE$.evaluate$default$3());
        this.validateJson(r, this.validateJson$default$2());
    }

    @Test
    public void testHighLevelLineage() {
        GremlinQueryResult r = new InputLineageClosureQuery("Table", "name", "sales_fact_monthly_mv", "LoadProcess", "inputTables", "outputTable", (Option)None$.MODULE$, (Option)new Some((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))), true, (GraphPersistenceStrategies)GraphPersistenceStrategy1$.MODULE$, this.g()).evaluate();
        this.validateJson(r, this.validateJson$default$2());
    }

    @Test
    public void testHighLevelLineageReturnGraph() {
        InputLineageClosureQuery q = new InputLineageClosureQuery("Table", "name", "sales_fact_monthly_mv", "LoadProcess", "inputTables", "outputTable", (Option)None$.MODULE$, (Option)new Some((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))), true, (GraphPersistenceStrategies)GraphPersistenceStrategy1$.MODULE$, this.g());
        GremlinQueryResult gr = q.evaluate();
        GraphResult r = q.graph(gr);
        Predef$.MODULE$.println((Object)r.toInstanceJson());
    }

    @Test
    public void testHighLevelWhereUsed() {
        GremlinQueryResult r = new OutputLineageClosureQuery("Table", "name", "sales_fact", "LoadProcess", "inputTables", "outputTable", (Option)None$.MODULE$, (Option)new Some((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))), true, (GraphPersistenceStrategies)GraphPersistenceStrategy1$.MODULE$, this.g()).evaluate();
        this.validateJson(r, this.validateJson$default$2());
    }

    @Test
    public void testHighLevelWhereUsedReturnGraph() {
        OutputLineageClosureQuery q = new OutputLineageClosureQuery("Table", "name", "sales_fact", "LoadProcess", "inputTables", "outputTable", (Option)None$.MODULE$, (Option)new Some((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name"}))), true, (GraphPersistenceStrategies)GraphPersistenceStrategy1$.MODULE$, this.g());
        GremlinQueryResult gr = q.evaluate();
        GraphResult r = q.graph(gr);
        Predef$.MODULE$.println((Object)r.toInstanceJson());
    }

    public GremlinTest2() {
        BaseGremlinTest$class.$init$(this);
        this.g = null;
        this.gProvider = null;
        this.gp = null;
    }
}

