/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.query;

import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import org.apache.atlas.discovery.graph.DefaultGraphPersistenceStrategy;
import org.apache.atlas.query.BaseGremlinTest;
import org.apache.atlas.query.BaseGremlinTest$class;
import org.apache.atlas.query.Expressions;
import org.apache.atlas.query.Expressions$;
import org.apache.atlas.query.GraphPersistenceStrategies;
import org.apache.atlas.query.GremlinQueryResult;
import org.apache.atlas.query.QueryParams;
import org.apache.atlas.query.QueryParser$;
import org.apache.atlas.query.QueryProcessor$;
import org.apache.atlas.query.QueryTestsUtils$;
import org.apache.atlas.repository.MetadataRepository;
import org.apache.atlas.repository.graph.GraphBackedMetadataRepository;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.atlas.repository.graph.TitanGraphProvider;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001-\u00111b\u0012:f[2Lg\u000eV3ti*\u00111\u0001B\u0001\u0006cV,'/\u001f\u0006\u0003\u000b\u0019\tQ!\u0019;mCNT!a\u0002\u0005\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u001f\t\u000b7/Z$sK6d\u0017N\u001c+fgRDQa\u0006\u0001\u0005\u0002a\ta\u0001P5oSRtD#A\r\u0011\u0005M\u0001\u0001bB\u000e\u0001\u0001\u0004%\t\u0001H\u0001\u0002OV\tQ\u0004\u0005\u0002\u001fO5\tqD\u0003\u0002!C\u0005!1m\u001c:f\u0015\t\u00113%A\u0003uSR\fgN\u0003\u0002%K\u0005iA\u000f[5oW\u0006,(/\u001a7jkNT\u0011AJ\u0001\u0004G>l\u0017B\u0001\u0015 \u0005)!\u0016\u000e^1o\u000fJ\f\u0007\u000f\u001b\u0005\bU\u0001\u0001\r\u0011\"\u0001,\u0003\u00159w\fJ3r)\tas\u0006\u0005\u0002\u000e[%\u0011aF\u0004\u0002\u0005+:LG\u000fC\u00041S\u0005\u0005\t\u0019A\u000f\u0002\u0007a$\u0013\u0007\u0003\u00043\u0001\u0001\u0006K!H\u0001\u0003O\u0002Bq\u0001\u000e\u0001A\u0002\u0013\u0005Q'\u0001\u0002haV\ta\u0007\u0005\u0002\u0014o%\u0011\u0001H\u0001\u0002\u001b\u000fJ\f\u0007\u000f\u001b)feNL7\u000f^3oG\u0016\u001cFO]1uK\u001eLWm\u001d\u0005\bu\u0001\u0001\r\u0011\"\u0001<\u0003\u00199\u0007o\u0018\u0013fcR\u0011A\u0006\u0010\u0005\bae\n\t\u00111\u00017\u0011\u0019q\u0004\u0001)Q\u0005m\u0005\u0019q\r\u001d\u0011\t\u000f\u0001\u0003\u0001\u0019!C\u0001\u0003\u0006Iq\r\u0015:pm&$WM]\u000b\u0002\u0005B\u00111\tS\u0007\u0002\t*\u0011QIR\u0001\u0006OJ\f\u0007\u000f\u001b\u0006\u0003\u000f\u0012\t!B]3q_NLGo\u001c:z\u0013\tIEI\u0001\nUSR\fgn\u0012:ba\"\u0004&o\u001c<jI\u0016\u0014\bbB&\u0001\u0001\u0004%\t\u0001T\u0001\u000eOB\u0013xN^5eKJ|F%Z9\u0015\u00051j\u0005b\u0002\u0019K\u0003\u0003\u0005\rA\u0011\u0005\u0007\u001f\u0002\u0001\u000b\u0015\u0002\"\u0002\u0015\u001d\u0004&o\u001c<jI\u0016\u0014\b\u0005C\u0003R\u0001\u0011\u0005!+A\u0005cK\u001a|'/Z!mYR\tA\u0006\u000b\u0002Q)B\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\fC:tw\u000e^1uS>t7O\u0003\u0002Z\u0011\u00051A/Z:u]\u001eL!a\u0017,\u0003\u0017\t+gm\u001c:f\u00072\f7o\u001d\u0005\u0006;\u0002!\tAU\u0001\tC\u001a$XM]!mY\"\u0012Al\u0018\t\u0003+\u0002L!!\u0019,\u0003\u0015\u00053G/\u001a:DY\u0006\u001c8\u000fC\u0003d\u0001\u0011\u0005A-A\u0005uKN$8\t\\1tgV\tA\u0006\u000b\u0002cMB\u0011QkZ\u0005\u0003QZ\u0013A\u0001V3ti\")!\u000e\u0001C\u0001I\u0006AA/Z:u\u001d\u0006lW\r\u000b\u0002jM\")Q\u000e\u0001C\u0001I\u0006QA/Z:u\r&dG/\u001a:)\u000514\u0007\"\u00029\u0001\t\u0003!\u0017a\u0003;fgR4\u0015\u000e\u001c;feJB#a\u001c4\t\u000bM\u0004A\u0011\u00013\u0002\u0015Q,7\u000f^*fY\u0016\u001cG\u000f\u000b\u0002sM\")a\u000f\u0001C\u0001I\u0006YA/Z:u\u0013N$&/Y5uQ\t)h\rC\u0003z\u0001\u0011\u0005A-\u0001\u0007uKN$\b.Y:GS\u0016dG\r\u000b\u0002yM\")A\u0010\u0001C\u0001I\u0006\u0011B/Z:u\r&,G\u000e\u001a*fM\u0016\u0014XM\\2fQ\tYh\rC\u0003\u0000\u0001\u0011\u0005A-A\tuKN$()Y2l%\u00164WM]3oG\u0016D#A 4\t\r\u0005\u0015\u0001\u0001\"\u0001e\u0003%!Xm\u001d;Be&$\b\u000eK\u0002\u0002\u0004\u0019Da!a\u0003\u0001\t\u0003!\u0017!\u0006;fgR\u001cu.\u001c9be&\u001cxN\u001c'pO&\u001c\u0017\r\u001c\u0015\u0004\u0003\u00131\u0007BBA\t\u0001\u0011\u0005A-\u0001\nuKN$(j\\5o\u0003:$7+\u001a7fGR\f\u0004fAA\bM\"1\u0011q\u0003\u0001\u0005\u0002\u0011\f!\u0003^3ti*{\u0017N\\!oIN+G.Z2ue!\u001a\u0011Q\u00034\t\r\u0005u\u0001\u0001\"\u0001e\u0003I!Xm\u001d;K_&t\u0017I\u001c3TK2,7\r^\u001a)\u0007\u0005ma\r\u0003\u0004\u0002$\u0001!\t\u0001Z\u0001\u0013i\u0016\u001cHOS8j]\u0006sGmU3mK\u000e$H\u0007K\u0002\u0002\"\u0019Da!!\u000b\u0001\t\u0003!\u0017\u0001\u0006;fgR\f%O]1z\u0007>l\u0007/\u0019:jg&|g\u000eK\u0002\u0002(\u0019Da!a\f\u0001\t\u0003!\u0017!\n;fgR\f%O]1z\u0007>l\u0007/\u0019:jg&|gnV5uQN+G.Z2u\u001f:\f%O]1zQ\r\tiC\u001a\u0005\u0007\u0003k\u0001A\u0011\u00013\u0002-Q,7\u000f^!se\u0006L\u0018J\\,iKJ,7\t\\1vg\u0016D3!a\rg\u0011\u0019\tY\u0004\u0001C\u0001I\u0006\u0019B/Z:u\u0003J\u0014\u0018-_,ji\"\u001cFO];di\"\u001a\u0011\u0011\b4\t\r\u0005\u0005\u0003\u0001\"\u0001e\u0003]!Xm\u001d;OK\u001e\fG/\u001b<f\u0013:4\u0018\r\\5e)f\u0004X\rK\u0004\u0002@\u0019\f)%a\u0012\u0002%\u0015D\b/Z2uK\u0012,\u0005pY3qi&|gn\u001d\u0017\u0003\u0003\u0013\u001a#!a\u0013\u0011\t\u00055\u0013\u0011\u000e\b\u0005\u0003\u001f\n)G\u0004\u0003\u0002R\u0005\rd\u0002BA*\u0003CrA!!\u0016\u0002`9!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\)\ta\u0001\u0010:p_Rt\u0014\"A\u0005\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019A!C\u0002\u0002h\t\t1\"\u0012=qe\u0016\u001c8/[8og&!\u00111NA7\u0005M)\u0005\u0010\u001d:fgNLwN\\#yG\u0016\u0004H/[8o\u0015\r\t9G\u0001\u0005\u0007\u0003c\u0002A\u0011\u00013\u0002%Q,7\u000f\u001e&pS:\fe\u000eZ*fY\u0016\u001cG/\u000e\u0015\u0004\u0003_2\u0007")
public class GremlinTest
implements BaseGremlinTest {
    private TitanGraph g;
    private GraphPersistenceStrategies gp;
    private TitanGraphProvider gProvider;
    private final Regex STRUCT_NAME_REGEX;

    @Override
    public Regex STRUCT_NAME_REGEX() {
        return this.STRUCT_NAME_REGEX;
    }

    @Override
    public void org$apache$atlas$query$BaseGremlinTest$_setter_$STRUCT_NAME_REGEX_$eq(Regex x$1) {
        this.STRUCT_NAME_REGEX = x$1;
    }

    @Override
    public void validateJson(GremlinQueryResult r, String expected) {
        BaseGremlinTest$class.validateJson(this, r, expected);
    }

    @Override
    public String validateJson$default$2() {
        return BaseGremlinTest$class.validateJson$default$2(this);
    }

    public TitanGraph g() {
        return this.g;
    }

    public void g_$eq(TitanGraph x$1) {
        this.g = x$1;
    }

    public GraphPersistenceStrategies gp() {
        return this.gp;
    }

    public void gp_$eq(GraphPersistenceStrategies x$1) {
        this.gp = x$1;
    }

    public TitanGraphProvider gProvider() {
        return this.gProvider;
    }

    public void gProvider_$eq(TitanGraphProvider x$1) {
        this.gProvider = x$1;
    }

    @BeforeClass
    public void beforeAll() {
        TypeSystem.getInstance().reset();
        QueryTestsUtils$.MODULE$.setupTypes();
        this.gProvider_$eq(new TitanGraphProvider());
        this.gp_$eq((GraphPersistenceStrategies)new DefaultGraphPersistenceStrategy((MetadataRepository)new GraphBackedMetadataRepository((GraphProvider)this.gProvider(), null)));
        this.g_$eq(QueryTestsUtils$.MODULE$.setupTestGraph(this.gProvider()));
    }

    @AfterClass
    public void afterAll() {
        try {
            this.g().shutdown();
        }
        catch (Exception exception) {
            Predef$.MODULE$.print((Object)new Tuple2((Object)"Could not shutdown the graph ", (Object)exception));
        }
        try {
            TitanCleanup.clear((TitanGraph)this.g());
        }
        catch (Exception exception) {
            Predef$.MODULE$.print((Object)new Tuple2((Object)"Could not clear the graph ", (Object)exception));
        }
    }

    @Test
    public void testClass() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate(Expressions$.MODULE$._class("DB"), this.g(), this.gp());
        this.validateJson(r, new StringOps(Predef$.MODULE$.augmentString("{\n                      |    \"query\": \"DB\",\n                      |    \"dataType\": {\n                      |        \"superTypes\": [\n                      |\n                      |        ],\n                      |        \"hierarchicalMetaTypeName\": \"org.apache.atlas.typesystem.types.ClassType\",\n                      |        \"typeName\": \"DB\",\n                      |        \"attributeDefinitions\": [\n                      |            {\n                      |                \"name\": \"name\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |                \"isComposite\": false,\n                      |                \"isUnique\": false,\n                      |                \"isIndexable\": false,\n                      |                \"reverseAttributeName\": null\n                      |            },\n                      |            {\n                      |                \"name\": \"owner\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |                \"isComposite\": false,\n                      |                \"isUnique\": false,\n                      |                \"isIndexable\": false,\n                      |                \"reverseAttributeName\": null\n                      |            },\n                      |            {\n                      |                \"name\": \"createTime\",\n                      |                \"dataTypeName\": \"int\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                 },\n                      |                \"isComposite\": false,\n                      |               \"isUnique\": false,\n                      |               \"isIndexable\": false,\n                      |               \"reverseAttributeName\": null\n                      |\n                      |            },\n                      |            {\n                      |                \"name\": \"clusterName\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |               \"isComposite\": false,\n                      |               \"isUnique\": false,\n                      |               \"isIndexable\": false,\n                      |               \"reverseAttributeName\": null\n                      |            }\n                      |            ]\n                      |        },\n                      |        \"rows\": [\n                      |            {\n                      |                \"$typeName$\": \"DB\",\n                      |                \"$id$\": {\n                      |                    \"$typeName$\": \"DB\",\n                      |                    \"version\": 0\n                      |                },\n                      |                \"owner\": \"John ETL\",\n                      |                \"name\": \"Sales\",\n                      |                \"createTime\": 1000,\n                      |                \"clusterName\": \"test\"\n                      |            },\n                      |            {\n                      |                \"$typeName$\": \"DB\",\n                      |                \"$id$\": {\n                      |                    \"$typeName$\": \"DB\",\n                      |                    \"version\": 0\n                      |                },\n                      |                \"owner\": \"Jane BI\",\n                      |                \"name\": \"Reporting\",\n                      |                \"createTime\": 1500,\n                      |                \"clusterName\": \"test\"\n                      |            }\n                      |        ]\n                      |    }")).stripMargin());
    }

    @Test
    public void testName() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("DB").field("name"), this.g(), this.gp());
        this.validateJson(r, "{\n  \"query\":\"DB.name\",\n  \"dataType\":\"string\",\n  \"rows\":[\n    \"Sales\",\n    \"Reporting\"\n  ]\n}");
    }

    @Test
    public void testFilter() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("DB").where((Expressions.Expression)Expressions$.MODULE$.id("name").$eq().apply((Object)Expressions$.MODULE$.string((Object)"Reporting"))), this.g(), this.gp());
        this.validateJson(r, new StringOps(Predef$.MODULE$.augmentString("{\n                      |    \"query\": \"DB where (name = \\\"Reporting\\\")\",\n                      |    \"dataType\": {\n                      |        \"superTypes\": [],\n                      |        \"hierarchicalMetaTypeName\": \"org.apache.atlas.typesystem.types.ClassType\",\n                      |        \"typeName\": \"DB\",\n                      |        \"attributeDefinitions\": [\n                      |            {\n                      |                \"name\": \"name\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |                \"isComposite\": false,\n                      |                \"isUnique\": false,\n                      |                \"isIndexable\": false,\n                      |                \"reverseAttributeName\": null\n                      |            },\n                      |            {\n                      |                \"name\": \"owner\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |                \"isComposite\": false,\n                      |                \"isUnique\": false,\n                      |                \"isIndexable\": false,\n                      |                \"reverseAttributeName\": null\n                      |            },\n                      |            {\n                      |                \"name\": \"createTime\",\n                      |                \"dataTypeName\": \"int\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |                \"isComposite\": false,\n                      |                \"isUnique\": false,\n                      |                \"isIndexable\": false,\n                      |                \"reverseAttributeName\": null\n                      |            },\n                      |            {\n                      |                \"name\": \"clusterName\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |               \"isComposite\": false,\n                      |               \"isUnique\": false,\n                      |               \"isIndexable\": false,\n                      |               \"reverseAttributeName\": null\n                      |            }\n                      |        ]\n                      |    },\n                      |    \"rows\": [\n                      |        {\n                      |            \"$typeName$\": \"DB\",\n                      |            \"$id$\": {\n                      |                \"$typeName$\": \"DB\",\n                      |                \"version\": 0\n                      |            },\n                      |            \"owner\": \"Jane BI\",\n                      |            \"name\": \"Reporting\",\n                      |            \"createTime\": 1500,\n                      |            \"clusterName\": \"test\"\n                      |        }\n                      |    ]\n                      |}")).stripMargin());
    }

    @Test
    public void testFilter2() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("DB").where((Expressions.Expression)Expressions$.MODULE$.id("DB").field("name").$eq().apply((Object)Expressions$.MODULE$.string((Object)"Reporting"))), this.g(), this.gp());
        this.validateJson(r, new StringOps(Predef$.MODULE$.augmentString("{\n                      |    \"query\": \"DB where (name = \\\"Reporting\\\")\",\n                      |    \"dataType\": {\n                      |        \"superTypes\": [],\n                      |        \"hierarchicalMetaTypeName\": \"org.apache.atlas.typesystem.types.ClassType\",\n                      |        \"typeName\": \"DB\",\n                      |        \"attributeDefinitions\": [\n                      |            {\n                      |                \"name\": \"name\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |                \"isComposite\": false,\n                      |                \"isUnique\": false,\n                      |                \"isIndexable\": false,\n                      |                \"reverseAttributeName\": null\n                      |            },\n                      |            {\n                      |                \"name\": \"owner\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |                \"isComposite\": false,\n                      |                \"isUnique\": false,\n                      |                \"isIndexable\": false,\n                      |                \"reverseAttributeName\": null\n                      |            },\n                      |            {\n                      |                \"name\": \"createTime\",\n                      |                \"dataTypeName\": \"int\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |                \"isComposite\": false,\n                      |                \"isUnique\": false,\n                      |                \"isIndexable\": false,\n                      |                \"reverseAttributeName\": null\n                      |            },\n                      |            {\n                      |                \"name\": \"clusterName\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |               \"isComposite\": false,\n                      |               \"isUnique\": false,\n                      |               \"isIndexable\": false,\n                      |               \"reverseAttributeName\": null\n                      |            }\n                      |        ]\n                      |    },\n                      |    \"rows\": [\n                      |        {\n                      |            \"$typeName$\": \"DB\",\n                      |            \"$id$\": {\n                      |                \"$typeName$\": \"DB\",\n                      |                \"version\": 0\n                      |            },\n                      |            \"owner\": \"Jane BI\",\n                      |            \"name\": \"Reporting\",\n                      |            \"createTime\": 1500,\n                      |            \"clusterName\": \"test\"\n                      |        }\n                      |    ]\n                      |}")).stripMargin());
    }

    @Test
    public void testSelect() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("DB").where((Expressions.Expression)Expressions$.MODULE$.id("name").$eq().apply((Object)Expressions$.MODULE$.string((Object)"Reporting"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expressions.Expression[]{Expressions$.MODULE$.id("name"), Expressions$.MODULE$.id("owner")})), this.g(), this.gp());
        this.validateJson(r, new StringOps(Predef$.MODULE$.augmentString("{\n                      |    \"query\": \"DB where (name = \\\"Reporting\\\") as _src1 select _src1.name as _src1.name, _src1.owner as _src1.owner\",\n                      |    \"dataType\": {\n                      |        \"typeName\": \"__tempQueryResultStruct1\",\n                      |        \"attributeDefinitions\": [\n                      |            {\n                      |                \"name\": \"_src1.name\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |                \"isComposite\": false,\n                      |                \"isUnique\": false,\n                      |                \"isIndexable\": false,\n                      |                \"reverseAttributeName\": null\n                      |            },\n                      |            {\n                      |                \"name\": \"_src1.owner\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |                \"isComposite\": false,\n                      |                \"isUnique\": false,\n                      |                \"isIndexable\": false,\n                      |                \"reverseAttributeName\": null\n                      |            }\n                      |        ]\n                      |    },\n                      |    \"rows\": [\n                      |        {\n                      |            \"$typeName$\": \"__tempQueryResultStruct1\",\n                      |            \"_src1.owner\": \"Jane BI\",\n                      |            \"_src1.name\": \"Reporting\"\n                      |        }\n                      |    ]\n                      |}")).stripMargin());
    }

    @Test
    public void testIsTrait() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("Table").where((Expressions.Expression)Expressions$.MODULE$.isTrait("Dimension")), this.g(), this.gp());
        this.validateJson(r, new StringOps(Predef$.MODULE$.augmentString("{\n                      |  \"query\":\"Table where Table is Dimension\",\n                      |  \"dataType\":{\n                      |    \"superTypes\":[\n                      |\n                      |    ],\n                      |    \"hierarchicalMetaTypeName\":\"org.apache.atlas.typesystem.types.ClassType\",\n                      |    \"typeName\":\"Table\",\n                      |    \"attributeDefinitions\":[\n                      |      {\n                      |        \"name\":\"name\",\n                      |        \"dataTypeName\":\"string\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":0,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      },\n                      |      {\n                      |        \"name\":\"db\",\n                      |        \"dataTypeName\":\"DB\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":1,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      },\n                      |      {\n                      |        \"name\":\"sd\",\n                      |        \"dataTypeName\":\"StorageDescriptor\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":1,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      },\n                      |      {\n                      |        \"name\":\"created\",\n                      |        \"dataTypeName\":\"date\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":0,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      }\n                      |    ]\n                      |  },\n                      |  \"rows\":[\n                      |    {\n                      |      \"$typeName$\":\"Table\",\n                      |      \"$id$\":{\n                      |        \"$typeName$\":\"Table\",\n                      |        \"version\":0\n                      |      },\n                      |      \"created\":\"2014-12-11T02:35:58.440Z\",\n                      |      \"sd\":{\n                      |        \"$typeName$\":\"StorageDescriptor\",\n                      |        \"version\":0\n                      |      },\n                      |      \"db\":{\n                      |        \"$typeName$\":\"DB\",\n                      |        \"version\":0\n                      |      },\n                      |      \"name\":\"product_dim\",\n                      |      \"$traits$\":{\n                      |        \"Dimension\":{\n                      |          \"$typeName$\":\"Dimension\"\n                      |        }\n                      |      }\n                      |    },\n                      |    {\n                      |      \"$typeName$\":\"Table\",\n                      |      \"$id$\":{\n                      |        \"$typeName$\":\"Table\",\n                      |        \"version\":0\n                      |      },\n                      |      \"created\":\"2014-12-11T02:35:58.440Z\",\n                      |      \"sd\":{\n                      |        \"$typeName$\":\"StorageDescriptor\",\n                      |        \"version\":0\n                      |      },\n                      |      \"db\":{\n                      |        \"$typeName$\":\"DB\",\n                      |        \"version\":0\n                      |      },\n                      |      \"name\":\"time_dim\",\n                      |      \"$traits$\":{\n                      |        \"Dimension\":{\n                      |          \"$typeName$\":\"Dimension\"\n                      |        }\n                      |      }\n                      |    },\n                      |    {\n                      |      \"$typeName$\":\"Table\",\n                      |      \"$id$\":{\n                      |        \"$typeName$\":\"Table\",\n                      |        \"version\":0\n                      |      },\n                      |      \"created\":\"2014-12-11T02:35:58.440Z\",\n                      |      \"sd\":{\n                      |        \"$typeName$\":\"StorageDescriptor\",\n                      |        \"version\":0\n                      |      },\n                      |      \"db\":{\n                      |        \"$typeName$\":\"DB\",\n                      |        \"version\":0\n                      |      },\n                      |      \"name\":\"customer_dim\",\n                      |      \"$traits$\":{\n                      |        \"Dimension\":{\n                      |          \"$typeName$\":\"Dimension\"\n                      |        }\n                      |      }\n                      |    }\n                      |  ]\n                      |}")).stripMargin());
    }

    @Test
    public void testhasField() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("DB").where((Expressions.Expression)Expressions$.MODULE$.hasField("name")), this.g(), this.gp());
        this.validateJson(r, new StringOps(Predef$.MODULE$.augmentString("{\n                      |  \"query\":\"DB where DB has name\",\n                      |  \"dataType\":{\n                      |    \"superTypes\":[\n                      |\n                      |    ],\n                      |    \"hierarchicalMetaTypeName\":\"org.apache.atlas.typesystem.types.ClassType\",\n                      |    \"typeName\":\"DB\",\n                      |    \"attributeDefinitions\":[\n                      |      {\n                      |        \"name\":\"name\",\n                      |        \"dataTypeName\":\"string\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":0,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      },\n                      |      {\n                      |        \"name\":\"owner\",\n                      |        \"dataTypeName\":\"string\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":0,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      },\n                      |      {\n                      |        \"name\":\"createTime\",\n                      |        \"dataTypeName\":\"int\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":0,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      },\n                      |      {\n                      |        \"name\":\"clusterName\",\n                      |        \"dataTypeName\":\"string\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":0,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      }\n                      |    ]\n                      |  },\n                      |  \"rows\":[\n                      |    {\n                      |      \"$typeName$\":\"DB\",\n                      |      \"$id$\":{\n                      |        \"$typeName$\":\"DB\",\n                      |        \"version\":0\n                      |      },\n                      |      \"owner\":\"John ETL\",\n                      |      \"name\":\"Sales\",\n                      |      \"createTime\":1000,\n                      |      \"clusterName\":\"test\"\n                      |    },\n                      |    {\n                      |      \"$typeName$\":\"DB\",\n                      |      \"$id$\":{\n                      |        \"$typeName$\":\"DB\",\n                      |        \"version\":0\n                      |      },\n                      |      \"owner\":\"Jane BI\",\n                      |      \"name\":\"Reporting\",\n                      |      \"createTime\":1500,\n                      |      \"clusterName\":\"test\"\n                      |    }\n                      |  ]\n                      |}")).stripMargin());
    }

    @Test
    public void testFieldReference() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("DB").field("Table"), this.g(), this.gp());
        this.validateJson(r, new StringOps(Predef$.MODULE$.augmentString("{\n                      |  \"query\":\"DB Table\",\n                      |  \"dataType\":{\n                      |    \"superTypes\":[      ],\n                      |    \"hierarchicalMetaTypeName\":\"org.apache.atlas.typesystem.types.ClassType\",\n                      |    \"typeName\":\"Table\",\n                      |    \"attributeDefinitions\":[\n                      |      {\n                      |        \"name\":\"name\",\n                      |        \"dataTypeName\":\"string\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":0,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      },\n                      |      {\n                      |        \"name\":\"db\",\n                      |        \"dataTypeName\":\"DB\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":1,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      },\n                      |      {\n                      |        \"name\":\"sd\",\n                      |        \"dataTypeName\":\"StorageDescriptor\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":1,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      },\n                      |      {\n                      |        \"name\":\"created\",\n                      |        \"dataTypeName\":\"date\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":0,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      }\n                      |    ]\n                      |  },\n                      |  \"rows\":[\n                      |    {\n                      |      \"$typeName$\":\"Table\",\n                      |      \"$id$\":{\n                      |        \"$typeName$\":\"Table\",\n                      |        \"version\":0\n                      |      },\n                      |      \"created\":\"2014-12-11T02:35:58.440Z\",\n                      |      \"sd\":{\n                      |        \"$typeName$\":\"StorageDescriptor\",\n                      |        \"version\":0\n                      |      },\n                      |      \"db\":{\n                      |        \"$typeName$\":\"DB\",\n                      |        \"version\":0\n                      |      },\n                      |      \"name\":\"sales_fact\"\n                      |    },\n                      |    {\n                      |      \"$typeName$\":\"Table\",\n                      |      \"$id$\":{\n                      |        \"$typeName$\":\"Table\",\n                      |        \"version\":0\n                      |      },\n                      |      \"created\":\"2014-12-11T02:35:58.440Z\",\n                      |      \"sd\":{\n                      |        \"$typeName$\":\"StorageDescriptor\",\n                      |        \"version\":0\n                      |      },\n                      |      \"db\":{\n                      |        \"$typeName$\":\"DB\",\n                      |        \"version\":0\n                      |      },\n                      |      \"name\":\"product_dim\",\n                      |      \"$traits$\":{\n                      |        \"Dimension\":{\n                      |          \"$typeName$\":\"Dimension\"\n                      |        }\n                      |      }\n                      |    },\n                      |    {\n                      |      \"$typeName$\":\"Table\",\n                      |      \"$id$\":{\n                      |        \"$typeName$\":\"Table\",\n                      |        \"version\":0\n                      |      },\n                      |      \"created\":\"2014-12-11T02:35:58.440Z\",\n                      |      \"sd\":{\n                      |        \"$typeName$\":\"StorageDescriptor\",\n                      |        \"version\":0\n                      |      },\n                      |      \"db\":{\n                      |        \"$typeName$\":\"DB\",\n                      |        \"version\":0\n                      |      },\n                      |      \"name\":\"time_dim\",\n                      |      \"$traits$\":{\n                      |        \"Dimension\":{\n                      |          \"$typeName$\":\"Dimension\"\n                      |        }\n                      |      }\n                      |    },\n                      |    {\n                      |      \"$typeName$\":\"Table\",\n                      |      \"$id$\":{\n                      |        \"$typeName$\":\"Table\",\n                      |        \"version\":0\n                      |      },\n                      |      \"created\":\"2014-12-11T02:35:58.440Z\",\n                      |      \"sd\":{\n                      |        \"$typeName$\":\"StorageDescriptor\",\n                      |        \"version\":0\n                      |      },\n                      |      \"db\":{\n                      |        \"$typeName$\":\"DB\",\n                      |        \"version\":0\n                      |      },\n                      |      \"name\":\"customer_dim\",\n                      |      \"$traits$\":{\n                      |        \"Dimension\":{\n                      |          \"$typeName$\":\"Dimension\"\n                      |        }\n                      |      }\n                      |    },\n                      |    {\n                      |      \"$typeName$\":\"Table\",\n                      |      \"$id$\":{\n                      |        \"$typeName$\":\"Table\",\n                      |        \"version\":0\n                      |      },\n                      |      \"created\":\"2014-12-11T02:35:58.440Z\",\n                      |      \"sd\":{\n                      |        \"$typeName$\":\"StorageDescriptor\",\n                      |        \"version\":0\n                      |      },\n                      |      \"db\":{\n                      |        \"$typeName$\":\"DB\",\n                      |        \"version\":0\n                      |      },\n                      |      \"name\":\"sales_fact_daily_mv\"\n                      |    },\n                      |    {\n                      |      \"$typeName$\":\"Table\",\n                      |      \"$id$\":{\n                      |        \"$typeName$\":\"Table\",\n                      |        \"version\":0\n                      |      },\n                      |      \"created\":\"2014-12-11T02:35:58.440Z\",\n                      |      \"sd\":{\n                      |        \"$typeName$\":\"StorageDescriptor\",\n                      |        \"version\":0\n                      |      },\n                      |      \"db\":{\n                      |        \"$typeName$\":\"DB\",\n                      |        \"version\":0\n                      |      },\n                      |      \"name\":\"sales_fact_monthly_mv\"\n                      |    }\n                      |  ]\n                      |}")).stripMargin());
    }

    @Test
    public void testBackReference() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("DB").as("db").field("Table").where((Expressions.Expression)Expressions$.MODULE$.id("db").field("name").$eq().apply((Object)Expressions$.MODULE$.string((Object)"Reporting"))), this.g(), this.gp());
        this.validateJson(r, null);
    }

    @Test
    public void testArith() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("DB").where((Expressions.Expression)Expressions$.MODULE$.id("name").$eq().apply((Object)Expressions$.MODULE$.string((Object)"Reporting"))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expressions.Expression[]{Expressions$.MODULE$.id("name"), (Expressions.Expression)Expressions$.MODULE$.id("createTime").$plus().apply((Object)Expressions$.MODULE$.int((Object)BoxesRunTime.boxToInteger((int)1)))})), this.g(), this.gp());
        this.validateJson(r, "{\n  \"query\":\"DB where (name = \\\"Reporting\\\") as _src1 select _src1.name as _src1.name, (_src1.createTime + 1) as (_src1.createTime + 1)\",\n  \"dataType\":{\n    \"typeName\":\"__tempQueryResultStruct3\",\n    \"attributeDefinitions\":[\n      {\n        \"name\":\"_src1.name\",\n        \"dataTypeName\":\"string\",\n        \"multiplicity\":{\n          \"lower\":0,\n          \"upper\":1,\n          \"isUnique\":false\n        },\n        \"isComposite\":false,\n        \"isUnique\":false,\n        \"isIndexable\":false,\n        \"reverseAttributeName\":null\n      },\n      {\n        \"name\":\"(_src1.createTime + 1)\",\n        \"dataTypeName\":\"int\",\n        \"multiplicity\":{\n          \"lower\":0,\n          \"upper\":1,\n          \"isUnique\":false\n        },\n        \"isComposite\":false,\n        \"isUnique\":false,\n        \"isIndexable\":false,\n        \"reverseAttributeName\":null\n      }\n    ]\n  },\n  \"rows\":[\n    {\n      \"$typeName$\":\"__tempQueryResultStruct3\",\n      \"(_src1.createTime + 1)\":1501,\n      \"_src1.name\":\"Reporting\"\n    }\n  ]\n}");
    }

    @Test
    public void testComparisonLogical() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("DB").where((Expressions.Expression)((Expressions.Expression)Expressions$.MODULE$.id("name").$eq().apply((Object)Expressions$.MODULE$.string((Object)"Reporting"))).and().apply(Expressions$.MODULE$.id("createTime").$greater().apply((Object)Expressions$.MODULE$.int((Object)BoxesRunTime.boxToInteger((int)0))))), this.g(), this.gp());
        this.validateJson(r, new StringOps(Predef$.MODULE$.augmentString("{\n                      |    \"query\": \"DB where (name = \\\"Reporting\\\") and (createTime > 0)\",\n                      |    \"dataType\": {\n                      |        \"superTypes\": [\n                      |\n                      |        ],\n                      |        \"hierarchicalMetaTypeName\": \"org.apache.atlas.typesystem.types.ClassType\",\n                      |        \"typeName\": \"DB\",\n                      |        \"attributeDefinitions\": [\n                      |            {\n                      |                \"name\": \"name\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |                \"isComposite\": false,\n                      |                \"isUnique\": false,\n                      |                \"isIndexable\": false,\n                      |                \"reverseAttributeName\": null\n                      |            },\n                      |            {\n                      |                \"name\": \"owner\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |                \"isComposite\": false,\n                      |                \"isUnique\": false,\n                      |                \"isIndexable\": false,\n                      |                \"reverseAttributeName\": null\n                      |            },\n                      |            {\n                      |                \"name\": \"createTime\",\n                      |                \"dataTypeName\": \"int\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |                \"isComposite\": false,\n                      |                \"isUnique\": false,\n                      |                \"isIndexable\": false,\n                      |                \"reverseAttributeName\": null\n                      |            },\n                      |            {\n                      |                \"name\": \"clusterName\",\n                      |                \"dataTypeName\": \"string\",\n                      |                \"multiplicity\": {\n                      |                    \"lower\": 0,\n                      |                    \"upper\": 1,\n                      |                    \"isUnique\": false\n                      |                },\n                      |               \"isComposite\": false,\n                      |               \"isUnique\": false,\n                      |               \"isIndexable\": false,\n                      |               \"reverseAttributeName\": null\n                      |            }\n                      |        ]\n                      |    },\n                      |    \"rows\": [\n                      |        {\n                      |            \"$typeName$\": \"DB\",\n                      |            \"$id$\": {\n                      |                \"$typeName$\": \"DB\",\n                      |                \"version\": 0\n                      |            },\n                      |            \"owner\": \"Jane BI\",\n                      |            \"name\": \"Reporting\",\n                      |            \"createTime\": 1500,\n                      |            \"clusterName\": \"test\"\n                      |        }\n                      |    ]\n                      |}")).stripMargin());
    }

    @Test
    public void testJoinAndSelect1() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("DB").as("db1").where((Expressions.Expression)Expressions$.MODULE$.id("name").$eq().apply((Object)Expressions$.MODULE$.string((Object)"Sales"))).field("Table").as("tab").where((Expressions.Expression)Expressions$.MODULE$.isTrait("Dimension")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expressions.Expression[]{Expressions$.MODULE$.id("db1").field("name").as("dbName"), Expressions$.MODULE$.id("tab").field("name").as("tabName")})), this.g(), this.gp());
        this.validateJson(r, "{\n  \"query\":\"DB as db1 where (name = \\\"Sales\\\") Table as tab where DB as db1 where (name = \\\"Sales\\\") Table as tab is Dimension as _src1 select db1.name as dbName, tab.name as tabName\",\n  \"dataType\":{\n    \"typeName\":\"__tempQueryResultStruct5\",\n    \"attributeDefinitions\":[\n      {\n        \"name\":\"dbName\",\n        \"dataTypeName\":\"string\",\n        \"multiplicity\":{\n          \"lower\":0,\n          \"upper\":1,\n          \"isUnique\":false\n        },\n        \"isComposite\":false,\n        \"isUnique\":false,\n        \"isIndexable\":false,\n        \"reverseAttributeName\":null\n      },\n      {\n        \"name\":\"tabName\",\n        \"dataTypeName\":\"string\",\n        \"multiplicity\":{\n          \"lower\":0,\n          \"upper\":1,\n          \"isUnique\":false\n        },\n        \"isComposite\":false,\n        \"isUnique\":false,\n        \"isIndexable\":false,\n        \"reverseAttributeName\":null\n      }\n    ]\n  },\n  \"rows\":[\n    {\n      \"$typeName$\":\"__tempQueryResultStruct5\",\n      \"dbName\":\"Sales\",\n      \"tabName\":\"product_dim\"\n    },\n    {\n      \"$typeName$\":\"__tempQueryResultStruct5\",\n      \"dbName\":\"Sales\",\n      \"tabName\":\"time_dim\"\n    },\n    {\n      \"$typeName$\":\"__tempQueryResultStruct5\",\n      \"dbName\":\"Sales\",\n      \"tabName\":\"customer_dim\"\n    }\n  ]\n}");
    }

    @Test
    public void testJoinAndSelect2() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("DB").as("db1").where((Expressions.Expression)((Expressions.Expression)Expressions$.MODULE$.id("db1").field("createTime").$greater().apply((Object)Expressions$.MODULE$.int((Object)BoxesRunTime.boxToInteger((int)0)))).or().apply(Expressions$.MODULE$.id("name").$eq().apply((Object)Expressions$.MODULE$.string((Object)"Reporting")))).field("Table").as("tab").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expressions.Expression[]{Expressions$.MODULE$.id("db1").field("name").as("dbName"), Expressions$.MODULE$.id("tab").field("name").as("tabName")})), this.g(), this.gp());
        this.validateJson(r, "{\n  \"query\":\"DB as db1 where (db1.createTime > 0) or (name = \\\"Reporting\\\") Table as tab select db1.name as dbName, tab.name as tabName\",\n  \"dataType\":{\n    \"typeName\":\"__tempQueryResultStruct6\",\n    \"attributeDefinitions\":[\n      {\n        \"name\":\"dbName\",\n        \"dataTypeName\":\"string\",\n        \"multiplicity\":{\n          \"lower\":0,\n          \"upper\":1,\n          \"isUnique\":false\n        },\n        \"isComposite\":false,\n        \"isUnique\":false,\n        \"isIndexable\":false,\n        \"reverseAttributeName\":null\n      },\n      {\n        \"name\":\"tabName\",\n        \"dataTypeName\":\"string\",\n        \"multiplicity\":{\n          \"lower\":0,\n          \"upper\":1,\n          \"isUnique\":false\n        },\n        \"isComposite\":false,\n        \"isUnique\":false,\n        \"isIndexable\":false,\n        \"reverseAttributeName\":null\n      }\n    ]\n  },\n  \"rows\":[\n    {\n      \"$typeName$\":\"__tempQueryResultStruct6\",\n      \"dbName\":\"Sales\",\n      \"tabName\":\"sales_fact\"\n    },\n    {\n      \"$typeName$\":\"__tempQueryResultStruct6\",\n      \"dbName\":\"Sales\",\n      \"tabName\":\"product_dim\"\n    },\n    {\n      \"$typeName$\":\"__tempQueryResultStruct6\",\n      \"dbName\":\"Sales\",\n      \"tabName\":\"time_dim\"\n    },\n    {\n      \"$typeName$\":\"__tempQueryResultStruct6\",\n      \"dbName\":\"Sales\",\n      \"tabName\":\"customer_dim\"\n    },\n    {\n      \"$typeName$\":\"__tempQueryResultStruct6\",\n      \"dbName\":\"Reporting\",\n      \"tabName\":\"sales_fact_daily_mv\"\n    },\n    {\n      \"$typeName$\":\"__tempQueryResultStruct6\",\n      \"dbName\":\"Reporting\",\n      \"tabName\":\"sales_fact_monthly_mv\"\n    }\n  ]\n}");
    }

    @Test
    public void testJoinAndSelect3() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("DB").as("db1").where((Expressions.Expression)((Expressions.Expression)((Expressions.Expression)Expressions$.MODULE$.id("db1").field("createTime").$greater().apply((Object)Expressions$.MODULE$.int((Object)BoxesRunTime.boxToInteger((int)0)))).and().apply(Expressions$.MODULE$.id("db1").field("name").$eq().apply((Object)Expressions$.MODULE$.string((Object)"Reporting")))).or().apply((Object)Expressions$.MODULE$.id("db1").hasField("owner"))).field("Table").as("tab").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expressions.Expression[]{Expressions$.MODULE$.id("db1").field("name").as("dbName"), Expressions$.MODULE$.id("tab").field("name").as("tabName")})), this.g(), this.gp());
        this.validateJson(r, "{\n  \"query\":\"DB as db1 where (db1.createTime > 0) and (db1.name = \\\"Reporting\\\") or db1 has owner Table as tab select db1.name as dbName, tab.name as tabName\",\n  \"dataType\":{\n    \"typeName\":\"__tempQueryResultStruct7\",\n    \"attributeDefinitions\":[\n      {\n        \"name\":\"dbName\",\n        \"dataTypeName\":\"string\",\n        \"multiplicity\":{\n          \"lower\":0,\n          \"upper\":1,\n          \"isUnique\":false\n        },\n        \"isComposite\":false,\n        \"isUnique\":false,\n        \"isIndexable\":false,\n        \"reverseAttributeName\":null\n      },\n      {\n        \"name\":\"tabName\",\n        \"dataTypeName\":\"string\",\n        \"multiplicity\":{\n          \"lower\":0,\n          \"upper\":1,\n          \"isUnique\":false\n        },\n        \"isComposite\":false,\n        \"isUnique\":false,\n        \"isIndexable\":false,\n        \"reverseAttributeName\":null\n      }\n    ]\n  },\n  \"rows\":[\n    {\n      \"$typeName$\":\"__tempQueryResultStruct7\",\n      \"dbName\":\"Sales\",\n      \"tabName\":\"sales_fact\"\n    },\n    {\n      \"$typeName$\":\"__tempQueryResultStruct7\",\n      \"dbName\":\"Sales\",\n      \"tabName\":\"product_dim\"\n    },\n    {\n      \"$typeName$\":\"__tempQueryResultStruct7\",\n      \"dbName\":\"Sales\",\n      \"tabName\":\"time_dim\"\n    },\n    {\n      \"$typeName$\":\"__tempQueryResultStruct7\",\n      \"dbName\":\"Sales\",\n      \"tabName\":\"customer_dim\"\n    },\n    {\n      \"$typeName$\":\"__tempQueryResultStruct7\",\n      \"dbName\":\"Reporting\",\n      \"tabName\":\"sales_fact_daily_mv\"\n    },\n    {\n      \"$typeName$\":\"__tempQueryResultStruct7\",\n      \"dbName\":\"Reporting\",\n      \"tabName\":\"sales_fact_monthly_mv\"\n    }\n  ]\n}");
    }

    @Test
    public void testJoinAndSelect4() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("DB").as("db1").where((Expressions.Expression)Expressions$.MODULE$.id("name").$eq().apply((Object)Expressions$.MODULE$.string((Object)"Sales"))).field("Table").as("tab").where((Expressions.Expression)Expressions$.MODULE$.isTrait("Dimension")).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expressions.Expression[]{Expressions$.MODULE$.id("db1").as("dbO"), Expressions$.MODULE$.id("tab").field("name").as("tabName")})), this.g(), this.gp());
        this.validateJson(r, "{\n  \"query\":\"DB as db1 where (name = \\\"Sales\\\") Table as tab where DB as db1 where (name = \\\"Sales\\\") Table as tab is Dimension as _src1 select db1 as dbO, tab.name as tabName\",\n  \"dataType\":{\n    \"typeName\":\"\",\n    \"attributeDefinitions\":[\n      {\n        \"name\":\"dbO\",\n        \"dataTypeName\":\"DB\",\n        \"multiplicity\":{\n          \"lower\":0,\n          \"upper\":1,\n          \"isUnique\":false\n        },\n        \"isComposite\":false,\n        \"isUnique\":false,\n        \"isIndexable\":false,\n        \"reverseAttributeName\":null\n      },\n      {\n        \"name\":\"tabName\",\n        \"dataTypeName\":\"string\",\n        \"multiplicity\":{\n          \"lower\":0,\n          \"upper\":1,\n          \"isUnique\":false\n        },\n        \"isComposite\":false,\n        \"isUnique\":false,\n        \"isIndexable\":false,\n        \"reverseAttributeName\":null\n      }\n    ]\n  },\n  \"rows\":[\n    {\n      \"$typeName$\":\"\",\n      \"dbO\":{\n        \"$typeName$\":\"DB\",\n        \"version\":0\n      },\n      \"tabName\":\"product_dim\"\n    },\n    {\n      \"$typeName$\":\"\",\n      \"dbO\":{\n        \"$typeName$\":\"DB\",\n        \"version\":0\n      },\n      \"tabName\":\"time_dim\"\n    },\n    {\n      \"$typeName$\":\"\",\n      \"dbO\":{\n        \"$typeName$\":\"DB\",\n        \"version\":0\n      },\n      \"tabName\":\"customer_dim\"\n    }\n  ]\n}");
    }

    @Test
    public void testArrayComparision() {
        QueryParser$ p = QueryParser$.MODULE$;
        String x$1 = "Partition as p where values = ['2015-01-01'], table where name = 'sales_fact_daily_mv', db where name = 'Reporting' and clusterName = 'test' select p";
        QueryParams x$2 = p.apply$default$2(x$1);
        Expressions.Expression e = (Expressions.Expression)p.apply(x$1, x$2).right().get();
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate(e, this.g(), this.gp());
        this.validateJson(r, new StringOps(Predef$.MODULE$.augmentString("{\n                      |  \"query\":\"Partition as p where (values = [\\\"2015-01-01\\\"]) table where (name = \\\"sales_fact_daily_mv\\\") db where (name = \\\"Reporting\\\") and (clusterName = \\\"test\\\") as _src1 select p as p\",\n                      |  \"dataType\":{\n                      |    \"typeName\":\"__tempQueryResultStruct2\",\n                      |    \"attributeDefinitions\":[\n                      |      {\n                      |        \"name\":\"p\",\n                      |        \"dataTypeName\":\"Partition\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":0,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      }\n                      |    ]\n                      |  },\n                      |  \"rows\":[\n                      |    {\n                      |      \"$typeName$\":\"__tempQueryResultStruct2\",\n                      |      \"p\":{\n                      |        \"$typeName$\":\"Partition\",\n                      |        \"version\":0\n                      |      }\n                      |    }\n                      |  ]\n                      |}")).stripMargin());
    }

    @Test
    public void testArrayComparisionWithSelectOnArray() {
        QueryParser$ p = QueryParser$.MODULE$;
        String x$3 = "Partition as p where values = ['2015-01-01'], table where name = 'sales_fact_daily_mv', db where name = 'Reporting' and clusterName = 'test' select p.values";
        QueryParams x$4 = p.apply$default$2(x$3);
        Expressions.Expression e = (Expressions.Expression)p.apply(x$3, x$4).right().get();
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate(e, this.g(), this.gp());
        this.validateJson(r, new StringOps(Predef$.MODULE$.augmentString("{\n        |  \"query\":\"Partition as p where (values = [\\\"2015-01-01\\\"]) table where (name = \\\"sales_fact_daily_mv\\\") db where (name = \\\"Reporting\\\") and (clusterName = \\\"test\\\") as _src1 select p.values as p.values\",\n        |  \"dataType\":{\n        |    \"typeName\":\"__tempQueryResultStruct2\",\n        |    \"attributeDefinitions\":[\n        |  {\n        |    \"name\":\"p.values\",\n        |    \"dataTypeName\":\"array<string>\",\n        |    \"multiplicity\":{\n        |    \"lower\":0,\n        |    \"upper\":1,\n        |    \"isUnique\":false\n        |  },\n        |    \"isComposite\":false,\n        |    \"isUnique\":false,\n        |    \"isIndexable\":false,\n        |    \"reverseAttributeName\":null\n        |  }\n        |    ]\n        |  },\n        |  \"rows\":[\n        |  {\n        |    \"$typeName$\":\"__tempQueryResultStruct2\",\n        |    \"p.values\":[\n        |    \"2015-01-01\"\n        |    ]\n        |  }\n        |  ]\n        |}\n      ")).stripMargin());
    }

    @Test
    public void testArrayInWhereClause() {
        QueryParser$ p = QueryParser$.MODULE$;
        String x$5 = "Partition as p where values = ['2015-01-01']";
        QueryParams x$6 = p.apply$default$2(x$5);
        Expressions.Expression e = (Expressions.Expression)p.apply(x$5, x$6).right().get();
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate(e, this.g(), this.gp());
        this.validateJson(r, new StringOps(Predef$.MODULE$.augmentString("{\n                      |  \"query\":\"Partition as p where (values = [\\\"2015-01-01\\\"])\",\n                      |  \"dataType\":{\n                      |    \"superTypes\":[\n                      |\n                      |    ],\n                      |    \"hierarchicalMetaTypeName\":\"org.apache.atlas.typesystem.types.ClassType\",\n                      |    \"typeName\":\"Partition\",\n                      |    \"attributeDefinitions\":[\n                      |      {\n                      |        \"name\":\"values\",\n                      |        \"dataTypeName\":\"array<string>\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":1,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      },\n                      |      {\n                      |        \"name\":\"table\",\n                      |        \"dataTypeName\":\"Table\",\n                      |        \"multiplicity\":{\n                      |          \"lower\":1,\n                      |          \"upper\":1,\n                      |          \"isUnique\":false\n                      |        },\n                      |        \"isComposite\":false,\n                      |        \"isUnique\":false,\n                      |        \"isIndexable\":false,\n                      |        \"reverseAttributeName\":null\n                      |      }\n                      |    ]\n                      |  },\n                      |  \"rows\":[\n                      |    {\n                      |      \"$typeName$\":\"Partition\",\n                      |      \"$id$\":{\n                      |        \"$typeName$\":\"Partition\",\n                      |        \"version\":0\n                      |      },\n                      |      \"values\":[\n                      |        \"2015-01-01\"\n                      |      ],\n                      |      \"table\":{\n                      |        \"$typeName$\":\"Table\",\n                      |        \"version\":0\n                      |      }\n                      |    }\n                      |  ]\n                      |}")).stripMargin());
    }

    @Test
    public void testArrayWithStruct() {
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate((Expressions.Expression)Expressions$.MODULE$._class("LoadProcess").field("inputTables"), this.g(), this.gp());
        this.validateJson(r, this.validateJson$default$2());
    }

    @Test(expectedExceptions={Expressions.ExpressionException.class})
    public void testNegativeInvalidType() {
        QueryParser$ p = QueryParser$.MODULE$;
        String x$7 = "from blah";
        QueryParams x$8 = p.apply$default$2(x$7);
        Expressions.Expression e = (Expressions.Expression)p.apply(x$7, x$8).right().get();
        QueryProcessor$.MODULE$.evaluate(e, this.g(), this.gp());
    }

    @Test
    public void testJoinAndSelect5() {
        QueryParser$ p = QueryParser$.MODULE$;
        String x$9 = "Table as t where name = 'sales_fact' db where name = 'Sales' and owner = 'John ETL' select t";
        QueryParams x$10 = p.apply$default$2(x$9);
        Expressions.Expression e = (Expressions.Expression)p.apply(x$9, x$10).right().get();
        GremlinQueryResult r = QueryProcessor$.MODULE$.evaluate(e, this.g(), this.gp());
        this.validateJson(r, this.validateJson$default$2());
    }

    public GremlinTest() {
        BaseGremlinTest$class.$init$(this);
        this.g = null;
        this.gp = null;
        this.gProvider = null;
    }
}

