/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.discovery;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.atlas.AtlasException;
import org.apache.atlas.BaseRepositoryTest;
import org.apache.atlas.RepositoryMetadataModule;
import org.apache.atlas.RequestContext;
import org.apache.atlas.TestUtils;
import org.apache.atlas.discovery.DiscoveryException;
import org.apache.atlas.discovery.graph.GraphBackedDiscoveryService;
import org.apache.atlas.query.QueryParams;
import org.apache.atlas.repository.MetadataRepository;
import org.apache.atlas.repository.graph.GraphBackedSearchIndexer;
import org.apache.atlas.repository.graph.GraphProvider;
import org.apache.atlas.repository.graph.TitanGraphProvider;
import org.apache.atlas.typesystem.ITypedReferenceableInstance;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.ClassType;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.TypeSystem;
import org.apache.atlas.typesystem.types.utils.TypesUtil;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Guice(modules={RepositoryMetadataModule.class})
public class GraphBackedDiscoveryServiceTest
extends BaseRepositoryTest {
    @Inject
    private MetadataRepository repositoryService;
    @Inject
    private GraphBackedDiscoveryService discoveryService;
    private QueryParams queryParams = new QueryParams(40, 0);

    @Override
    @BeforeClass
    public void setUp() throws Exception {
        super.setUp();
        TypeSystem typeSystem = TypeSystem.getInstance();
        HashSet<String> oldTypeNames = new HashSet<String>();
        oldTypeNames.addAll((Collection<String>)typeSystem.getTypeNames());
        TestUtils.defineDeptEmployeeTypes(typeSystem);
        this.addIndexesForNewTypes(oldTypeNames, typeSystem);
        ITypedReferenceableInstance hrDept = TestUtils.createDeptEg1(typeSystem);
        this.repositoryService.createEntities(new ITypedReferenceableInstance[]{hrDept});
        ITypedReferenceableInstance jane = this.repositoryService.getEntityDefinition("Manager", "name", (Object)"Jane");
        Id janeGuid = jane.getId();
        ClassType personType = (ClassType)typeSystem.getDataType(ClassType.class, "Person");
        ITypedReferenceableInstance instance = personType.createInstance(janeGuid, new String[0]);
        instance.set("orgLevel", (Object)"L1");
        this.repositoryService.updatePartial(instance);
    }

    private void addIndexesForNewTypes(Collection<String> oldTypeNames, TypeSystem typeSystem) throws AtlasException {
        HashSet newTypeNames = new HashSet();
        newTypeNames.addAll(typeSystem.getTypeNames());
        newTypeNames.removeAll(oldTypeNames);
        ArrayList<Object> newTypes = new ArrayList<Object>();
        for (String name : newTypeNames) {
            try {
                newTypes.add(typeSystem.getDataType(IDataType.class, name));
            }
            catch (AtlasException e) {
                e.printStackTrace();
            }
        }
        TitanGraphProvider provider = new TitanGraphProvider();
        provider.get().commit();
        GraphBackedSearchIndexer idx = new GraphBackedSearchIndexer((GraphProvider)provider);
        idx.onAdd(newTypes);
    }

    @BeforeMethod
    public void setupContext() {
        RequestContext.createContext();
    }

    @Override
    @AfterClass
    public void tearDown() throws Exception {
        super.tearDown();
    }

    private String searchByDSL(String dslQuery) throws Exception {
        return this.discoveryService.searchByDSL(dslQuery, this.queryParams);
    }

    @Test
    public void testSearchBySystemProperties() throws Exception {
        String dslQuery = "from Department select __guid";
        String jsonResults = this.searchByDSL(dslQuery);
        Assert.assertNotNull((Object)jsonResults);
        JSONObject results = new JSONObject(jsonResults);
        Assert.assertEquals((int)results.length(), (int)3);
        JSONArray rows = results.getJSONArray("rows");
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((int)rows.length(), (int)1);
        Assert.assertNotNull((Object)rows.getJSONObject(0).getString("__guid"));
        String guid = rows.getJSONObject(0).getString("__guid");
        dslQuery = "Department where __guid = '" + guid + "' and __state = 'ACTIVE'";
        jsonResults = this.searchByDSL(dslQuery);
        Assert.assertNotNull((Object)jsonResults);
        results = new JSONObject(jsonResults);
        Assert.assertEquals((int)results.length(), (int)3);
        rows = results.getJSONArray("rows");
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((int)rows.length(), (int)1);
        String testTs = "\"2011-11-01T02:35:58.440Z\"";
        dslQuery = "Department where __timestamp > \"2011-11-01T02:35:58.440Z\"";
        jsonResults = this.searchByDSL(dslQuery);
        Assert.assertNotNull((Object)jsonResults);
        results = new JSONObject(jsonResults);
        Assert.assertEquals((int)results.length(), (int)3);
        rows = results.getJSONArray("rows");
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((int)rows.length(), (int)1);
        dslQuery = "Department where __modificationTimestamp > \"2011-11-01T02:35:58.440Z\"";
        jsonResults = this.searchByDSL(dslQuery);
        Assert.assertNotNull((Object)jsonResults);
        results = new JSONObject(jsonResults);
        Assert.assertEquals((int)results.length(), (int)3);
        rows = results.getJSONArray("rows");
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((int)rows.length(), (int)1);
    }

    @Test
    public void testSearchByDSLReturnsEntity() throws Exception {
        String dslQuery = "from Department";
        String jsonResults = this.searchByDSL(dslQuery);
        Assert.assertNotNull((Object)jsonResults);
        JSONObject results = new JSONObject(jsonResults);
        Assert.assertEquals((int)results.length(), (int)3);
        System.out.println("results = " + results);
        Object query = results.get("query");
        Assert.assertNotNull((Object)query);
        JSONObject dataType = results.getJSONObject("dataType");
        Assert.assertNotNull((Object)dataType);
        String typeName = dataType.getString("typeName");
        Assert.assertNotNull((Object)typeName);
        Assert.assertEquals((String)typeName, (String)"Department");
        JSONArray rows = results.getJSONArray("rows");
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((int)rows.length(), (int)1);
        String entityState = rows.getJSONObject(0).getJSONObject("$id$").getString("state");
        Assert.assertEquals((String)entityState, (String)Id.EntityState.ACTIVE.name());
    }

    @Test(expectedExceptions={Throwable.class})
    public void testSearchByDSLBadQuery() throws Exception {
        String dslQuery = "from blah";
        this.searchByDSL(dslQuery);
        Assert.fail();
    }

    @Test
    public void testRawSearch1() throws Exception {
        List r = this.discoveryService.searchByGremlin("g.V.toList()");
        Assert.assertTrue((boolean)(r instanceof List));
        List resultList = r;
        Assert.assertTrue((resultList.size() > 0 ? 1 : 0) != 0);
        System.out.println("search result = " + r);
        r = this.discoveryService.searchByGremlin("g.V.filter{it.__typeName == 'Department'}.toList()");
        Assert.assertTrue((boolean)(r instanceof List));
        resultList = r;
        Assert.assertTrue((resultList.size() > 0 ? 1 : 0) != 0);
        System.out.println("search result = " + r);
        r = this.discoveryService.searchByGremlin("g.V.filter{it.__typeName == 'Person'}.'Person.name'.toList()");
        Assert.assertTrue((boolean)(r instanceof List));
        resultList = r;
        Assert.assertTrue((resultList.size() > 0 ? 1 : 0) != 0);
        System.out.println("search result = " + r);
        ArrayList names = new ArrayList(resultList.size());
        for (Map vertexProps : resultList) {
            names.addAll(vertexProps.values());
        }
        for (String name : Arrays.asList("John", "Max")) {
            Assert.assertTrue((boolean)names.contains(name));
        }
        r = this.discoveryService.searchByGremlin("g.V.filter{it.__modificationTimestamp > 1420070400000}.toList()");
        Assert.assertTrue((boolean)(r instanceof List));
        resultList = r;
        Assert.assertTrue((resultList.size() > 0 ? 1 : 0) != 0);
        for (Map vertexProps : resultList) {
            Object object = vertexProps.get("__modificationTimestamp");
            Assert.assertNotNull(object);
            Long timestampAsLong = Long.valueOf((String)object);
            Assert.assertTrue((timestampAsLong > 1420070400000L ? 1 : 0) != 0);
            object = vertexProps.get("__timestamp");
            Assert.assertNotNull(object);
        }
    }

    @DataProvider(name="comparisonQueriesProvider")
    private Object[][] createComparisonQueries() {
        return new Object[][]{{"Person where (birthday < \"1950-01-01T02:35:58.440Z\" )", 0}, {"Person where (birthday > \"1975-01-01T02:35:58.440Z\" )", 2}, {"Person where (birthday >= \"1975-01-01T02:35:58.440Z\" )", 2}, {"Person where (birthday <= \"1950-01-01T02:35:58.440Z\" )", 0}, {"Person where (birthday = \"1975-01-01T02:35:58.440Z\" )", 0}, {"Person where (birthday != \"1975-01-01T02:35:58.440Z\" )", 4}, {"Person where (hasPets = true)", 2}, {"Person where (hasPets = false)", 2}, {"Person where (hasPets != false)", 2}, {"Person where (hasPets != true)", 2}, {"Person where (numberOfCars > 0)", 2}, {"Person where (numberOfCars > 1)", 1}, {"Person where (numberOfCars >= 1)", 2}, {"Person where (numberOfCars < 2)", 3}, {"Person where (numberOfCars <= 2)", 4}, {"Person where (numberOfCars = 2)", 1}, {"Person where (numberOfCars != 2)", 3}, {"Person where (houseNumber > 0)", 2}, {"Person where (houseNumber > 17)", 1}, {"Person where (houseNumber >= 17)", 2}, {"Person where (houseNumber < 153)", 3}, {"Person where (houseNumber <= 153)", 4}, {"Person where (houseNumber =  17)", 1}, {"Person where (houseNumber != 17)", 3}, {"Person where (carMileage > 0)", 2}, {"Person where (carMileage > 13)", 1}, {"Person where (carMileage >= 13)", 2}, {"Person where (carMileage < 13364)", 3}, {"Person where (carMileage <= 13364)", 4}, {"Person where (carMileage =  13)", 1}, {"Person where (carMileage != 13)", 3}, {"Person where (shares > 0)", 2}, {"Person where (shares > 13)", 2}, {"Person where (shares >= 16000)", 1}, {"Person where (shares < 13364)", 2}, {"Person where (shares <= 15000)", 3}, {"Person where (shares =  15000)", 1}, {"Person where (shares != 1)", 4}, {"Person where (salary > 0)", 2}, {"Person where (salary > 100000)", 2}, {"Person where (salary >= 200000)", 1}, {"Person where (salary < 13364)", 2}, {"Person where (salary <= 150000)", 3}, {"Person where (salary =  12334)", 0}, {"Person where (salary != 12344)", 4}, {"Person where (age > 36)", 1}, {"Person where (age > 49)", 1}, {"Person where (age >= 49)", 1}, {"Person where (age < 50)", 3}, {"Person where (age <= 35)", 2}, {"Person where (age =  35)", 0}, {"Person where (age != 35)", 4}};
    }

    @DataProvider(name="dslQueriesProvider")
    private Object[][] createDSLQueries() {
        return new Object[][]{{"from hive_db", 3}, {"hive_db", 3}, {"hive_db where hive_db.name=\"Reporting\"", 1}, {"hive_db hive_db.name = \"Reporting\"", 1}, {"hive_db where hive_db.name=\"Reporting\" select name, owner", 1}, {"hive_db has name", 3}, {"hive_db, hive_table", 10}, {"View is JdbcAccess", 2}, {"hive_db as db1, hive_table where db1.name = \"Reporting\"", 0}, {"from hive_table", 10}, {"hive_table", 10}, {"hive_table isa Dimension", 3}, {"hive_column where hive_column isa PII", 8}, {"View is Dimension", 2}, {"hive_column select hive_column.name", 37}, {"hive_column select name", 37}, {"hive_column where hive_column.name=\"customer_id\"", 6}, {"from hive_table select hive_table.name", 10}, {"hive_db where (name = \"Reporting\")", 1}, {"hive_db where (name = \"Reporting\") select name as _col_0, owner as _col_1", 1}, {"hive_db where hive_db is JdbcAccess", 0}, {"hive_db hive_table", 10}, {"hive_db where hive_db has name", 3}, {"hive_db as db1 hive_table where (db1.name = \"Reporting\")", 0}, {"hive_db where (name = \"Reporting\") select name as _col_0, (createTime + 1) as _col_1 ", 1}, {"hive_table where (name = \"sales_fact\" and createTime > \"2014-01-01\" ) select name as _col_0, createTime as _col_1 ", 1}, {"hive_table where (name = \"sales_fact\" and createTime >= \"2014-12-11T02:35:58.440Z\" ) select name as _col_0, createTime as _col_1 ", 1}, {"Dimension", 5}, {"JdbcAccess", 2}, {"ETL", 5}, {"Metric", 9}, {"PII", 8}, {"`Log Data`", 4}, {"`isa`", 0}, {"hive_table where name='sales_fact', db where name='Sales'", 1}, {"hive_table where name='sales_fact', db where name='Reporting'", 0}, {"hive_partition as p where values = ['2015-01-01']", 1}, {"DataSet where name='sales_fact'", 1}, {"Asset where name='sales_fact'", 1}};
    }

    @DataProvider(name="dslExplicitLimitQueriesProvider")
    private Object[][] createDSLQueriesWithExplicitLimit() {
        return new Object[][]{{"hive_column", 37, 40, 0}, {"hive_column limit 10", 10, 50, 0}, {"hive_column select hive_column.name limit 10", 5, 5, 0}, {"hive_column select hive_column.name withPath", 20, 20, 0}, {"hive_column select hive_column.name limit 40 withPath", 17, 40, 20}, {"hive_column select hive_column.name limit 40 withPath", 0, 40, 40}, {"hive_column select hive_column.name limit 40 offset 10", 27, 40, 0}, {"hive_column select hive_column.name limit 40 offset 10", 17, 40, 10}, {"hive_db where name = 'Reporting' limit 10 offset 0", 1, 40, 0}, {"hive_db, hive_table where db.name = 'Reporting' limit 10", 1, 1, 0}, {"hive_column limit 25", 5, 10, 20}, {"hive_column limit 25", 0, 10, 30}};
    }

    @DataProvider(name="dslLimitQueriesProvider")
    private Object[][] createDSLQueriesWithLimit() {
        return new Object[][]{{"hive_column  limit 10 ", 10}, {"hive_column select hive_column.name limit 10 ", 10}, {"hive_column select hive_column.name  withPath", 37}, {"hive_column select hive_column.name limit 10 withPath", 10}, {"from hive_db", 3}, {"from hive_db limit 2", 2}, {"from hive_db limit 2 offset 0", 2}, {"from hive_db limit 2 offset 1", 2}, {"from hive_db limit 3 offset 1", 2}, {"hive_db", 3}, {"hive_db where hive_db.name=\"Reporting\"", 1}, {"hive_db where hive_db.name=\"Reporting\" limit 10 ", 1}, {"hive_db hive_db.name = \"Reporting\"", 1}, {"hive_db where hive_db.name=\"Reporting\" select name, owner", 1}, {"hive_db has name", 3}, {"hive_db has name limit 2 offset 0", 2}, {"hive_db has name limit 2 offset 1", 2}, {"hive_db has name limit 10 offset 1", 2}, {"hive_db has name limit 10 offset 0", 3}, {"hive_db, hive_table", 10}, {"hive_db, hive_table limit 5", 5}, {"hive_db, hive_table limit 5 offset 0", 5}, {"hive_db, hive_table limit 5 offset 5", 5}, {"View is JdbcAccess", 2}, {"View is JdbcAccess limit 1", 1}, {"View is JdbcAccess limit 2 offset 1", 1}, {"hive_db as db1, hive_table where db1.name = \"Reporting\"", 0}, {"from hive_table", 10}, {"from hive_table limit 5", 5}, {"from hive_table limit 5 offset 5", 5}, {"hive_table", 10}, {"hive_table limit 5", 5}, {"hive_table limit 5 offset 5", 5}, {"hive_table isa Dimension", 3}, {"hive_table isa Dimension limit 2", 2}, {"hive_table isa Dimension limit 2 offset 0", 2}, {"hive_table isa Dimension limit 2 offset 1", 2}, {"hive_table isa Dimension limit 3 offset 1", 2}, {"hive_column where hive_column isa PII", 8}, {"hive_column where hive_column isa PII limit 5", 5}, {"hive_column where hive_column isa PII limit 5 offset 1", 5}, {"hive_column where hive_column isa PII limit 5 offset 5", 3}, {"View is Dimension", 2}, {"View is Dimension limit 1", 1}, {"View is Dimension limit 1 offset 1", 1}, {"View is Dimension limit 10 offset 1", 1}, {"hive_column select hive_column.name", 37}, {"hive_column select hive_column.name limit 5", 5}, {"hive_column select hive_column.name limit 5 offset 36", 1}, {"hive_column select name", 37}, {"hive_column select name limit 5", 5}, {"hive_column select name limit 5 offset 36 ", 1}, {"hive_column where hive_column.name=\"customer_id\"", 6}, {"hive_column where hive_column.name=\"customer_id\" limit 2", 2}, {"hive_column where hive_column.name=\"customer_id\" limit 2 offset 1", 2}, {"hive_column where hive_column.name=\"customer_id\" limit 10 offset 3", 3}, {"from hive_table select hive_table.name", 10}, {"from hive_table select hive_table.name limit 5", 5}, {"from hive_table select hive_table.name limit 5 offset 5", 5}, {"hive_db where (name = \"Reporting\")", 1}, {"hive_db where (name = \"Reporting\") limit 10", 1}, {"hive_db where (name = \"Reporting\") select name as _col_0, owner as _col_1", 1}, {"hive_db where (name = \"Reporting\") select name as _col_0, owner as _col_1 limit 10", 1}, {"hive_db where hive_db is JdbcAccess", 0}, {"hive_db hive_table", 10}, {"hive_db hive_table limit 5", 5}, {"hive_db hive_table limit 5 offset 5", 5}, {"hive_db where hive_db has name", 3}, {"hive_db where hive_db has name limit 5", 3}, {"hive_db where hive_db has name limit 2 offset 0", 2}, {"hive_db where hive_db has name limit 2 offset 1", 2}, {"hive_db as db1 hive_table where (db1.name = \"Reporting\")", 0}, {"hive_db where (name = \"Reporting\") select name as _col_0, (createTime + 1) as _col_1 ", 1}, {"hive_db where (name = \"Reporting\") select name as _col_0, (createTime + 1) as _col_1 limit 10", 1}, {"hive_db where (name = \"Reporting\") select name as _col_0, (createTime + 1) as _col_1 limit 10 offset 1", 0}, {"hive_db where (name = \"Reporting\") select name as _col_0, (createTime + 1) as _col_1 limit 10 offset 0", 1}, {"hive_table where (name = \"sales_fact\" and createTime > \"2014-01-01\" ) select name as _col_0, createTime as _col_1 ", 1}, {"hive_table where (name = \"sales_fact\" and createTime > \"2014-01-01\" ) select name as _col_0, createTime as _col_1 limit 10 ", 1}, {"hive_table where (name = \"sales_fact\" and createTime > \"2014-01-01\" ) select name as _col_0, createTime as _col_1 limit 10 offset 0", 1}, {"hive_table where (name = \"sales_fact\" and createTime > \"2014-01-01\" ) select name as _col_0, createTime as _col_1 limit 10 offset 5", 0}, {"hive_table where (name = \"sales_fact\" and createTime >= \"2014-12-11T02:35:58.440Z\" ) select name as _col_0, createTime as _col_1 ", 1}, {"hive_table where (name = \"sales_fact\" and createTime >= \"2014-12-11T02:35:58.440Z\" ) select name as _col_0, createTime as _col_1 limit 10 offset 0", 1}, {"hive_table where (name = \"sales_fact\" and createTime >= \"2014-12-11T02:35:58.440Z\" ) select name as _col_0, createTime as _col_1 limit 10 offset 1", 0}, {"hive_table where (name = \"sales_fact\" and createTime >= \"2014-12-11T02:35:58.440Z\" ) select name as _col_0, createTime as _col_1 limit 10", 1}, {"hive_table where (name = \"sales_fact\" and createTime >= \"2014-12-11T02:35:58.440Z\" ) select name as _col_0, createTime as _col_1 limit 0 offset 1", 0}, {"Dimension", 5}, {"Dimension limit 2", 2}, {"Dimension limit 2 offset 1", 2}, {"Dimension limit 5 offset 4", 1}, {"JdbcAccess", 2}, {"JdbcAccess limit 5 offset 0", 2}, {"JdbcAccess limit 2 offset 1", 1}, {"JdbcAccess limit 1", 1}, {"ETL", 5}, {"ETL limit 2", 2}, {"ETL limit 1", 1}, {"ETL limit 1 offset 0", 1}, {"ETL limit 2 offset 1", 2}, {"Metric", 9}, {"Metric limit 10", 9}, {"Metric limit 2", 2}, {"Metric limit 10 offset 1", 8}, {"PII", 8}, {"PII limit 10", 8}, {"PII limit 2", 2}, {"PII limit 10 offset 1", 7}, {"`Log Data`", 4}, {"`Log Data` limit 3", 3}, {"`Log Data` limit 10 offset 2", 2}, {"hive_table where name='sales_fact', db where name='Sales'", 1}, {"hive_table where name='sales_fact', db where name='Sales' limit 10", 1}, {"hive_table where name='sales_fact', db where name='Sales' limit 10 offset 1", 0}, {"hive_table where name='sales_fact', db where name='Reporting'", 0}, {"hive_table where name='sales_fact', db where name='Reporting' limit 10", 0}, {"hive_table where name='sales_fact', db where name='Reporting' limit 10 offset 1", 0}, {"hive_partition as p where values = ['2015-01-01']", 1}, {"hive_partition as p where values = ['2015-01-01'] limit 10", 1}, {"hive_partition as p where values = ['2015-01-01'] limit 10 offset 1", 0}};
    }

    @DataProvider(name="dslOrderByQueriesProvider")
    private Object[][] createDSLQueriesWithOrderBy() {
        Boolean isAscending = Boolean.TRUE;
        return new Object[][]{{"hive_column select hive_column.name orderby name limit 10 withPath", 10, "name", isAscending}, {"hive_column select hive_column.name orderby name asc limit 10 withPath", 10, "name", isAscending}, {"hive_column select hive_column.name orderby 'hive_column.name' desc limit 10 withPath", 10, "name", isAscending == false}, {"from hive_db orderby owner limit 3", 3, "owner", isAscending}, {"hive_db where hive_db.name=\"Reporting\" orderby owner", 1, "owner", isAscending}, {"hive_db where hive_db.name=\"Reporting\" orderby owner limit 10", 1, "owner", isAscending}, {"hive_db where hive_db.name=\"Reporting\" select name, owner orderby name", 1, "name", isAscending}, {"hive_db has name orderby 'hive_db.owner' limit 10 offset 0", 3, "owner", isAscending}, {"from hive_table orderby owner", 10, "owner", isAscending}, {"from hive_table orderby 'hive_table.owner' limit 8", 8, "owner", isAscending}, {"hive_table orderby owner", 10, "owner", isAscending}, {"hive_table orderby owner limit 8", 8, "owner", isAscending}, {"hive_table orderby owner limit 8 offset 0", 8, "owner", isAscending}, {"hive_table orderby 'hive_table.owner' desc limit 8 offset 0", 8, "owner", isAscending == false}, {"hive_table isa Dimension orderby owner", 3, "owner", isAscending}, {"hive_table isa Dimension orderby owner limit 3", 3, "owner", isAscending}, {"hive_table isa Dimension orderby owner limit 3 offset 0", 3, "owner", isAscending}, {"hive_table isa Dimension orderby 'hive_table.owner' desc limit 3 offset 0", 3, "owner", isAscending == false}, {"hive_column where hive_column isa PII orderby name", 8, "name", isAscending}, {"hive_column where hive_column isa PII orderby name limit 5", 5, "name", isAscending}, {"hive_column where hive_column isa PII orderby name limit 5 offset 1", 5, "name", isAscending}, {"hive_column where hive_column isa PII orderby 'hive_column.name' desc limit 5 offset 1", 5, "name", isAscending == false}, {"hive_column select hive_column.name orderby name", 37, "hive_column.name", isAscending}, {"hive_column select hive_column.name orderby name limit 5", 5, "hive_column.name", isAscending}, {"hive_column select hive_column.name orderby name desc limit 5", 5, "hive_column.name", isAscending == false}, {"hive_column select hive_column.name orderby 'hive_column.name' limit 5 offset 36", 1, "hive_column.name", isAscending}, {"hive_column select name orderby name", 37, "name", isAscending}, {"hive_column select name orderby name limit 5", 5, "name", isAscending}, {"hive_column select name orderby 'hive_column.name' desc", 37, "name", isAscending == false}, {"hive_column where hive_column.name=\"customer_id\" orderby name", 6, "name", isAscending}, {"hive_column where hive_column.name=\"customer_id\" orderby name limit 2", 2, "name", isAscending}, {"hive_column where hive_column.name=\"customer_id\" orderby 'hive_column.name' limit 2 offset 1", 2, "name", isAscending}, {"from hive_table select owner orderby owner", 10, "owner", isAscending}, {"from hive_table select owner orderby owner limit 5", 5, "owner", isAscending}, {"from hive_table select owner orderby owner desc limit 5", 5, "owner", isAscending == false}, {"from hive_table select owner orderby 'hive_table.owner' limit 5 offset 5", 5, "owner", isAscending}, {"hive_db where (name = \"Reporting\") orderby name", 1, "name", isAscending}, {"hive_db where (name = \"Reporting\") orderby 'hive_db.name' limit 10", 1, "name", isAscending}, {"hive_db where (name = \"Reporting\") select name as _col_0, owner as _col_1 orderby '_col_1'", 1, "_col_1", isAscending}, {"hive_db where (name = \"Reporting\") select name as _col_0, owner as _col_1  orderby owner limit 10", 1, "_col_1", isAscending}, {"hive_db where hive_db has name orderby owner", 3, "owner", isAscending}, {"hive_db where hive_db has name orderby owner limit 5", 3, "owner", isAscending}, {"hive_db where hive_db has name orderby owner limit 2 offset 0", 2, "owner", isAscending}, {"hive_db where hive_db has name orderby 'hive_db.owner' limit 2 offset 1", 2, "owner", isAscending}, {"hive_db where (name = \"Reporting\") select name as _col_0, (createTime + 1) as _col_1 orderby '_col_1'", 1, "_col_1", isAscending}, {"hive_db where (name = \"Reporting\") select name as _col_0, (createTime + 1) as _col_1 orderby '_col_1' limit 10", 1, "_col_1", isAscending}, {"hive_db where (name = \"Reporting\") select name as _col_0, (createTime + 1) as _col_1 orderby '_col_1' limit 10 offset 1", 0, "_col_1", isAscending}, {"hive_db where (name = \"Reporting\") select name as _col_0, (createTime + 1) as _col_1 orderby '_col_1' limit 10 offset 0", 1, "_col_1", isAscending}, {"hive_table where (name = \"sales_fact\" and createTime > \"2014-01-01\" ) select name as _col_0, createTime as _col_1 orderby createTime", 1, "_col_1", isAscending}, {"hive_table where (name = \"sales_fact\" and createTime > \"2014-01-01\" ) select name as _col_0, createTime as _col_1 orderby createTime limit 10 ", 1, "_col_1", isAscending}, {"hive_table where (name = \"sales_fact\" and createTime > \"2014-01-01\" ) select name as _col_0, createTime as _col_1 orderby createTime limit 10 offset 0", 1, "_col_1", isAscending}, {"hive_table where (name = \"sales_fact\" and createTime > \"2014-01-01\" ) select name as _col_0, createTime as _col_1 orderby '_col_1' limit 10 offset 5", 0, "_col_1", isAscending}, {"hive_table where (name = \"sales_fact\" and createTime >= \"2014-12-11T02:35:58.440Z\" ) select name as _col_0, createTime as _col_1 orderby name", 1, "_col_0", isAscending}, {"hive_table where (name = \"sales_fact\" and createTime >= \"2014-12-11T02:35:58.440Z\" ) select name as _col_0, createTime as _col_1 orderby name limit 10 offset 0", 1, "_col_0", isAscending}, {"hive_table where (name = \"sales_fact\" and createTime >= \"2014-12-11T02:35:58.440Z\" ) select name as _col_0, createTime as _col_1 orderby name limit 10 offset 1", 0, "_col_0", isAscending}, {"hive_table where (name = \"sales_fact\" and createTime >= \"2014-12-11T02:35:58.440Z\" ) select name as _col_0, createTime as _col_1 orderby name limit 10", 1, "_col_0", isAscending}, {"hive_table where (name = \"sales_fact\" and createTime >= \"2014-12-11T02:35:58.440Z\" ) select name as _col_0, createTime as _col_1 orderby '_col_0' limit 0 offset 1", 0, "_col_0", isAscending}, {"hive_table orderby 'hive_table.owner_notdefined'", 10, null, isAscending}};
    }

    @Test(dataProvider="dslOrderByQueriesProvider")
    public void testSearchByDSLQueriesWithOrderBy(String dslQuery, Integer expectedNumRows, String orderBy, boolean ascending) throws Exception {
        System.out.println("Executing dslQuery = " + dslQuery);
        String jsonResults = this.searchByDSL(dslQuery);
        Assert.assertNotNull((Object)jsonResults);
        JSONObject results = new JSONObject(jsonResults);
        Assert.assertEquals((int)results.length(), (int)3);
        Object query = results.get("query");
        Assert.assertNotNull((Object)query);
        JSONObject dataType = results.getJSONObject("dataType");
        Assert.assertNotNull((Object)dataType);
        String typeName = dataType.getString("typeName");
        Assert.assertNotNull((Object)typeName);
        JSONArray rows = results.getJSONArray("rows");
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((int)rows.length(), (int)expectedNumRows);
        ArrayList<String> returnedList = new ArrayList<String>();
        for (int i = 0; i < rows.length(); ++i) {
            JSONObject row = rows.getJSONObject(i);
            try {
                returnedList.add(row.get(orderBy).toString());
                continue;
            }
            catch (Exception ex) {
                System.out.println(" Exception occured " + ex.getMessage());
            }
        }
        Iterator iter = returnedList.iterator();
        String _current = null;
        String _prev = null;
        if (orderBy != null) {
            while (iter.hasNext()) {
                _prev = _current;
                _current = ((String)iter.next()).toLowerCase();
                if (_prev == null || _prev.compareTo(_current) == 0) continue;
                if (ascending) {
                    Assert.assertTrue((_prev.compareTo(_current) < 0 ? 1 : 0) != 0);
                    continue;
                }
                Assert.assertTrue((_prev.compareTo(_current) > 0 ? 1 : 0) != 0);
            }
        }
        System.out.println("query [" + dslQuery + "] returned [" + rows.length() + "] rows");
    }

    @Test(dataProvider="dslQueriesProvider")
    public void testSearchByDSLQueries(String dslQuery, Integer expectedNumRows) throws Exception {
        this.runQuery(dslQuery, expectedNumRows, 40, 0);
    }

    @Test(dataProvider="comparisonQueriesProvider")
    public void testDataTypeComparisonQueries(String dslQuery, Integer expectedNumRows) throws Exception {
        this.runQuery(dslQuery, expectedNumRows, 40, 0);
    }

    @Test(dataProvider="dslExplicitLimitQueriesProvider")
    public void testSearchByDSLQueriesWithExplicitLimit(String dslQuery, Integer expectedNumRows, int limit, int offset) throws Exception {
        this.runQuery(dslQuery, expectedNumRows, limit, offset);
    }

    public void runQuery(String dslQuery, Integer expectedNumRows, int limitParam, int offsetParam) throws Exception {
        System.out.println("Executing dslQuery = " + dslQuery);
        String jsonResults = this.discoveryService.searchByDSL(dslQuery, new QueryParams(limitParam, offsetParam));
        Assert.assertNotNull((Object)jsonResults);
        JSONObject results = new JSONObject(jsonResults);
        Assert.assertEquals((int)results.length(), (int)3);
        System.out.println("results = " + results);
        Object query = results.get("query");
        Assert.assertNotNull((Object)query);
        JSONObject dataType = results.getJSONObject("dataType");
        Assert.assertNotNull((Object)dataType);
        String typeName = dataType.getString("typeName");
        Assert.assertNotNull((Object)typeName);
        JSONArray rows = results.getJSONArray("rows");
        Assert.assertNotNull((Object)rows);
        Assert.assertEquals((int)rows.length(), (int)expectedNumRows, (String)("query [" + dslQuery + "] returned [" + rows.length() + "] rows.  Expected " + expectedNumRows + " rows."));
        System.out.println("query [" + dslQuery + "] returned [" + rows.length() + "] rows");
    }

    @Test(dataProvider="dslLimitQueriesProvider")
    public void testSearchByDSLQueriesWithLimit(String dslQuery, Integer expectedNumRows) throws Exception {
        this.runQuery(dslQuery, expectedNumRows, 40, 0);
    }

    @DataProvider(name="invalidDslQueriesProvider")
    private Object[][] createInvalidDSLQueries() {
        return new String[][]{{"from Unknown"}, {"Unknown"}, {"Unknown is Blah"}};
    }

    @Test(dataProvider="invalidDslQueriesProvider", expectedExceptions={DiscoveryException.class})
    public void testSearchByDSLInvalidQueries(String dslQuery) throws Exception {
        System.out.println("Executing dslQuery = " + dslQuery);
        this.searchByDSL(dslQuery);
        Assert.fail();
    }

    @Test
    public void testSearchForTypeInheritance() throws Exception {
        this.createTypesWithMultiLevelInheritance();
        this.createInstances();
        String dslQuery = "from D where a = 1";
        String jsonResults = this.searchByDSL(dslQuery);
        Assert.assertNotNull((Object)jsonResults);
        JSONObject results = new JSONObject(jsonResults);
        System.out.println("results = " + results);
    }

    private void createTypesWithMultiLevelInheritance() throws Exception {
        HierarchicalTypeDefinition A = TypesUtil.createClassTypeDef((String)"A", null, (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createRequiredAttrDef((String)"a", (IDataType)DataTypes.INT_TYPE)});
        HierarchicalTypeDefinition B = TypesUtil.createClassTypeDef((String)"B", (ImmutableSet)ImmutableSet.of((Object)"A"), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)"b", (IDataType)DataTypes.BOOLEAN_TYPE)});
        HierarchicalTypeDefinition C = TypesUtil.createClassTypeDef((String)"C", (ImmutableSet)ImmutableSet.of((Object)"B"), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)"c", (IDataType)DataTypes.BYTE_TYPE)});
        HierarchicalTypeDefinition D = TypesUtil.createClassTypeDef((String)"D", (ImmutableSet)ImmutableSet.of((Object)"C"), (AttributeDefinition[])new AttributeDefinition[]{TypesUtil.createOptionalAttrDef((String)"d", (IDataType)DataTypes.SHORT_TYPE)});
        TypeSystem.getInstance().defineClassTypes(new HierarchicalTypeDefinition[]{A, B, C, D});
    }

    private void createInstances() throws Exception {
        Referenceable instance = new Referenceable("D", new String[0]);
        instance.set("d", (Object)1);
        instance.set("c", (Object)1);
        instance.set("b", (Object)true);
        instance.set("a", (Object)1);
        ClassType deptType = (ClassType)TypeSystem.getInstance().getDataType(ClassType.class, "D");
        ITypedReferenceableInstance typedInstance = deptType.convert((Object)instance, Multiplicity.REQUIRED);
        this.repositoryService.createEntities(new ITypedReferenceableInstance[]{typedInstance});
    }
}

